/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import com.google.gson.Gson;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.listener.ServerInitListener;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.CreateNewFolderByNameRespons;
import kohgylw.kiftd.server.pojo.FolderCountResult;
import kohgylw.kiftd.server.service.FolderService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileNodeUtil;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.IpAddrGetter;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import kohgylw.kiftd.server.util.TextFormateUtil;
import org.springframework.stereotype.Service;

@Service
public class FolderServiceImpl
implements FolderService {
    @Resource
    private FolderMapper fm;
    @Resource
    private NodeMapper nm;
    @Resource
    private FolderUtil fu;
    @Resource
    private LogUtil lu;
    @Resource
    private Gson gson;
    @Resource
    private IpAddrGetter idg;

    @Override
    public String newFolder(HttpServletRequest request) {
        String parentId = request.getParameter("parentId");
        String folderName = request.getParameter("folderName");
        String folderConstraint = request.getParameter("folderConstraint");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (parentId == null || folderName == null || parentId.length() <= 0 || folderName.length() <= 0) {
            return "errorParameter";
        }
        if (!TextFormateUtil.instance().matcherFolderName(folderName) || folderName.indexOf(".") == 0) {
            return "errorParameter";
        }
        Folder parentFolder = this.fm.queryById(parentId);
        if (parentFolder == null || !ConfigureReader.instance().accessFolder(parentFolder, account)) {
            return "errorParameter";
        }
        if (!ConfigureReader.instance().authorized(account, AccountAuth.CREATE_NEW_FOLDER, this.fu.getAllFoldersId(parentId))) {
            return "noAuthorized";
        }
        if (this.fm.queryByParentId(parentId).parallelStream().anyMatch(e -> e.getFolderName().equals(folderName))) {
            return "nameOccupied";
        }
        if (this.fm.countByParentId(parentId) >= Integer.MAX_VALUE) {
            return "foldersTotalOutOfLimit";
        }
        Folder f = new Folder();
        int pc = parentFolder.getFolderConstraint();
        if (folderConstraint != null) {
            try {
                int ifc = Integer.parseInt(folderConstraint);
                if (ifc != 0 && account == null) {
                    return "errorParameter";
                }
                if (ifc < pc) {
                    return "errorParameter";
                }
                f.setFolderConstraint(ifc);
            }
            catch (Exception e2) {
                return "errorParameter";
            }
        } else {
            return "errorParameter";
        }
        f.setFolderId(UUID.randomUUID().toString());
        f.setFolderName(folderName);
        f.setFolderCreationDate(ServerTimeUtil.accurateToDay());
        if (account != null) {
            f.setFolderCreator(account);
        } else {
            f.setFolderCreator("\u533f\u540d\u7528\u6237");
        }
        f.setFolderParent(parentId);
        int i = 0;
        while (true) {
            try {
                int r = this.fm.insertNewFolder(f);
                if (r > 0) {
                    if (this.fu.isValidFolder(f)) {
                        this.lu.writeCreateFolderEvent(account, this.idg.getIpAddr(request), f);
                        return "createFolderSuccess";
                    }
                    return "cannotCreateFolder";
                }
            }
            catch (Exception e3) {
                f.setFolderId(UUID.randomUUID().toString());
                if (++i < 10) continue;
            }
            break;
        }
        return "cannotCreateFolder";
    }

    @Override
    public String deleteFolder(HttpServletRequest request) {
        String folderId = request.getParameter("folderId");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (folderId == null || folderId.length() == 0 || "root".equals(folderId)) {
            return "errorParameter";
        }
        Folder folder = this.fm.queryById(folderId);
        if (folder == null) {
            return "deleteFolderSuccess";
        }
        if (!ConfigureReader.instance().accessFolder(folder, account)) {
            return "noAuthorized";
        }
        if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(folder.getFolderParent()))) {
            return "noAuthorized";
        }
        List<Folder> l = this.fu.getParentList(folderId);
        if (this.fm.deleteById(folderId) > 0) {
            this.fu.deleteAllChildFolder(folderId);
            this.lu.writeDeleteFolderEvent(request, folder, l);
            ServerInitListener.needCheck = true;
            return "deleteFolderSuccess";
        }
        return "cannotDeleteFolder";
    }

    @Override
    public String renameFolder(HttpServletRequest request) {
        String folderId = request.getParameter("folderId");
        String newName = request.getParameter("newName");
        String folderConstraint = request.getParameter("folderConstraint");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (folderId == null || folderId.length() == 0 || newName == null || newName.length() == 0 || "root".equals(folderId)) {
            return "errorParameter";
        }
        if (!TextFormateUtil.instance().matcherFolderName(newName) || newName.indexOf(".") == 0) {
            return "errorParameter";
        }
        Folder folder = this.fm.queryById(folderId);
        if (folder == null) {
            return "errorParameter";
        }
        if (!ConfigureReader.instance().accessFolder(folder, account)) {
            return "noAuthorized";
        }
        if (!ConfigureReader.instance().authorized(account, AccountAuth.RENAME_FILE_OR_FOLDER, this.fu.getAllFoldersId(folder.getFolderParent()))) {
            return "noAuthorized";
        }
        Folder parentFolder = this.fm.queryById(folder.getFolderParent());
        int pc = parentFolder.getFolderConstraint();
        if (folderConstraint != null) {
            try {
                int ifc = Integer.parseInt(folderConstraint);
                if (ifc > 0 && account == null) {
                    return "errorParameter";
                }
                if (ifc < pc) {
                    return "errorParameter";
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("newConstraint", ifc);
                map.put("folderId", folderId);
                this.fm.updateFolderConstraintById(map);
                this.fu.changeChildFolderConstraint(folderId, ifc);
                if (!folder.getFolderName().equals(newName)) {
                    if (this.fm.queryByParentId(parentFolder.getFolderId()).parallelStream().anyMatch(e -> e.getFolderName().equals(newName))) {
                        return "nameOccupied";
                    }
                    HashMap<String, String> map2 = new HashMap<String, String>();
                    map2.put("folderId", folderId);
                    map2.put("newName", newName);
                    if (this.fm.updateFolderNameById(map2) == 0) {
                        return "errorParameter";
                    }
                }
                this.lu.writeRenameFolderEvent(account, this.idg.getIpAddr(request), folder.getFolderId(), folder.getFolderName(), newName, folder.getFolderConstraint() + "", folderConstraint);
                return "renameFolderSuccess";
            }
            catch (Exception e2) {
                return "errorParameter";
            }
        }
        return "errorParameter";
    }

    @Override
    public String deleteFolderByName(HttpServletRequest request) {
        Folder[] repeatFolders;
        String parentId = request.getParameter("parentId");
        String folderName = request.getParameter("folderName");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (parentId == null || parentId.length() == 0) {
            return "deleteError";
        }
        Folder p = this.fm.queryById(parentId);
        if (p == null) {
            return "deleteError";
        }
        if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(parentId)) || !ConfigureReader.instance().accessFolder(p, account)) {
            return "deleteError";
        }
        for (Folder rf : repeatFolders = (Folder[])this.fm.queryByParentId(parentId).parallelStream().filter(f -> f.getFolderName().equals(new String(folderName.getBytes(Charset.forName("UTF-8")), Charset.forName("UTF-8")))).toArray(Folder[]::new)) {
            if (!ConfigureReader.instance().accessFolder(rf, account)) {
                return "deleteError";
            }
            List<Folder> l = this.fu.getParentList(rf.getFolderId());
            if (this.fm.deleteById(rf.getFolderId()) <= 0) {
                return "deleteError";
            }
            this.fu.deleteAllChildFolder(rf.getFolderId());
            this.lu.writeDeleteFolderEvent(request, rf, l);
        }
        ServerInitListener.needCheck = true;
        return "deleteSuccess";
    }

    @Override
    public String createNewFolderByName(HttpServletRequest request) {
        String parentId = request.getParameter("parentId");
        String folderName = request.getParameter("folderName");
        String folderConstraint = request.getParameter("folderConstraint");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        CreateNewFolderByNameRespons cnfbnr = new CreateNewFolderByNameRespons();
        if (parentId == null || folderName == null || parentId.length() <= 0 || folderName.length() <= 0) {
            cnfbnr.setResult("error");
            return this.gson.toJson((Object)cnfbnr);
        }
        if (folderName.equals(".") || folderName.equals("..")) {
            cnfbnr.setResult("error");
            return this.gson.toJson((Object)cnfbnr);
        }
        Folder parentFolder = this.fm.queryById(parentId);
        if (parentFolder == null || !ConfigureReader.instance().accessFolder(parentFolder, account)) {
            cnfbnr.setResult("error");
            return this.gson.toJson((Object)cnfbnr);
        }
        if (!ConfigureReader.instance().authorized(account, AccountAuth.CREATE_NEW_FOLDER, this.fu.getAllFoldersId(parentId))) {
            cnfbnr.setResult("error");
            return this.gson.toJson((Object)cnfbnr);
        }
        if (this.fm.countByParentId(parentId) >= Integer.MAX_VALUE) {
            cnfbnr.setResult("foldersTotalOutOfLimit");
            return this.gson.toJson((Object)cnfbnr);
        }
        Folder f = new Folder();
        if (!this.fm.queryByParentId(parentId).parallelStream().anyMatch(e -> e.getFolderName().equals(folderName))) {
            cnfbnr.setResult("error");
            return this.gson.toJson((Object)cnfbnr);
        }
        f.setFolderName(FileNodeUtil.getNewFolderName(folderName, this.fm.queryByParentId(parentId)));
        int pc = parentFolder.getFolderConstraint();
        if (folderConstraint != null) {
            try {
                int ifc = Integer.parseInt(folderConstraint);
                if (ifc != 0 && account == null) {
                    cnfbnr.setResult("error");
                    return this.gson.toJson((Object)cnfbnr);
                }
                if (ifc < pc) {
                    cnfbnr.setResult("error");
                    return this.gson.toJson((Object)cnfbnr);
                }
                f.setFolderConstraint(ifc);
            }
            catch (Exception e2) {
                cnfbnr.setResult("error");
                return this.gson.toJson((Object)cnfbnr);
            }
        } else {
            cnfbnr.setResult("error");
            return this.gson.toJson((Object)cnfbnr);
        }
        f.setFolderId(UUID.randomUUID().toString());
        f.setFolderCreationDate(ServerTimeUtil.accurateToDay());
        if (account != null) {
            f.setFolderCreator(account);
        } else {
            f.setFolderCreator("\u533f\u540d\u7528\u6237");
        }
        f.setFolderParent(parentId);
        int i = 0;
        while (true) {
            try {
                int r = this.fm.insertNewFolder(f);
                if (r > 0) {
                    if (this.fu.isValidFolder(f)) {
                        this.lu.writeCreateFolderEvent(account, this.idg.getIpAddr(request), f);
                        cnfbnr.setResult("success");
                        cnfbnr.setNewName(f.getFolderName());
                        return this.gson.toJson((Object)cnfbnr);
                    }
                    cnfbnr.setResult("error");
                    return this.gson.toJson((Object)cnfbnr);
                }
            }
            catch (Exception e3) {
                f.setFolderId(UUID.randomUUID().toString());
                if (++i < 10) continue;
            }
            break;
        }
        cnfbnr.setResult("error");
        return this.gson.toJson((Object)cnfbnr);
    }

    @Override
    public String getFolderCountResult(HttpServletRequest request) {
        String folderId = request.getParameter("folderId");
        if (folderId == null || folderId.length() == 0) {
            return "ERROR";
        }
        Folder vf = this.fm.queryById(folderId);
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (!ConfigureReader.instance().accessFolder(vf, account)) {
            return "ERROR";
        }
        FolderCountResult fcr = new FolderCountResult();
        this.countFoldersIterator(folderId, account, fcr);
        return this.gson.toJson((Object)fcr);
    }

    private void countFoldersIterator(String fid, String account, FolderCountResult fcr) {
        long folderSize = 0L;
        for (Folder f : this.fm.queryByParentId(fid)) {
            if (!ConfigureReader.instance().accessFolder(f, account)) continue;
            ++folderSize;
            this.countFoldersIterator(f.getFolderId(), account, fcr);
        }
        fcr.setFolderNum(fcr.getFolderNum() + folderSize);
        List<Node> nodes = this.nm.queryByParentFolderId(fid);
        fcr.setFileNum(fcr.getFileNum() + (long)nodes.size());
        long fileSize = 0L;
        for (Node n : nodes) {
            fileSize += Long.parseLong(n.getFileSize());
        }
        fcr.setTotalSize(fcr.getTotalSize() + fileSize);
    }
}

