/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.exception.FoldersTotalOutOfLimitException;
import kohgylw.kiftd.server.listener.ServerInitListener;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.CheckImportFolderRespons;
import kohgylw.kiftd.server.pojo.CheckUploadFilesRespons;
import kohgylw.kiftd.server.service.FileService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.FileNodeUtil;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.IpAddrGetter;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.RangeFileStreamWriter;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import kohgylw.kiftd.server.util.TextFormateUtil;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileServiceImpl
extends RangeFileStreamWriter
implements FileService {
    private static final String FOLDERS_TOTAL_OUT_OF_LIMIT = "foldersTotalOutOfLimit";
    private static final String FILES_TOTAL_OUT_OF_LIMIT = "filesTotalOutOfLimit";
    private static final String ERROR_PARAMETER = "errorParameter";
    private static final String NO_AUTHORIZED = "noAuthorized";
    private static final String UPLOADSUCCESS = "uploadsuccess";
    private static final String UPLOADERROR = "uploaderror";
    @Resource
    private NodeMapper fm;
    @Resource
    private FolderMapper flm;
    @Resource
    private LogUtil lu;
    @Resource
    private Gson gson;
    @Resource
    private FileBlockUtil fbu;
    @Resource
    private FolderUtil fu;
    @Resource
    private IpAddrGetter idg;
    private static final String CONTENT_TYPE = "application/octet-stream";

    @Override
    public String checkUploadFile(HttpServletRequest request, HttpServletResponse response) {
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        String folderId = request.getParameter("folderId");
        String nameList = request.getParameter("namelist");
        String maxUploadFileSize = request.getParameter("maxSize");
        String maxUploadFileIndex = request.getParameter("maxFileIndex");
        if (folderId == null || folderId.length() == 0) {
            return ERROR_PARAMETER;
        }
        Folder folder = this.flm.queryById(folderId);
        if (folder == null) {
            return ERROR_PARAMETER;
        }
        if (!ConfigureReader.instance().authorized(account, AccountAuth.UPLOAD_FILES, this.fu.getAllFoldersId(folderId)) || !ConfigureReader.instance().accessFolder(folder, account)) {
            return NO_AUTHORIZED;
        }
        List namelistObj = (List)this.gson.fromJson(nameList, new TypeToken<List<String>>(){}.getType());
        CheckUploadFilesRespons cufr = new CheckUploadFilesRespons();
        try {
            long mufs = Long.parseLong(maxUploadFileSize);
            String mfname = (String)namelistObj.get(Integer.parseInt(maxUploadFileIndex));
            long pMaxUploadSize = ConfigureReader.instance().getUploadFileSize(account);
            if (pMaxUploadSize >= 0L && mufs > pMaxUploadSize) {
                cufr.setCheckResult("fileTooLarge");
                cufr.setMaxUploadFileSize(this.formatMaxUploadFileSize(pMaxUploadSize));
                cufr.setOverSizeFile(mfname);
                return this.gson.toJson((Object)cufr);
            }
        }
        catch (Exception e) {
            return ERROR_PARAMETER;
        }
        ArrayList<String> pereFileNameList = new ArrayList<String>();
        for (String fileName : namelistObj) {
            if (folderId == null || folderId.length() <= 0 || fileName == null || fileName.length() <= 0) {
                return ERROR_PARAMETER;
            }
            List<Node> files = this.fm.queryByParentFolderId(folderId);
            if (!((Stream)files.stream().parallel()).anyMatch(n -> n.getFileName().equals(fileName))) continue;
            pereFileNameList.add(fileName);
        }
        long estimatedTotal = this.fm.countByParentFolderId(folderId) - (long)pereFileNameList.size() + (long)namelistObj.size();
        if (estimatedTotal > Integer.MAX_VALUE || estimatedTotal < 0L) {
            return FILES_TOTAL_OUT_OF_LIMIT;
        }
        if (pereFileNameList.size() > 0) {
            cufr.setCheckResult("hasExistsNames");
            cufr.setPereFileNameList(pereFileNameList);
        } else {
            cufr.setCheckResult("permitUpload");
            cufr.setPereFileNameList(new ArrayList<String>());
        }
        return this.gson.toJson((Object)cufr);
    }

    private String formatMaxUploadFileSize(long size) {
        double result = size;
        String unit = "B";
        if (size <= 0L) {
            return "\u8bbe\u7f6e\u65e0\u6548\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        if (size >= 1024L && size < 0x100000L) {
            result = (double)size / 1024.0;
            unit = "KB";
        } else if (size >= 0x100000L && size < 0x40000000L) {
            result = (double)size / 1048576.0;
            unit = "MB";
        } else if (size >= 0x40000000L) {
            result = (double)size / 1.073741824E9;
            unit = "GB";
        }
        return String.format("%.1f", result) + " " + unit;
    }

    @Override
    public String doUploadFile(HttpServletRequest request, HttpServletResponse response, MultipartFile file) {
        String fileName;
        String folderId;
        String account;
        block19: {
            block20: {
                String originalFileName;
                account = (String)request.getSession().getAttribute("ACCOUNT");
                folderId = request.getParameter("folderId");
                String fname = request.getParameter("fname");
                fileName = originalFileName = fname != null ? fname : file.getOriginalFilename();
                String repeType = request.getParameter("repeType");
                if (folderId == null || folderId.length() <= 0 || originalFileName == null || originalFileName.length() <= 0) {
                    return UPLOADERROR;
                }
                Folder folder = this.flm.queryById(folderId);
                if (folder == null) {
                    return UPLOADERROR;
                }
                if (!ConfigureReader.instance().authorized(account, AccountAuth.UPLOAD_FILES, this.fu.getAllFoldersId(folderId)) || !ConfigureReader.instance().accessFolder(folder, account)) {
                    return UPLOADERROR;
                }
                long mufs = ConfigureReader.instance().getUploadFileSize(account);
                if (mufs >= 0L && file.getSize() > mufs) {
                    return UPLOADERROR;
                }
                List<Node> nodes = this.fm.queryByParentFolderId(folderId);
                if (!nodes.parallelStream().anyMatch(e -> e.getFileName().equals(originalFileName))) break block19;
                if (repeType == null) break block20;
                switch (repeType) {
                    case "skip": {
                        return UPLOADSUCCESS;
                    }
                    case "cover": {
                        if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(folderId))) {
                            return UPLOADERROR;
                        }
                        for (Node f : nodes) {
                            if (!f.getFileName().equals(originalFileName) || this.fbu.deleteNode(f)) continue;
                            return UPLOADERROR;
                        }
                        break block19;
                    }
                    case "both": {
                        fileName = FileNodeUtil.getNewNodeName(originalFileName, nodes);
                        break;
                    }
                    default: {
                        return UPLOADERROR;
                    }
                }
                break block19;
            }
            return UPLOADERROR;
        }
        if (this.fm.countByParentFolderId(folderId) >= Integer.MAX_VALUE) {
            return FILES_TOTAL_OUT_OF_LIMIT;
        }
        File block = this.fbu.saveToFileBlocks(file);
        if (block == null) {
            return UPLOADERROR;
        }
        String fsize = this.fbu.getFileSize(file.getSize());
        Node newNode = this.fbu.insertNewNode(fileName, account, block.getName(), fsize, folderId);
        if (newNode != null) {
            this.lu.writeUploadFileEvent(request, newNode, account);
            return UPLOADSUCCESS;
        }
        block.delete();
        return UPLOADERROR;
    }

    @Override
    public String deleteFile(HttpServletRequest request) {
        String fileId = request.getParameter("fileId");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (fileId == null || fileId.length() <= 0) {
            return ERROR_PARAMETER;
        }
        Node node = this.fm.queryById(fileId);
        if (node == null) {
            return "deleteFileSuccess";
        }
        Folder f = this.flm.queryById(node.getFileParentFolder());
        if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(node.getFileParentFolder())) || !ConfigureReader.instance().accessFolder(f, account)) {
            return NO_AUTHORIZED;
        }
        if (this.fbu.deleteNode(node)) {
            this.lu.writeDeleteFileEvent(request, node);
            return "deleteFileSuccess";
        }
        return "cannotDeleteFile";
    }

    @Override
    public void doDownloadFile(HttpServletRequest request, HttpServletResponse response) {
        Node f;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        String fileId = request.getParameter("fileId");
        if (fileId != null && (f = this.fm.queryById(fileId)) != null && ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(f.getFileParentFolder()))) {
            Folder folder = this.flm.queryById(f.getFileParentFolder());
            if (ConfigureReader.instance().accessFolder(folder, account)) {
                File fo = this.fbu.getFileFromBlocks(f);
                String ip = this.idg.getIpAddr(request);
                String range = request.getHeader("Range");
                if (fo != null) {
                    int status = FileServiceImpl.writeRangeFileStream(request, response, fo, f.getFileName(), CONTENT_TYPE, ConfigureReader.instance().getDownloadMaxRate(account), this.fbu.getETag(fo), true);
                    if (status == 200 || range != null && range.startsWith("bytes=0-")) {
                        this.lu.writeDownloadFileEvent(account, ip, f);
                    }
                    return;
                }
            }
        }
        try {
            response.sendError(404);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String doRenameFile(HttpServletRequest request) {
        String fileId = request.getParameter("fileId");
        String newFileName = request.getParameter("newFileName");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (fileId == null || fileId.length() <= 0 || newFileName == null || newFileName.length() <= 0) {
            return ERROR_PARAMETER;
        }
        if (!TextFormateUtil.instance().matcherFileName(newFileName) || newFileName.indexOf(".") == 0) {
            return ERROR_PARAMETER;
        }
        Node file = this.fm.queryById(fileId);
        if (file == null) {
            return ERROR_PARAMETER;
        }
        Folder folder = this.flm.queryById(file.getFileParentFolder());
        if (!ConfigureReader.instance().accessFolder(folder, account)) {
            return NO_AUTHORIZED;
        }
        if (!ConfigureReader.instance().authorized(account, AccountAuth.RENAME_FILE_OR_FOLDER, this.fu.getAllFoldersId(file.getFileParentFolder()))) {
            return NO_AUTHORIZED;
        }
        if (!file.getFileName().equals(newFileName)) {
            if (this.fm.queryBySomeFolder(fileId).parallelStream().anyMatch(e -> e.getFileName().equals(newFileName))) {
                return "nameOccupied";
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fileId", fileId);
            map.put("newFileName", newFileName);
            if (this.fm.updateFileNameById(map) == 0) {
                return "cannotRenameFile";
            }
        }
        this.lu.writeRenameFileEvent(account, this.idg.getIpAddr(request), file.getFileParentFolder(), file.getFileName(), newFileName);
        return "renameFileSuccess";
    }

    @Override
    public String deleteCheckedFiles(HttpServletRequest request) {
        String strIdList = request.getParameter("strIdList");
        String strFidList = request.getParameter("strFidList");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        try {
            Folder folder;
            List idList = (List)this.gson.fromJson(strIdList, new TypeToken<List<String>>(){}.getType());
            for (String fileId : idList) {
                if (fileId == null || fileId.length() == 0) {
                    return ERROR_PARAMETER;
                }
                Node file = this.fm.queryById(fileId);
                if (file == null) continue;
                folder = this.flm.queryById(file.getFileParentFolder());
                if (!ConfigureReader.instance().accessFolder(folder, account)) {
                    return NO_AUTHORIZED;
                }
                if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(file.getFileParentFolder()))) {
                    return NO_AUTHORIZED;
                }
                if (!this.fbu.deleteNode(file)) {
                    return "cannotDeleteFile";
                }
                this.lu.writeDeleteFileEvent(request, file);
            }
            List fidList = (List)this.gson.fromJson(strFidList, new TypeToken<List<String>>(){}.getType());
            for (String fid : fidList) {
                folder = this.flm.queryById(fid);
                if (folder == null) continue;
                if (!ConfigureReader.instance().accessFolder(folder, account)) {
                    return NO_AUTHORIZED;
                }
                if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(folder.getFolderParent()))) {
                    return NO_AUTHORIZED;
                }
                List<Folder> l = this.fu.getParentList(fid);
                if (this.flm.deleteById(fid) <= 0) {
                    return "cannotDeleteFile";
                }
                this.fu.deleteAllChildFolder(fid);
                this.lu.writeDeleteFolderEvent(request, folder, l);
            }
            if (fidList.size() > 0) {
                ServerInitListener.needCheck = true;
            }
            return "deleteFileSuccess";
        }
        catch (Exception e) {
            return ERROR_PARAMETER;
        }
    }

    @Override
    public String downloadCheckedFiles(HttpServletRequest request) {
        if (ConfigureReader.instance().isEnableDownloadByZip()) {
            String account = (String)request.getSession().getAttribute("ACCOUNT");
            String strIdList = request.getParameter("strIdList");
            String strFidList = request.getParameter("strFidList");
            try {
                List idList = (List)this.gson.fromJson(strIdList, new TypeToken<List<String>>(){}.getType());
                List fidList = (List)this.gson.fromJson(strFidList, new TypeToken<List<String>>(){}.getType());
                if (idList.size() > 0 || fidList.size() > 0) {
                    String zipname = this.fbu.createZip(idList, fidList, account);
                    this.lu.writeDownloadCheckedFileEvent(request, idList, fidList);
                    return zipname;
                }
            }
            catch (Exception ex) {
                this.lu.writeException(ex);
            }
        }
        return "ERROR";
    }

    @Override
    public void downloadCheckedFilesZip(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String zipname = request.getParameter("zipId");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (zipname != null && !zipname.equals("ERROR")) {
            String tfPath = ConfigureReader.instance().getTemporaryfilePath();
            File zip = new File(tfPath, zipname);
            String fname = "kiftd_" + ServerTimeUtil.accurateToDay() + "_\u6253\u5305\u4e0b\u8f7d.zip";
            if (zip.exists()) {
                FileServiceImpl.writeRangeFileStream(request, response, zip, fname, CONTENT_TYPE, ConfigureReader.instance().getDownloadMaxRate(account), this.fbu.getETag(zip), true);
                zip.delete();
            }
        }
    }

    @Override
    public String getPackTime(HttpServletRequest request) {
        if (ConfigureReader.instance().isEnableDownloadByZip()) {
            String account = (String)request.getSession().getAttribute("ACCOUNT");
            String strIdList = request.getParameter("strIdList");
            String strFidList = request.getParameter("strFidList");
            try {
                List idList = (List)this.gson.fromJson(strIdList, new TypeToken<List<String>>(){}.getType());
                List fidList = (List)this.gson.fromJson(strFidList, new TypeToken<List<String>>(){}.getType());
                for (String fid : fidList) {
                    this.countFolderFilesId(account, fid, idList);
                }
                long packTime = 0L;
                for (String fid : idList) {
                    File f;
                    Node n = this.fm.queryById(fid);
                    if (!ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(n.getFileParentFolder())) || !ConfigureReader.instance().accessFolder(this.flm.queryById(n.getFileParentFolder()), account) || (f = this.fbu.getFileFromBlocks(n)) == null || !f.exists()) continue;
                    packTime += f.length() / 25000000L;
                }
                if (packTime < 4L) {
                    return "\u9a6c\u4e0a\u5b8c\u6210";
                }
                if (packTime >= 4L && packTime < 10L) {
                    return "\u5927\u7ea610\u79d2";
                }
                if (packTime >= 10L && packTime < 35L) {
                    return "\u4e0d\u5230\u534a\u5206\u949f";
                }
                if (packTime >= 35L && packTime < 65L) {
                    return "\u5927\u7ea61\u5206\u949f";
                }
                if (packTime >= 65L) {
                    return "\u8d85\u8fc7" + packTime / 60L + "\u5206\u949f\uff0c\u8017\u65f6\u8f83\u957f\uff0c\u5efa\u8bae\u76f4\u63a5\u4e0b\u8f7d";
                }
            }
            catch (Exception ex) {
                this.lu.writeException(ex);
            }
        }
        return "0";
    }

    private void countFolderFilesId(String account, String fid, List<String> idList) {
        Folder f = this.flm.queryById(fid);
        if (ConfigureReader.instance().accessFolder(f, account)) {
            try {
                idList.addAll(Arrays.asList(this.fm.queryByParentFolderId(fid).parallelStream().map(e -> e.getFileId()).toArray(String[]::new)));
                List<Folder> cFolders = this.flm.queryByParentId(fid);
                for (Folder cFolder : cFolders) {
                    this.countFolderFilesId(account, cFolder.getFolderId(), idList);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String doMoveFiles(HttpServletRequest request) {
        String strIdList = request.getParameter("strIdList");
        String strFidList = request.getParameter("strFidList");
        String strOptMap = request.getParameter("strOptMap");
        String locationpath = request.getParameter("locationpath");
        String method = request.getParameter("method");
        boolean isCopy = "COPY".equals(method);
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        Folder targetFolder = this.flm.queryById(locationpath);
        if (targetFolder == null) {
            return ERROR_PARAMETER;
        }
        if (!ConfigureReader.instance().accessFolder(targetFolder, account)) {
            return NO_AUTHORIZED;
        }
        if (!ConfigureReader.instance().authorized(account, AccountAuth.MOVE_FILES, this.fu.getAllFoldersId(locationpath))) {
            return NO_AUTHORIZED;
        }
        try {
            String ip;
            String originPath;
            Map optMap = (Map)this.gson.fromJson(strOptMap, new TypeToken<Map<String, String>>(){}.getType());
            List idList = (List)this.gson.fromJson(strIdList, new TypeToken<List<String>>(){}.getType());
            List fidList = (List)this.gson.fromJson(strFidList, new TypeToken<List<String>>(){}.getType());
            if (fidList.size() > 0 && !ConfigureReader.instance().authorized(account, AccountAuth.CREATE_NEW_FOLDER, this.fu.getAllFoldersId(locationpath))) {
                return NO_AUTHORIZED;
            }
            block22: for (String id : idList) {
                if (id == null || id.length() <= 0) {
                    return ERROR_PARAMETER;
                }
                Node node = this.fm.queryById(id);
                if (node == null) {
                    return ERROR_PARAMETER;
                }
                if (node.getFileParentFolder().equals(locationpath) && !isCopy) continue;
                if (!ConfigureReader.instance().accessFolder(this.flm.queryById(node.getFileParentFolder()), account)) {
                    return NO_AUTHORIZED;
                }
                if (!ConfigureReader.instance().authorized(account, AccountAuth.MOVE_FILES, this.fu.getAllFoldersId(node.getFileParentFolder()))) {
                    return NO_AUTHORIZED;
                }
                if (!isCopy && !ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(node.getFileParentFolder()))) {
                    return NO_AUTHORIZED;
                }
                originPath = this.fbu.getNodePath(node);
                ip = this.idg.getIpAddr(request);
                if (this.fm.queryByParentFolderId(locationpath).parallelStream().anyMatch(e -> e.getFileName().equals(node.getFileName()))) {
                    if (optMap.get(id) == null) {
                        return ERROR_PARAMETER;
                    }
                    switch ((String)optMap.get(id)) {
                        case "cover": {
                            Node copyNode;
                            if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(locationpath))) {
                                return NO_AUTHORIZED;
                            }
                            Node n = this.fm.queryByParentFolderId(locationpath).parallelStream().filter(e -> e.getFileName().equals(node.getFileName())).findFirst().get();
                            if (n.getFileId().equals(node.getFileId())) continue block22;
                            if (this.fbu.deleteNode(n)) {
                                if (isCopy) {
                                    copyNode = this.fbu.insertNewNode(node.getFileName(), account, node.getFilePath(), node.getFileSize(), locationpath);
                                    if (copyNode == null) {
                                        return "cannotMoveFiles";
                                    }
                                    this.lu.writeMoveFileEvent(account, ip, originPath, this.fbu.getNodePath(copyNode), isCopy);
                                    break;
                                }
                                node.setFileParentFolder(locationpath);
                                if (this.fm.update(node) <= 0) {
                                    return "cannotMoveFiles";
                                }
                                this.lu.writeMoveFileEvent(account, ip, originPath, this.fbu.getNodePath(node), isCopy);
                                break;
                            }
                            return "cannotMoveFiles";
                        }
                        case "both": {
                            Node copyNode;
                            if (this.fm.countByParentFolderId(locationpath) >= Integer.MAX_VALUE) {
                                return FILES_TOTAL_OUT_OF_LIMIT;
                            }
                            if (isCopy) {
                                copyNode = this.fbu.insertNewNode(FileNodeUtil.getNewNodeName(node.getFileName(), this.fm.queryByParentFolderId(locationpath)), account, node.getFilePath(), node.getFileSize(), locationpath);
                                if (copyNode == null) {
                                    return "cannotMoveFiles";
                                }
                                this.lu.writeMoveFileEvent(account, ip, originPath, this.fbu.getNodePath(copyNode), isCopy);
                                break;
                            }
                            node.setFileName(FileNodeUtil.getNewNodeName(node.getFileName(), this.fm.queryByParentFolderId(locationpath)));
                            node.setFileParentFolder(locationpath);
                            if (this.fm.update(node) <= 0) {
                                return "cannotMoveFiles";
                            }
                            this.lu.writeMoveFileEvent(account, ip, originPath, this.fbu.getNodePath(node), isCopy);
                            break;
                        }
                        case "skip": {
                            break;
                        }
                        default: {
                            return ERROR_PARAMETER;
                        }
                    }
                    continue;
                }
                if (this.fm.countByParentFolderId(locationpath) >= Integer.MAX_VALUE) {
                    return FILES_TOTAL_OUT_OF_LIMIT;
                }
                if (isCopy) {
                    Node newNode = this.fbu.insertNewNode(node.getFileName(), account, node.getFilePath(), node.getFileSize(), locationpath);
                    if (newNode == null) {
                        return "cannotMoveFiles";
                    }
                    this.lu.writeMoveFileEvent(account, ip, originPath, this.fbu.getNodePath(newNode), isCopy);
                    continue;
                }
                node.setFileParentFolder(locationpath);
                if (this.fm.update(node) <= 0) {
                    return "cannotMoveFiles";
                }
                this.lu.writeMoveFileEvent(account, ip, originPath, this.fbu.getNodePath(node), isCopy);
            }
            for (String fid : fidList) {
                if (fid == null || fid.length() <= 0) {
                    return ERROR_PARAMETER;
                }
                Folder folder = this.flm.queryById(fid);
                if (folder == null) {
                    return ERROR_PARAMETER;
                }
                if (folder.getFolderParent().equals(locationpath) && !isCopy) continue;
                if (!ConfigureReader.instance().accessFolder(folder, account)) {
                    return NO_AUTHORIZED;
                }
                if (!ConfigureReader.instance().authorized(account, AccountAuth.MOVE_FILES, this.fu.getAllFoldersId(folder.getFolderParent()))) {
                    return NO_AUTHORIZED;
                }
                if (!isCopy && !ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(folder.getFolderParent()))) {
                    return NO_AUTHORIZED;
                }
                if (!isCopy && (fid.equals(locationpath) || this.fu.getParentList(locationpath).parallelStream().anyMatch(e -> e.getFolderId().equals(folder.getFolderId())))) {
                    return ERROR_PARAMETER;
                }
                originPath = this.fu.getFolderPath(folder);
                ip = this.idg.getIpAddr(request);
                if (this.flm.queryByParentId(locationpath).parallelStream().anyMatch(e -> e.getFolderName().equals(folder.getFolderName()))) {
                    if (optMap.get(fid) == null) {
                        return ERROR_PARAMETER;
                    }
                    switch ((String)optMap.get(fid)) {
                        case "cover": {
                            if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(locationpath))) {
                                return NO_AUTHORIZED;
                            }
                            Folder f = this.flm.queryByParentId(locationpath).parallelStream().filter(e -> e.getFolderName().equals(folder.getFolderName())).findFirst().get();
                            if (this.flm.deleteById(f.getFolderId()) > 0) {
                                if (isCopy) {
                                    Folder newFolder = this.fu.copyFolderByNewNameToPath(folder, account, targetFolder, null);
                                    this.fu.deleteAllChildFolder(f.getFolderId());
                                    if (newFolder != null) {
                                        this.lu.writeMoveFolderEvent(account, ip, originPath, this.fu.getFolderPath(newFolder), isCopy);
                                        break;
                                    }
                                } else {
                                    this.fu.deleteAllChildFolder(f.getFolderId());
                                    folder.setFolderParent(locationpath);
                                    boolean needChangeChildsConstranint = false;
                                    if (folder.getFolderConstraint() < targetFolder.getFolderConstraint()) {
                                        folder.setFolderConstraint(targetFolder.getFolderConstraint());
                                        needChangeChildsConstranint = true;
                                    }
                                    if (this.flm.update(folder) > 0) {
                                        if (needChangeChildsConstranint) {
                                            this.fu.changeChildFolderConstraint(folder.getFolderId(), targetFolder.getFolderConstraint());
                                        }
                                        this.lu.writeMoveFolderEvent(account, ip, originPath, this.fu.getFolderPath(folder), isCopy);
                                        break;
                                    }
                                }
                            }
                            return "cannotMoveFiles";
                        }
                        case "both": {
                            if (this.flm.countByParentId(locationpath) >= Integer.MAX_VALUE) {
                                return FOLDERS_TOTAL_OUT_OF_LIMIT;
                            }
                            if (isCopy) {
                                Folder newFolder = this.fu.copyFolderByNewNameToPath(folder, account, targetFolder, FileNodeUtil.getNewFolderName(folder.getFolderName(), this.flm.queryByParentId(locationpath)));
                                if (newFolder == null) {
                                    return "cannotMoveFiles";
                                }
                                this.lu.writeMoveFolderEvent(account, ip, originPath, this.fu.getFolderPath(newFolder), isCopy);
                                break;
                            }
                            folder.setFolderParent(locationpath);
                            folder.setFolderName(FileNodeUtil.getNewFolderName(folder.getFolderName(), this.flm.queryByParentId(locationpath)));
                            boolean needChangeChildsConstranint = false;
                            if (folder.getFolderConstraint() < targetFolder.getFolderConstraint()) {
                                folder.setFolderConstraint(targetFolder.getFolderConstraint());
                                needChangeChildsConstranint = true;
                            }
                            if (this.flm.update(folder) <= 0) {
                                return "cannotMoveFiles";
                            }
                            if (needChangeChildsConstranint) {
                                this.fu.changeChildFolderConstraint(folder.getFolderId(), targetFolder.getFolderConstraint());
                            }
                            this.lu.writeMoveFolderEvent(account, ip, originPath, this.fu.getFolderPath(folder), isCopy);
                            break;
                        }
                        case "skip": {
                            break;
                        }
                        default: {
                            return ERROR_PARAMETER;
                        }
                    }
                    continue;
                }
                if (this.flm.countByParentId(locationpath) >= Integer.MAX_VALUE) {
                    return FOLDERS_TOTAL_OUT_OF_LIMIT;
                }
                if (isCopy) {
                    Folder newFolder = this.fu.copyFolderByNewNameToPath(folder, account, targetFolder, null);
                    if (newFolder == null) {
                        return "cannotMoveFiles";
                    }
                    this.lu.writeMoveFolderEvent(account, ip, originPath, this.fu.getFolderPath(newFolder), isCopy);
                    continue;
                }
                folder.setFolderParent(locationpath);
                boolean needChangeChildsConstranint = false;
                if (folder.getFolderConstraint() < targetFolder.getFolderConstraint()) {
                    folder.setFolderConstraint(targetFolder.getFolderConstraint());
                    needChangeChildsConstranint = true;
                }
                if (this.flm.update(folder) <= 0) {
                    return "cannotMoveFiles";
                }
                if (needChangeChildsConstranint) {
                    this.fu.changeChildFolderConstraint(folder.getFolderId(), targetFolder.getFolderConstraint());
                }
                this.lu.writeMoveFolderEvent(account, ip, originPath, this.fu.getFolderPath(folder), isCopy);
            }
            if (fidList.size() > 0) {
                ServerInitListener.needCheck = true;
            }
            return "moveFilesSuccess";
        }
        catch (Exception e2) {
            return ERROR_PARAMETER;
        }
    }

    @Override
    public String confirmMoveFiles(HttpServletRequest request) {
        String strIdList = request.getParameter("strIdList");
        String strFidList = request.getParameter("strFidList");
        String locationpath = request.getParameter("locationpath");
        String method = request.getParameter("method");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        boolean isCopy = "COPY".equals(method);
        Folder targetFolder = this.flm.queryById(locationpath);
        int needMovefilesCount = 0;
        int needMoveFoldersCount = 0;
        if (ConfigureReader.instance().accessFolder(targetFolder, account) && ConfigureReader.instance().authorized(account, AccountAuth.MOVE_FILES, this.fu.getAllFoldersId(locationpath))) {
            try {
                List idList = (List)this.gson.fromJson(strIdList, new TypeToken<List<String>>(){}.getType());
                List fidList = (List)this.gson.fromJson(strFidList, new TypeToken<List<String>>(){}.getType());
                if (fidList.size() > 0 && !ConfigureReader.instance().authorized(account, AccountAuth.CREATE_NEW_FOLDER, this.fu.getAllFoldersId(locationpath))) {
                    return NO_AUTHORIZED;
                }
                ArrayList<Node> repeNodes = new ArrayList<Node>();
                ArrayList<Folder> repeFolders = new ArrayList<Folder>();
                for (String fileId : idList) {
                    if (fileId == null || fileId.length() <= 0) {
                        return ERROR_PARAMETER;
                    }
                    Node node = this.fm.queryById(fileId);
                    if (node == null) {
                        return ERROR_PARAMETER;
                    }
                    if (node.getFileParentFolder().equals(locationpath) && !isCopy) continue;
                    if (!ConfigureReader.instance().accessFolder(this.flm.queryById(node.getFileParentFolder()), account)) {
                        return NO_AUTHORIZED;
                    }
                    if (!ConfigureReader.instance().authorized(account, AccountAuth.MOVE_FILES, this.fu.getAllFoldersId(node.getFileParentFolder()))) {
                        return NO_AUTHORIZED;
                    }
                    if (!isCopy && !ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(node.getFileParentFolder()))) {
                        return NO_AUTHORIZED;
                    }
                    if (this.fm.queryByParentFolderId(locationpath).parallelStream().anyMatch(e -> e.getFileName().equals(node.getFileName()))) {
                        repeNodes.add(node);
                        continue;
                    }
                    ++needMovefilesCount;
                }
                for (String folderId : fidList) {
                    if (folderId == null || folderId.length() <= 0) {
                        return ERROR_PARAMETER;
                    }
                    Folder folder = this.flm.queryById(folderId);
                    if (folder == null) {
                        return ERROR_PARAMETER;
                    }
                    if (folder.getFolderParent().equals(locationpath) && !isCopy) continue;
                    if (!ConfigureReader.instance().accessFolder(folder, account)) {
                        return NO_AUTHORIZED;
                    }
                    if (!ConfigureReader.instance().authorized(account, AccountAuth.MOVE_FILES, this.fu.getAllFoldersId(folder.getFolderParent()))) {
                        return NO_AUTHORIZED;
                    }
                    if (!isCopy && !ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(folder.getFolderParent()))) {
                        return NO_AUTHORIZED;
                    }
                    if (!isCopy && (folderId.equals(locationpath) || this.fu.getParentList(locationpath).parallelStream().anyMatch(e -> e.getFolderId().equals(folder.getFolderId())))) {
                        return "CANT_MOVE_TO_INSIDE:" + folder.getFolderName();
                    }
                    if (this.flm.queryByParentId(locationpath).parallelStream().anyMatch(e -> e.getFolderName().equals(folder.getFolderName()))) {
                        repeFolders.add(folder);
                        continue;
                    }
                    ++needMoveFoldersCount;
                }
                long estimateFilesTotal = this.fm.countByParentFolderId(locationpath) + (long)needMovefilesCount;
                if (estimateFilesTotal > Integer.MAX_VALUE || estimateFilesTotal < 0L) {
                    return FILES_TOTAL_OUT_OF_LIMIT;
                }
                long estimateFoldersTotal = this.flm.countByParentId(locationpath) + (long)needMoveFoldersCount;
                if (estimateFoldersTotal > Integer.MAX_VALUE || estimateFoldersTotal < 0L) {
                    return FOLDERS_TOTAL_OUT_OF_LIMIT;
                }
                if (repeNodes.size() > 0 || repeFolders.size() > 0) {
                    HashMap<String, ArrayList<Object>> repeMap = new HashMap<String, ArrayList<Object>>();
                    repeMap.put("repeFolders", repeFolders);
                    repeMap.put("repeNodes", repeNodes);
                    return "duplicationFileName:" + this.gson.toJson(repeMap);
                }
                return "confirmMoveFiles";
            }
            catch (Exception e2) {
                return ERROR_PARAMETER;
            }
        }
        return NO_AUTHORIZED;
    }

    @Override
    public String checkImportFolder(HttpServletRequest request) {
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        String folderId = request.getParameter("folderId");
        String folderName = request.getParameter("folderName");
        String maxUploadFileSize = request.getParameter("maxSize");
        CheckImportFolderRespons cifr = new CheckImportFolderRespons();
        if (folderName == null || folderName.length() == 0) {
            cifr.setResult(ERROR_PARAMETER);
            return this.gson.toJson((Object)cifr);
        }
        if (folderId == null || folderId.length() == 0) {
            cifr.setResult(ERROR_PARAMETER);
            return this.gson.toJson((Object)cifr);
        }
        Folder folder = this.flm.queryById(folderId);
        if (folder == null) {
            cifr.setResult(ERROR_PARAMETER);
            return this.gson.toJson((Object)cifr);
        }
        if (!(ConfigureReader.instance().authorized(account, AccountAuth.UPLOAD_FILES, this.fu.getAllFoldersId(folderId)) && ConfigureReader.instance().authorized(account, AccountAuth.CREATE_NEW_FOLDER, this.fu.getAllFoldersId(folderId)) && ConfigureReader.instance().accessFolder(folder, account))) {
            cifr.setResult(NO_AUTHORIZED);
            return this.gson.toJson((Object)cifr);
        }
        try {
            long mufs = Long.parseLong(maxUploadFileSize);
            long pMaxUploadSize = ConfigureReader.instance().getUploadFileSize(account);
            if (pMaxUploadSize >= 0L && mufs > pMaxUploadSize) {
                cifr.setResult("fileOverSize");
                cifr.setMaxSize(this.formatMaxUploadFileSize(ConfigureReader.instance().getUploadFileSize(account)));
                return this.gson.toJson((Object)cifr);
            }
        }
        catch (Exception e) {
            cifr.setResult(ERROR_PARAMETER);
            return this.gson.toJson((Object)cifr);
        }
        List<Folder> folders = this.flm.queryByParentId(folderId);
        try {
            Folder testFolder = ((Stream)folders.stream().parallel()).filter(n -> n.getFolderName().equals(folderName)).findAny().get();
            if (ConfigureReader.instance().accessFolder(testFolder, account) && ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER, this.fu.getAllFoldersId(folderId))) {
                cifr.setResult("repeatFolder_coverOrBoth");
            } else {
                cifr.setResult("repeatFolder_Both");
            }
            return this.gson.toJson((Object)cifr);
        }
        catch (NoSuchElementException e) {
            if (this.flm.countByParentId(folderId) >= Integer.MAX_VALUE) {
                cifr.setResult(FOLDERS_TOTAL_OUT_OF_LIMIT);
            } else {
                cifr.setResult("permitUpload");
            }
            return this.gson.toJson((Object)cifr);
        }
    }

    @Override
    public String doImportFolder(HttpServletRequest request, MultipartFile file) {
        String newFolderName;
        String folderConstraint;
        String originalFileName;
        String folderId;
        String account;
        block21: {
            account = (String)request.getSession().getAttribute("ACCOUNT");
            folderId = request.getParameter("folderId");
            originalFileName = request.getParameter("originalFileName");
            folderConstraint = request.getParameter("folderConstraint");
            newFolderName = request.getParameter("newFolderName");
            if (folderId == null || folderId.length() <= 0 || originalFileName == null || originalFileName.length() <= 0) {
                return UPLOADERROR;
            }
            Folder folder = this.flm.queryById(folderId);
            if (folder == null) {
                return UPLOADERROR;
            }
            if (!(ConfigureReader.instance().authorized(account, AccountAuth.UPLOAD_FILES, this.fu.getAllFoldersId(folderId)) && ConfigureReader.instance().authorized(account, AccountAuth.CREATE_NEW_FOLDER, this.fu.getAllFoldersId(folderId)) && ConfigureReader.instance().accessFolder(folder, account))) {
                return UPLOADERROR;
            }
            long mufs = ConfigureReader.instance().getUploadFileSize(account);
            if (mufs >= 0L && file.getSize() > mufs) {
                return UPLOADERROR;
            }
            int pc = folder.getFolderConstraint();
            if (folderConstraint != null) {
                try {
                    int ifc = Integer.parseInt(folderConstraint);
                    if (ifc != 0 && account == null) {
                        return UPLOADERROR;
                    }
                    if (ifc < pc) {
                        return UPLOADERROR;
                    }
                    break block21;
                }
                catch (Exception e2) {
                    return UPLOADERROR;
                }
            }
            return UPLOADERROR;
        }
        String[] paths = this.getParentPath(originalFileName);
        if (paths.length == 0) {
            return UPLOADERROR;
        }
        if (newFolderName != null && newFolderName.length() > 0) {
            paths[0] = newFolderName;
        }
        for (String pName : paths) {
            Folder newFolder;
            try {
                newFolder = this.fu.createNewFolder(folderId, account, pName, folderConstraint);
            }
            catch (FoldersTotalOutOfLimitException e1) {
                return FOLDERS_TOTAL_OUT_OF_LIMIT;
            }
            if (newFolder == null) {
                HashMap<String, String> key = new HashMap<String, String>();
                key.put("parentId", folderId);
                key.put("folderName", pName);
                Folder target = this.flm.queryByParentIdAndFolderName(key);
                if (target != null) {
                    folderId = target.getFolderId();
                    continue;
                }
                return UPLOADERROR;
            }
            if (!this.fu.isValidFolder(newFolder)) {
                return UPLOADERROR;
            }
            folderId = newFolder.getFolderId();
        }
        String fileName = this.getFileNameFormPath(originalFileName);
        List<Node> files = this.fm.queryByParentFolderId(folderId);
        if (files.parallelStream().anyMatch(e -> e.getFileName().equals(fileName))) {
            return UPLOADERROR;
        }
        if (this.fm.countByParentFolderId(folderId) >= Integer.MAX_VALUE) {
            return FILES_TOTAL_OUT_OF_LIMIT;
        }
        File block = this.fbu.saveToFileBlocks(file);
        if (block == null) {
            return UPLOADERROR;
        }
        String fsize = this.fbu.getFileSize(file.getSize());
        Node newNode = this.fbu.insertNewNode(fileName, account, block.getName(), fsize, folderId);
        if (newNode != null) {
            this.lu.writeUploadFileEvent(request, newNode, account);
            return UPLOADSUCCESS;
        }
        block.delete();
        return UPLOADERROR;
    }

    private String[] getParentPath(String path) {
        if (path != null) {
            String[] paths = path.split("/");
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < paths.length - 1; ++i) {
                if (paths[i].length() <= 0) continue;
                result.add(paths[i]);
            }
            return result.toArray(new String[0]);
        }
        return new String[0];
    }

    private String getFileNameFormPath(String path) {
        String[] paths;
        if (path != null && (paths = path.split("/")).length > 0) {
            return paths[paths.length - 1];
        }
        return null;
    }
}

