/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import java.io.File;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.mapper.PropertiesMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.model.Propertie;
import kohgylw.kiftd.server.service.FileChainService;
import kohgylw.kiftd.server.util.AESCipher;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.ContentTypeMap;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.RangeFileStreamWriter;
import org.springframework.stereotype.Service;

@Service
public class FileChainServiceImpl
extends RangeFileStreamWriter
implements FileChainService {
    @Resource
    private NodeMapper nm;
    @Resource
    private FolderMapper flm;
    @Resource
    private FileBlockUtil fbu;
    @Resource
    private ContentTypeMap ctm;
    @Resource
    private LogUtil lu;
    @Resource
    private AESCipher cipher;
    @Resource
    private PropertiesMapper pm;
    @Resource
    private FolderUtil fu;

    @Override
    public void getResourceByChainKey(HttpServletRequest request, HttpServletResponse response) {
        String ckey;
        int statusCode = 403;
        if (ConfigureReader.instance().isOpenFileChain() && (ckey = request.getParameter("ckey")) != null) {
            Propertie keyProp = this.pm.selectByKey("chain_aes_key");
            if (keyProp != null) {
                try {
                    File target;
                    String fid = this.cipher.decrypt(keyProp.getPropertieValue(), ckey);
                    Node f = this.nm.queryById(fid);
                    if (f != null && (target = this.fbu.getFileFromBlocks(f)) != null && target.isFile()) {
                        String fileName = f.getFileName();
                        String suffix = "";
                        if (fileName.indexOf(".") >= 0) {
                            suffix = fileName.substring(fileName.lastIndexOf(".")).trim().toLowerCase();
                        }
                        String range = request.getHeader("Range");
                        int status = FileChainServiceImpl.writeRangeFileStream(request, response, target, f.getFileName(), this.ctm.getContentType(suffix), ConfigureReader.instance().getDownloadMaxRate(null), this.fbu.getETag(target), false);
                        if (status == 200 || range != null && range.startsWith("bytes=0-")) {
                            this.lu.writeChainEvent(request, f);
                        }
                        return;
                    }
                    statusCode = 404;
                }
                catch (Exception e) {
                    this.lu.writeException(e);
                    statusCode = 500;
                }
            } else {
                statusCode = 404;
            }
        }
        try {
            response.sendError(statusCode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getChainKeyByFid(HttpServletRequest request) {
        block7: {
            if (ConfigureReader.instance().isOpenFileChain()) {
                Node f;
                String fid = request.getParameter("fid");
                String account = (String)request.getSession().getAttribute("ACCOUNT");
                if (fid != null && (f = this.nm.queryById(fid)) != null && ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(f.getFileParentFolder()))) {
                    Folder folder = this.flm.queryById(f.getFileParentFolder());
                    if (ConfigureReader.instance().accessFolder(folder, account)) {
                        try {
                            Propertie keyProp = this.pm.selectByKey("chain_aes_key");
                            if (keyProp == null) {
                                String aesKey = this.cipher.generateRandomKey();
                                Propertie chainAESKey = new Propertie();
                                chainAESKey.setPropertieKey("chain_aes_key");
                                chainAESKey.setPropertieValue(aesKey);
                                if (this.pm.insert(chainAESKey) > 0) {
                                    return this.cipher.encrypt(aesKey, fid);
                                }
                                break block7;
                            }
                            return this.cipher.encrypt(keyProp.getPropertieValue(), fid);
                        }
                        catch (Exception e) {
                            this.lu.writeException(e);
                        }
                    }
                }
            }
        }
        return "ERROR";
    }
}

