/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.service.ExternalDownloadService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.RangeFileStreamWriter;
import org.springframework.stereotype.Service;

@Service
public class ExternalDownloadServiceImpl
extends RangeFileStreamWriter
implements ExternalDownloadService {
    private static Map<String, String> downloadKeyMap = new HashMap<String, String>();
    private static final String CONTENT_TYPE = "application/octet-stream";
    @Resource
    private NodeMapper nm;
    @Resource
    private LogUtil lu;
    @Resource
    private FileBlockUtil fbu;
    @Resource
    private FolderUtil fu;
    @Resource
    private FolderMapper fm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDownloadKey(HttpServletRequest request) {
        Node f;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        String fileId = request.getParameter("fId");
        if (fileId != null && (f = this.nm.queryById(fileId)) != null && ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES, this.fu.getAllFoldersId(f.getFileParentFolder())) && ConfigureReader.instance().accessFolder(this.fm.queryById(f.getFileParentFolder()), account)) {
            Map<String, String> map = downloadKeyMap;
            synchronized (map) {
                this.lu.writeShareFileURLEvent(request, f);
                if (downloadKeyMap.containsValue(f.getFileId())) {
                    Map.Entry k = downloadKeyMap.entrySet().parallelStream().filter(e -> ((String)e.getValue()).equals(f.getFileId())).findFirst().get();
                    return (String)k.getKey();
                }
                String dKey = UUID.randomUUID().toString();
                downloadKeyMap.put(dKey, f.getFileId());
                return dKey;
            }
        }
        return "ERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFileByKey(HttpServletRequest request, HttpServletResponse response) {
        String dkey = request.getParameter("dkey");
        if (dkey != null) {
            File target;
            Node f;
            String fId = null;
            Map<String, String> map = downloadKeyMap;
            synchronized (map) {
                fId = downloadKeyMap.get(dkey);
            }
            if (fId != null && (f = this.nm.queryById(fId)) != null && (target = this.fbu.getFileFromBlocks(f)) != null && target.isFile()) {
                String range = request.getHeader("Range");
                int status = ExternalDownloadServiceImpl.writeRangeFileStream(request, response, target, f.getFileName(), CONTENT_TYPE, ConfigureReader.instance().getDownloadMaxRate(null), this.fbu.getETag(target), true);
                if (status == 200 || range != null && range.startsWith("bytes=0-")) {
                    this.lu.writeDownloadFileByKeyEvent(request, f);
                }
                return;
            }
        }
        try {
            response.sendError(404);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

