/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import kohgylw.kiftd.server.enumeration.VCLevel;
import kohgylw.kiftd.server.pojo.ChangePasswordInfoPojo;
import kohgylw.kiftd.server.pojo.LoginInfoPojo;
import kohgylw.kiftd.server.pojo.PublicKeyInfo;
import kohgylw.kiftd.server.pojo.SignUpInfoPojo;
import kohgylw.kiftd.server.service.AccountService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.RSADecryptUtil;
import kohgylw.kiftd.server.util.RSAKeyUtil;
import kohgylw.kiftd.server.util.VerificationCode;
import kohgylw.kiftd.server.util.VerificationCodeFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountServiceImpl
implements AccountService {
    @Resource
    private RSAKeyUtil ku;
    @Resource
    private LogUtil lu;
    private static final long TIME_OUT = 30000L;
    @Resource
    private Gson gson;
    private VerificationCodeFactory vcf;
    private CharsetEncoder ios8859_1Encoder = Charset.forName("ISO-8859-1").newEncoder();
    private static final Set<String> focusAccount = new HashSet<String>();

    public AccountServiceImpl() {
        if (!ConfigureReader.instance().getVCLevel().equals((Object)VCLevel.Close)) {
            int line = 0;
            int oval = 0;
            switch (ConfigureReader.instance().getVCLevel()) {
                case Standard: {
                    line = 6;
                    oval = 2;
                    break;
                }
                case Simplified: {
                    line = 1;
                    oval = 0;
                    break;
                }
            }
            this.vcf = new VerificationCodeFactory(45, line, oval, 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'w', 'x', 'y', 'z', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'W', 'X', 'Y', 'Z');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String checkLoginRequest(HttpServletRequest request, HttpSession session) {
        String encrypted = request.getParameter("encrypted");
        try {
            Set<String> set;
            String loginInfoStr = RSADecryptUtil.dncryption(encrypted, this.ku.getPrivateKey());
            LoginInfoPojo info = (LoginInfoPojo)this.gson.fromJson(loginInfoStr.replaceAll("\\\\", "\\\\\\\\"), LoginInfoPojo.class);
            if (System.currentTimeMillis() - Long.parseLong(info.getTime()) > 30000L) {
                return "error";
            }
            String accountId = info.getAccountId();
            if (!ConfigureReader.instance().foundAccount(accountId)) {
                return "accountnotfound";
            }
            if (!ConfigureReader.instance().getVCLevel().equals((Object)VCLevel.Close)) {
                set = focusAccount;
                synchronized (set) {
                    if (focusAccount.contains(accountId)) {
                        String reqVerCode = request.getParameter("vercode");
                        String trueVerCode = (String)session.getAttribute("VERCODE");
                        session.removeAttribute("VERCODE");
                        if (reqVerCode == null || trueVerCode == null || !trueVerCode.equals(reqVerCode.toLowerCase())) {
                            return "needsubmitvercode";
                        }
                    }
                }
            }
            if (ConfigureReader.instance().checkAccountPwd(accountId, info.getAccountPwd())) {
                session.setAttribute("ACCOUNT", (Object)accountId);
                if (!ConfigureReader.instance().getVCLevel().equals((Object)VCLevel.Close)) {
                    set = focusAccount;
                    synchronized (set) {
                        focusAccount.remove(accountId);
                    }
                }
                return "permitlogin";
            }
            set = focusAccount;
            synchronized (set) {
                if (!ConfigureReader.instance().getVCLevel().equals((Object)VCLevel.Close)) {
                    focusAccount.add(accountId);
                }
            }
            return "accountpwderror";
        }
        catch (Exception e) {
            return "error";
        }
    }

    @Override
    public void logout(HttpSession session) {
        session.invalidate();
    }

    @Override
    public String getPublicKey() {
        PublicKeyInfo pki = new PublicKeyInfo();
        pki.setPublicKey(this.ku.getPublicKey());
        pki.setTime(System.currentTimeMillis());
        return this.gson.toJson((Object)pki);
    }

    @Override
    public void getNewLoginVerCode(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        try {
            if (ConfigureReader.instance().getVCLevel().equals((Object)VCLevel.Close)) {
                response.sendError(404);
            } else {
                VerificationCode vc = this.vcf.next(4);
                session.setAttribute("VERCODE", (Object)vc.getCode());
                response.setContentType("image/png");
                ServletOutputStream out = response.getOutputStream();
                vc.saveTo((OutputStream)out);
                out.flush();
                out.close();
            }
        }
        catch (IOException e) {
            try {
                response.sendError(500);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String doPong(HttpServletRequest request) {
        if (request.getSession().getAttribute("ACCOUNT") != null) {
            return "pong";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String changePassword(HttpServletRequest request) {
        if (!ConfigureReader.instance().isAllowChangePassword()) {
            return "illegal";
        }
        HttpSession session = request.getSession();
        String account = (String)session.getAttribute("ACCOUNT");
        if (account == null) {
            return "mustlogin";
        }
        String encrypted = request.getParameter("encrypted");
        try {
            Set<String> set;
            String changePasswordInfoStr = RSADecryptUtil.dncryption(encrypted, this.ku.getPrivateKey());
            ChangePasswordInfoPojo info = (ChangePasswordInfoPojo)this.gson.fromJson(changePasswordInfoStr.replaceAll("\\\\", "\\\\\\\\"), ChangePasswordInfoPojo.class);
            if (System.currentTimeMillis() - Long.parseLong(info.getTime()) > 30000L) {
                return "error";
            }
            if (!ConfigureReader.instance().getVCLevel().equals((Object)VCLevel.Close)) {
                set = focusAccount;
                synchronized (set) {
                    if (focusAccount.contains(account)) {
                        String reqVerCode = request.getParameter("vercode");
                        String trueVerCode = (String)session.getAttribute("VERCODE");
                        session.removeAttribute("VERCODE");
                        if (reqVerCode == null || trueVerCode == null || !trueVerCode.equals(reqVerCode.toLowerCase())) {
                            return "needsubmitvercode";
                        }
                    }
                }
            }
            if (ConfigureReader.instance().checkAccountPwd(account, info.getOldPwd())) {
                String newPassword;
                if (!ConfigureReader.instance().getVCLevel().equals((Object)VCLevel.Close)) {
                    set = focusAccount;
                    synchronized (set) {
                        focusAccount.remove(account);
                    }
                }
                if ((newPassword = info.getNewPwd()) != null && newPassword.length() >= 3 && newPassword.length() <= 32 && this.ios8859_1Encoder.canEncode(newPassword) && ConfigureReader.instance().changePassword(account, newPassword)) {
                    this.lu.writeChangePasswordEvent(request, account, newPassword);
                    return "success";
                }
                return "invalidnewpwd";
            }
            set = focusAccount;
            synchronized (set) {
                if (!ConfigureReader.instance().getVCLevel().equals((Object)VCLevel.Close)) {
                    focusAccount.add(account);
                }
            }
            return "oldpwderror";
        }
        catch (Exception e) {
            this.lu.writeException(e);
            return "cannotchangepwd";
        }
    }

    @Override
    public String isAllowSignUp() {
        return ConfigureReader.instance().isAllowSignUp() ? "true" : "false";
    }

    @Override
    public String doSignUp(HttpServletRequest request) {
        if (!ConfigureReader.instance().isAllowSignUp()) {
            return "illegal";
        }
        HttpSession session = request.getSession();
        if (session.getAttribute("ACCOUNT") != null) {
            return "mustlogout";
        }
        String reqVerCode = request.getParameter("vercode");
        if (!ConfigureReader.instance().getVCLevel().equals((Object)VCLevel.Close)) {
            String trueVerCode = (String)session.getAttribute("VERCODE");
            session.removeAttribute("VERCODE");
            if (reqVerCode == null || trueVerCode == null || !trueVerCode.equals(reqVerCode.toLowerCase())) {
                return "needvercode";
            }
        }
        String encrypted = request.getParameter("encrypted");
        try {
            String signUpInfoStr = RSADecryptUtil.dncryption(encrypted, this.ku.getPrivateKey());
            SignUpInfoPojo info = (SignUpInfoPojo)this.gson.fromJson(signUpInfoStr.replaceAll("\\\\", "\\\\\\\\"), SignUpInfoPojo.class);
            if (System.currentTimeMillis() - Long.parseLong(info.getTime()) > 30000L) {
                return "error";
            }
            if (ConfigureReader.instance().foundAccount(info.getAccount())) {
                return "accountexists";
            }
            String account = info.getAccount();
            String password = info.getPwd();
            if (account != null && account.length() >= 3 && account.length() <= 32 && this.ios8859_1Encoder.canEncode(account)) {
                if (account.indexOf("=") < 0 && account.indexOf(":") < 0 && account.indexOf("#") != 0) {
                    if (password != null && password.length() >= 3 && password.length() <= 32 && this.ios8859_1Encoder.canEncode(password)) {
                        if (ConfigureReader.instance().createNewAccount(account, password)) {
                            this.lu.writeSignUpEvent(request, account, password);
                            session.setAttribute("ACCOUNT", (Object)account);
                            return "success";
                        }
                        return "cannotsignup";
                    }
                    return "invalidpwd";
                }
                return "illegalaccount";
            }
            return "invalidaccount";
        }
        catch (Exception e) {
            this.lu.writeException(e);
            return "cannotsignup";
        }
    }
}

