/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.pojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.UUID;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.util.ConfigureReader;
import org.apache.commons.codec.digest.DigestUtils;
import ws.schild.jave.Encoder;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.encode.EncodingAttributes;
import ws.schild.jave.info.MultimediaInfo;
import ws.schild.jave.process.ProcessLocator;
import ws.schild.jave.progress.EncoderProgressListener;

public class VideoTranscodeThread {
    private String md5;
    private String progress;
    private Encoder encoder;
    private String outputFileName;

    public VideoTranscodeThread(File f, EncodingAttributes ea, ProcessLocator fl) throws Exception {
        this.md5 = DigestUtils.md5Hex((InputStream)new FileInputStream(f));
        this.progress = "0.0";
        MultimediaObject mo = new MultimediaObject(f, fl);
        this.encoder = new Encoder(fl);
        Thread t = new Thread(() -> {
            try {
                this.outputFileName = "video_" + UUID.randomUUID().toString() + ".mp4";
                this.encoder.encode(mo, new File(ConfigureReader.instance().getTemporaryfilePath(), this.outputFileName), ea, new EncoderProgressListener(){

                    public void progress(int arg0) {
                        VideoTranscodeThread.this.progress = (double)arg0 / 10.0 + "";
                    }

                    public void message(String arg0) {
                    }

                    public void sourceInfo(MultimediaInfo info) {
                    }
                });
                this.progress = "FIN";
            }
            catch (Exception e) {
                Printer.instance.print("\u8b66\u544a\uff1a\u5728\u7ebf\u8f6c\u7801\u529f\u80fd\u51fa\u73b0\u610f\u5916\u9519\u8bef\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
            }
        });
        t.start();
    }

    public String getMd5() {
        return this.md5;
    }

    public String getProgress() {
        return this.progress;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void abort() {
        File f;
        if (this.encoder != null) {
            this.encoder.abortEncoding();
        }
        if ((f = new File(ConfigureReader.instance().getTemporaryfilePath(), this.outputFileName)).exists()) {
            f.delete();
        }
    }
}

