/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.listener;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.FileNodeUtil;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.NoticeUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@WebListener
public class ServerInitListener
implements ServletContextListener {
    private static final int CYVLE_TIME = 30000;
    private Thread pathWatchServiceThread;
    private Thread cleanInnvalidAddedAuthThread;
    private boolean run;
    public static boolean needCheck;
    private static boolean continueCheck;
    private FileBlockUtil fbu;
    private NoticeUtil nu;
    private FolderMapper nm;
    private LogUtil lu;

    public void contextInitialized(ServletContextEvent sce) {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext());
        FileNodeUtil.initNodeTableToDataBase();
        Printer.instance.print("\u6587\u4ef6\u7cfb\u7edf\u8282\u70b9\u4fe1\u606f\u6821\u5bf9...");
        String fsp = ConfigureReader.instance().getFileSystemPath();
        File fspf = new File(fsp);
        if (fspf.isDirectory() && fspf.canRead() && fspf.canWrite()) {
            this.fbu = (FileBlockUtil)context.getBean(FileBlockUtil.class);
            this.fbu.checkFileBlocks();
            this.fbu.initTempDir();
            Printer.instance.print("\u6821\u5bf9\u5b8c\u6210\u3002");
        } else {
            Printer.instance.print("\u9519\u8bef\uff1a\u6587\u4ef6\u7cfb\u7edf\u8282\u70b9\u4fe1\u606f\u6821\u5bf9\u5931\u8d25\uff0c\u5b58\u50a8\u4f4d\u7f6e\u65e0\u6cd5\u8bfb\u5199\u6216\u4e0d\u5b58\u5728\u3002");
        }
        this.nu = (NoticeUtil)context.getBean(NoticeUtil.class);
        this.nu.loadNotice();
        this.doWatch();
        this.nm = (FolderMapper)context.getBean(FolderMapper.class);
        this.lu = (LogUtil)context.getBean(LogUtil.class);
        this.cleanInvalidAddedAuth();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.run = false;
        Printer.instance.print("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6...");
        this.fbu.initTempDir();
    }

    private void doWatch() {
        this.run = true;
        if (this.pathWatchServiceThread == null) {
            Path confPath = Paths.get(ConfigureReader.instance().getPath(), new String[0]);
            this.pathWatchServiceThread = new Thread(() -> {
                try {
                    while (this.run) {
                        WatchService ws = confPath.getFileSystem().newWatchService();
                        confPath.register(ws, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE);
                        WatchKey wk = ws.take();
                        List<WatchEvent<?>> es = wk.pollEvents();
                        for (WatchEvent<?> we : es) {
                            switch (we.context().toString()) {
                                case "notice.md": {
                                    this.nu.loadNotice();
                                    break;
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u670d\u52a1\u5668\u6587\u4ef6\u81ea\u52a8\u66f4\u65b0\u5931\u8d25\uff0c\u8be5\u529f\u80fd\u5df2\u5931\u6548\u3002\u67d0\u4e9b\u6587\u4ef6\u5c06\u65e0\u6cd5\u81ea\u52a8\u8f7d\u5165\u6700\u65b0\u5185\u5bb9\uff08\u8bf7\u5c1d\u8bd5\u91cd\u542f\u7a0b\u5e8f\u4ee5\u6062\u590d\u8be5\u529f\u80fd\uff09\u3002");
                }
            });
            this.pathWatchServiceThread.start();
        }
    }

    private void cleanInvalidAddedAuth() {
        needCheck = true;
        continueCheck = true;
        if (this.cleanInnvalidAddedAuthThread == null) {
            this.cleanInnvalidAddedAuthThread = new Thread(() -> {
                while (continueCheck) {
                    if (needCheck) {
                        ArrayList<String> invalidIdList = new ArrayList<String>();
                        List<String> idList = ConfigureReader.instance().getAllAddedAuthFoldersId();
                        for (String id : idList) {
                            if (this.nm.queryById(id) != null) continue;
                            invalidIdList.add(id);
                            Printer.instance.print("\u6587\u4ef6\u5939ID\uff1a" + id + "\u5bf9\u5e94\u7684\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u76f8\u5173\u7684\u989d\u5916\u6743\u9650\u8bbe\u7f6e\u5c06\u88ab\u6e05\u7406\u3002");
                        }
                        if (ConfigureReader.instance().removeAddedAuthByFolderId(invalidIdList)) {
                            Printer.instance.print("\u5931\u6548\u7684\u989d\u5916\u6743\u9650\u8bbe\u7f6e\u5df2\u7ecf\u6e05\u7406\u5b8c\u6210\u3002");
                        }
                        needCheck = false;
                    }
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        continueCheck = false;
                        this.lu.writeException(e);
                    }
                }
            });
            this.cleanInnvalidAddedAuthThread.start();
        }
    }
}

