/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.IpAddrGetter;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@WebFilter
@Order(value=1)
public class IPFilter
implements Filter {
    private IpAddrGetter idg;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.idg = (IpAddrGetter)context.getBean(IpAddrGetter.class);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (ConfigureReader.instance().enableIPRule()) {
            HttpServletRequest hsr = (HttpServletRequest)request;
            if (ConfigureReader.instance().filterAccessIP(this.idg.getIpAddr(hsr))) {
                chain.doFilter(request, response);
            } else {
                ((HttpServletResponse)response).sendError(403);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

