/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.ctl;

import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.configation.MVC;
import kohgylw.kiftd.server.util.ConfigureReader;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.springframework.boot.Banner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;

@SpringBootApplication
@Import(value={MVC.class})
public class KiftdCtl {
    private static ApplicationContext context;
    private static boolean run;

    public boolean start() {
        Printer.instance.print("\u6b63\u5728\u521d\u59cb\u5316\u670d\u52a1\u5668\u8bbe\u7f6e...");
        String[] args = new String[]{};
        if (!run) {
            ConfigureReader.instance().reTestServerPropertiesAndEffect();
            if (ConfigureReader.instance().getPropertiesStatus() == 0) {
                try {
                    Printer.instance.print("\u6b63\u5728\u5f00\u542f\u670d\u52a1\u5668\u5f15\u64ce...");
                    SpringApplication springApplication = new SpringApplication(new Class[]{KiftdCtl.class});
                    springApplication.setBannerMode(Banner.Mode.OFF);
                    context = springApplication.run(args);
                    run = context != null;
                    Printer.instance.print("\u670d\u52a1\u5668\u5f15\u64ce\u5df2\u542f\u52a8\u3002");
                    return run;
                }
                catch (Exception e) {
                    Printer.instance.print(e.toString());
                    Printer.instance.print("\u51fa\u73b0\u9519\u8bef\uff0c\u670d\u52a1\u5668\u5f15\u64ce\u542f\u52a8\u5931\u8d25\u3002");
                    return false;
                }
            }
            Printer.instance.print("\u670d\u52a1\u5668\u8bbe\u7f6e\u68c0\u67e5\u5931\u8d25\uff0c\u65e0\u6cd5\u5f00\u542f\u670d\u52a1\u5668\u3002");
            return false;
        }
        Printer.instance.print("\u670d\u52a1\u5668\u6b63\u5728\u8fd0\u884c\u4e2d\u3002");
        return true;
    }

    public boolean stop() {
        Printer.instance.print("\u6b63\u5728\u5173\u95ed\u670d\u52a1\u5668...");
        if (context != null) {
            Printer.instance.print("\u6b63\u5728\u7ec8\u6b62\u670d\u52a1\u5668\u5f15\u64ce...");
            try {
                run = SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[0]) != 0;
                Printer.instance.print("\u670d\u52a1\u5668\u5f15\u64ce\u5df2\u7ec8\u6b62\u3002");
                return !run;
            }
            catch (Exception e) {
                return false;
            }
        }
        Printer.instance.print("\u670d\u52a1\u5668\u672a\u542f\u52a8\u3002");
        return true;
    }

    public boolean started() {
        return run;
    }

    @Bean
    public ServletWebServerFactory servletContainer() {
        TomcatServletWebServerFactory tomcat = null;
        if (ConfigureReader.instance().openHttps()) {
            tomcat = new TomcatServletWebServerFactory(){

                protected void customizeConnector(Connector connector) {
                    connector.setScheme("http");
                    connector.setPort(ConfigureReader.instance().getPort());
                    connector.setSecure(false);
                    connector.setRedirectPort(ConfigureReader.instance().getHttpsPort());
                }

                protected void postProcessContext(Context context) {
                    SecurityConstraint constraint = new SecurityConstraint();
                    constraint.setUserConstraint("CONFIDENTIAL");
                    SecurityCollection collection = new SecurityCollection();
                    collection.addPattern("/*");
                    constraint.addCollection(collection);
                    context.addConstraint(constraint);
                }
            };
            tomcat.addAdditionalTomcatConnectors(new Connector[]{this.createHttpsConnector()});
        } else {
            tomcat = new TomcatServletWebServerFactory();
            tomcat.setPort(ConfigureReader.instance().getPort());
        }
        tomcat.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.NOT_FOUND, "/prv/error.html"), new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, "/prv/error.html"), new ErrorPage(HttpStatus.UNAUTHORIZED, "/prv/error.html"), new ErrorPage(HttpStatus.FORBIDDEN, "/prv/forbidden.html")});
        return tomcat;
    }

    private Connector createHttpsConnector() {
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        connector.setScheme("https");
        connector.setPort(ConfigureReader.instance().getHttpsPort());
        Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
        protocol.setSSLEnabled(true);
        protocol.setKeystoreFile(ConfigureReader.instance().getHttpsKeyFile());
        protocol.setKeystoreType(ConfigureReader.instance().getHttpsKeyType());
        protocol.setKeystorePass(ConfigureReader.instance().getHttpsKeyPass());
        return connector;
    }

    static {
        System.setProperty("logging.level.root", "ERROR");
        run = false;
    }
}

