/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.configation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import kohgylw.kiftd.server.configation.DataAccess;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.webdav.KiftdWebDAVServlet;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.util.unit.DataSize;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

@AutoConfiguration
@ComponentScan(value={"kohgylw.kiftd.server.controller", "kohgylw.kiftd.server.service.impl", "kohgylw.kiftd.server.util", "kohgylw.kiftd.server.webdav.util"})
@ServletComponentScan(value={"kohgylw.kiftd.server.listener", "kohgylw.kiftd.server.filter"})
@Import(value={DataAccess.class})
public class MVC
extends ResourceHttpRequestHandler
implements WebMvcConfigurer {
    @Bean
    WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> enableDefaultServlet() {
        return factory -> factory.setRegisterDefaultServlet(true);
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        configurer.enable();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"file:" + ConfigureReader.instance().getPath() + File.separator + "webContext" + File.separator});
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(DataSize.ofBytes((long)-1L));
        factory.setLocation(ConfigureReader.instance().getTemporaryfilePath());
        return factory.createMultipartConfig();
    }

    @Bean
    public Gson gson() {
        return new GsonBuilder().create();
    }

    @Bean
    public ServletRegistrationBean<Servlet> WebDAVServlet() {
        return new ServletRegistrationBean((Servlet)new KiftdWebDAVServlet(), new String[]{"/dav/*"});
    }
}

