/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.configation;

import java.io.File;
import javax.sql.DataSource;
import kohgylw.kiftd.server.util.ConfigureReader;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

@Configurable
public class DataAccess {
    private static Resource[] mapperFiles;
    private static Resource mybatisConfg;

    @Bean
    public DataSource dataSource() {
        DriverManagerDataSource ds = new DriverManagerDataSource();
        ds.setDriverClassName(ConfigureReader.instance().getFileNodePathDriver());
        ds.setUrl(ConfigureReader.instance().getFileNodePathURL());
        ds.setUsername(ConfigureReader.instance().getFileNodePathUserName());
        ds.setPassword(ConfigureReader.instance().getFileNodePathPassWord());
        return ds;
    }

    @Bean(name={"sqlSessionFactory"})
    @Autowired
    public SqlSessionFactoryBean sqlSessionFactoryBean(DataSource ds) {
        SqlSessionFactoryBean ssf = new SqlSessionFactoryBean();
        ssf.setDataSource(ds);
        ssf.setConfigLocation(mybatisConfg);
        ssf.setMapperLocations(mapperFiles);
        return ssf;
    }

    @Bean
    public MapperScannerConfigurer mapperScannerConfigurer() {
        MapperScannerConfigurer msf = new MapperScannerConfigurer();
        msf.setBasePackage("kohgylw.kiftd.server.mapper");
        msf.setSqlSessionFactoryBeanName("sqlSessionFactory");
        return msf;
    }

    static {
        String mybatisResourceFolder = ConfigureReader.instance().getPath() + File.separator + "mybatisResource" + File.separator;
        String mapperFilesFolder = mybatisResourceFolder + "mapperXML" + File.separator;
        mapperFiles = new Resource[]{new FileSystemResource(mapperFilesFolder + "NodeMapper.xml"), new FileSystemResource(mapperFilesFolder + "FolderMapper.xml"), new FileSystemResource(mapperFilesFolder + "PropertiesMapper.xml")};
        mybatisConfg = new FileSystemResource(mybatisResourceFolder + "mybatis.xml");
    }
}

