/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.mc;

import java.util.ArrayList;
import java.util.List;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.ctl.KiftdCtl;
import kohgylw.kiftd.server.enumeration.LogLevel;
import kohgylw.kiftd.server.enumeration.VCLevel;
import kohgylw.kiftd.server.pojo.ExtendStores;
import kohgylw.kiftd.server.pojo.ServerSetting;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import kohgylw.kiftd.ui.callback.GetServerStatus;
import kohgylw.kiftd.ui.callback.UpdateSetting;
import kohgylw.kiftd.ui.module.ServerUIModule;
import kohgylw.kiftd.ui.pojo.FileSystemPath;

public class UIRunner {
    private static UIRunner ui;

    private UIRunner() throws Exception {
        Printer.init(true);
        ServerUIModule ui = ServerUIModule.getInsatnce();
        final KiftdCtl ctl = new KiftdCtl();
        ServerUIModule.setStartServer(() -> ctl.start());
        ServerUIModule.setOnCloseServer(() -> ctl.stop());
        ServerUIModule.setGetServerTime(() -> ServerTimeUtil.getServerTime());
        ServerUIModule.setGetServerStatus(new GetServerStatus(){

            @Override
            public boolean getServerStatus() {
                return ctl.started();
            }

            @Override
            public int getPropertiesStatus() {
                return ConfigureReader.instance().getPropertiesStatus();
            }

            @Override
            public int getPort() {
                return ConfigureReader.instance().getPort();
            }

            @Override
            public boolean getMustLogin() {
                return ConfigureReader.instance().mustLogin();
            }

            @Override
            public LogLevel getLogLevel() {
                return ConfigureReader.instance().getLogLevel();
            }

            @Override
            public String getFileSystemPath() {
                return ConfigureReader.instance().getFileSystemPath();
            }

            @Override
            public int getBufferSize() {
                return ConfigureReader.instance().getBuffSize();
            }

            @Override
            public VCLevel getVCLevel() {
                return ConfigureReader.instance().getVCLevel();
            }

            @Override
            public List<FileSystemPath> getExtendStores() {
                ArrayList<FileSystemPath> fsps = new ArrayList<FileSystemPath>();
                for (ExtendStores es : ConfigureReader.instance().getExtendStores()) {
                    FileSystemPath fsp = new FileSystemPath();
                    fsp.setIndex(es.getIndex());
                    fsp.setPath(es.getPath());
                    fsp.setType("\u6269\u5c55\u5b58\u50a8\u533a");
                    fsps.add(fsp);
                }
                return fsps;
            }

            @Override
            public LogLevel getInitLogLevel() {
                return ConfigureReader.instance().getInitLogLevel();
            }

            @Override
            public VCLevel getInitVCLevel() {
                return ConfigureReader.instance().getInitVCLevel();
            }

            @Override
            public String getInitFileSystemPath() {
                return ConfigureReader.instance().getInitFileSystemPath();
            }

            @Override
            public String getInitProt() {
                return ConfigureReader.instance().getInitPort();
            }

            @Override
            public String getInitBufferSize() {
                return ConfigureReader.instance().getInitBuffSize();
            }

            @Override
            public boolean isAllowChangePassword() {
                return ConfigureReader.instance().isAllowChangePassword();
            }

            @Override
            public boolean isOpenFileChain() {
                return ConfigureReader.instance().isOpenFileChain();
            }

            @Override
            public int getMaxExtendStoresNum() {
                return ConfigureReader.instance().getMaxExtendstoresNum();
            }
        });
        ServerUIModule.setUpdateSetting(new UpdateSetting(){

            @Override
            public boolean update(ServerSetting s) {
                return ConfigureReader.instance().doUpdate(s);
            }
        });
        ui.show();
    }

    public static UIRunner build() throws Exception {
        if (ui == null) {
            ui = new UIRunner();
        }
        return ui;
    }
}

