/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.mc;

import java.io.File;
import java.nio.file.FileAlreadyExistsException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.ctl.KiftdCtl;
import kohgylw.kiftd.server.exception.FilesTotalOutOfLimitException;
import kohgylw.kiftd.server.exception.FoldersTotalOutOfLimitException;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.util.file_system_manager.FileSystemManager;
import kohgylw.kiftd.util.file_system_manager.pojo.Folder;
import kohgylw.kiftd.util.file_system_manager.pojo.FolderView;

public class ConsoleRunner {
    private static ConsoleRunner cs;
    private static KiftdCtl ctl;
    private static String commandTips;
    private static String fsCommandTips;
    private static FolderView currentFolder;
    private Scanner reader;
    private ExecutorService worker;

    private ConsoleRunner() {
        Printer.init(false);
        ctl = new KiftdCtl();
        this.worker = Executors.newSingleThreadExecutor();
        commandTips = "kiftd:\u60a8\u53ef\u4ee5\u8f93\u5165\u4ee5\u4e0b\u6307\u4ee4\u4ee5\u63a7\u5236\u670d\u52a1\u5668\uff1a\r\n-start \u542f\u52a8\u670d\u52a1\u5668\r\n-stop \u505c\u6b62\u670d\u52a1\u5668\r\n-exit \u505c\u6b62\u670d\u52a1\u5668\u5e76\u9000\u51fa\u5e94\u7528\r\n-restart \u91cd\u542f\u670d\u52a1\u5668\r\n-files \u6587\u4ef6\u7ba1\u7406\r\n-status \u67e5\u770b\u670d\u52a1\u5668\u72b6\u6001\r\n-help \u663e\u793a\u5e2e\u52a9\u6587\u672c";
        fsCommandTips = "kiftd files:\u60a8\u53ef\u4ee5\u8f93\u5165\u4ee5\u4e0b\u6307\u4ee4\u8fdb\u884c\u6587\u4ef6\u7ba1\u7406\uff1a\r\nls \u663e\u793a\u5f53\u524d\u6587\u4ef6\u5939\u5185\u5bb9\uff08\u53ef\u4f7f\u7528\u53c2\u6570 \u201c-l\u201d \u663e\u793a\u6240\u6709\u9879\u76ee\u7684\u8be6\u7ec6\u4fe1\u606f\uff09\r\ncd {\u201c\u6587\u4ef6\u5939\u540d\u79f0\u201d \u6216 \u201c--\u6587\u4ef6\u5939\u5e8f\u53f7\u201d} \u8fdb\u5165\u6307\u5b9a\u6587\u4ef6\u5939\uff08\u793a\u4f8b\uff1a\u201ccd foo\u201d \u6216 \u201ccd --1\u201d\uff0c\u5982\u9700\u8fd4\u56de\u4e0a\u4e00\u7ea7\u8bf7\u8f93\u5165\u201ccd ../\u201d\uff09\r\nimport {\u8981\u5bfc\u5165\u7684\u672c\u5730\u6587\u4ef6\uff08\u5fc5\u987b\u4f7f\u7528\u5b8c\u6574\u8def\u5f84\uff09} \u5c06\u672c\u5730\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u5bfc\u5165\u81f3\u6b64\r\nexport {\u201c\u76ee\u6807\u540d\u79f0\u201d \u6216 \u201c--\u76ee\u6807\u5e8f\u53f7\u201d\uff08\u7701\u7565\u8be5\u9879\u5219\u5bfc\u51fa\u5f53\u524d\u6587\u4ef6\u5939\u7684\u5168\u90e8\u5185\u5bb9\uff09} {\u8981\u5bfc\u51fa\u81f3\u672c\u5730\u7684\u8def\u5f84\uff08\u5fc5\u987b\u4f7f\u7528\u5b8c\u6574\u8def\u5f84\uff09} \u5c06\u6307\u5b9a\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u5bfc\u51fa\u672c\u5730\r\nrm {\u201c\u76ee\u6807\u540d\u79f0\u201d \u6216 \u201c--\u76ee\u6807\u5e8f\u53f7\u201d} \u5220\u9664\u6307\u5b9a\u6587\u4ef6\u6216\u6587\u4ef6\u5939\r\nexit \u9000\u51fa\u6587\u4ef6\u7ba1\u7406\u5e76\u8fd4\u56dekiftd\u63a7\u5236\u53f0\r\nhelp \u663e\u793a\u5e2e\u52a9\u6587\u672c";
    }

    public static ConsoleRunner build(String[] args) {
        if (cs == null) {
            cs = new ConsoleRunner();
        }
        cs.execute(args);
        return cs;
    }

    private void execute(String[] args) {
        if (args.length > 0) {
            String command;
            switch (command = args[0]) {
                case "-export": {
                    this.doExport(args);
                    break;
                }
                case "-import": {
                    this.doImport(args);
                    break;
                }
                case "-transfer": {
                    this.doTransfer(args);
                    break;
                }
                case "-console": {
                    this.startKiftdByConsole();
                    break;
                }
                case "-start": {
                    ctl.start();
                    break;
                }
                default: {
                    Printer.instance.print("kiftd:\u65e0\u6548\u7684\u6307\u4ee4\uff0c\u4f7f\u7528\u63a7\u5236\u53f0\u6a21\u5f0f\u542f\u52a8\u8bf7\u8f93\u5165\u53c2\u6570 -console\uff0c\u76f4\u63a5\u542f\u52a8\u670d\u52a1\u5668\u5f15\u64ce\u8bf7\u8f93\u5165\u53c2\u6570 -start\uff0c\u4f7f\u7528UI\u6a21\u5f0f\u542f\u52a8\u8bf7\u4e0d\u8981\u4f20\u5165\u4efb\u4f55\u53c2\u6570\u3002");
                }
            }
        }
    }

    private void startKiftdByConsole() {
        Printer.instance.print(" \u9752\u9633\u7f51\u7edc\u6587\u4ef6\u7cfb\u7edf-kiftd \u63a7\u5236\u53f0\u6a21\u5f0f[Console model]");
        Printer.instance.print("Character encoding with UTF-8");
        Thread t = new Thread(() -> {
            Printer.instance.print("\u6b63\u5728\u521d\u59cb\u5316\u670d\u52a1\u5668...");
            if (ConfigureReader.instance().getPropertiesStatus() == 0) {
                this.awaiting();
            }
        });
        t.start();
    }

    private void startServer() {
        Printer.instance.print("\u6267\u884c\u547d\u4ee4\uff1a\u542f\u52a8\u670d\u52a1\u5668...");
        if (ctl.started()) {
            Printer.instance.print("\u9519\u8bef\uff1a\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u52a8\u4e86\u3002\u60a8\u53ef\u4ee5\u4f7f\u7528 -status \u547d\u4ee4\u67e5\u770b\u670d\u52a1\u5668\u8fd0\u884c\u72b6\u6001\u6216\u4f7f\u7528 -stop \u547d\u4ee4\u505c\u6b62\u670d\u52a1\u5668\u3002");
        } else if (ctl.start()) {
            Printer.instance.print("kiftd\u670d\u52a1\u5668\u5df2\u542f\u52a8\uff0c\u53ef\u4ee5\u6b63\u5e38\u8bbf\u95ee\u4e86\uff0c\u60a8\u53ef\u4ee5\u4f7f\u7528 -status \u6307\u4ee4\u67e5\u770b\u8fd0\u884c\u72b6\u6001\u3002");
        } else if (ConfigureReader.instance().getPropertiesStatus() != 0) {
            switch (ConfigureReader.instance().getPropertiesStatus()) {
                case 1: {
                    Printer.instance.print("\u9519\u8bef\uff1akiftd\u670d\u52a1\u5668\u672a\u80fd\u542f\u52a8\uff0c\u7aef\u53e3\u8bbe\u7f6e\u65e0\u6548\u3002");
                    break;
                }
                case 4: {
                    Printer.instance.print("\u9519\u8bef\uff1akiftd\u670d\u52a1\u5668\u672a\u80fd\u542f\u52a8\uff0c\u7f13\u5b58\u8bbe\u7f6e\u65e0\u6548\u3002");
                    break;
                }
                case 3: {
                    Printer.instance.print("\u9519\u8bef\uff1akiftd\u670d\u52a1\u5668\u672a\u80fd\u542f\u52a8\uff0c\u6587\u4ef6\u7cfb\u7edf\u8def\u5f84\u6216\u67d0\u4e00\u6269\u5c55\u5b58\u50a8\u533a\u8bbe\u7f6e\u65e0\u6548\u3002");
                    break;
                }
                case 2: {
                    Printer.instance.print("\u9519\u8bef\uff1akiftd\u670d\u52a1\u5668\u672a\u80fd\u542f\u52a8\uff0c\u65e5\u5fd7\u8bbe\u7f6e\u65e0\u6548\u3002");
                    break;
                }
                case 10: {
                    Printer.instance.print("\u9519\u8bef\uff1akiftd\u670d\u52a1\u5668\u672a\u80fd\u542f\u52a8\uff0c\u767b\u5f55\u9a8c\u8bc1\u7801\u8bbe\u7f6e\u65e0\u6548\u3002");
                    break;
                }
                default: {
                    Printer.instance.print("\u9519\u8bef\uff1akiftd\u670d\u52a1\u5668\u672a\u80fd\u542f\u52a8\uff0c\u8bf7\u91cd\u8bd5\u6216\u68c0\u67e5\u8bbe\u7f6e\u3002");
                    break;
                }
            }
        } else {
            Printer.instance.print("\u9519\u8bef\uff1akiftd\u670d\u52a1\u5668\u672a\u80fd\u542f\u52a8\uff0c\u8bf7\u91cd\u8bd5\u6216\u68c0\u67e5\u8bbe\u7f6e\u3002");
        }
    }

    private void exit() {
        Printer.instance.print("\u6267\u884c\u547d\u4ee4\uff1a\u505c\u6b62\u670d\u52a1\u5668\u5e76\u9000\u51fakiftd...");
        if (ctl.started() && ctl.stop()) {
            Printer.instance.print("\u670d\u52a1\u5668\u5df2\u5173\u95ed\uff0c\u505c\u6b62\u6240\u6709\u8bbf\u95ee\u3002");
        }
        this.worker.shutdown();
        Printer.instance.print("\u9000\u51fa\u5e94\u7528\u3002");
        System.exit(0);
    }

    private void restartServer() {
        Printer.instance.print("\u6267\u884c\u547d\u4ee4\uff1a\u91cd\u542f\u670d\u52a1\u5668...");
        if (ctl.started()) {
            if (ctl.stop()) {
                if (ctl.start()) {
                    Printer.instance.print("\u670d\u52a1\u5668\u91cd\u542f\u6210\u529f\uff0c\u53ef\u4ee5\u6b63\u5e38\u8bbf\u95ee\u4e86\u3002");
                } else {
                    Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u91cd\u65b0\u542f\u52a8\u670d\u52a1\u5668\uff0c\u8bf7\u5c1d\u8bd5\u624b\u52a8\u542f\u52a8\u3002");
                }
            } else {
                Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u5173\u95ed\u670d\u52a1\u5668\uff0c\u8bf7\u5c1d\u8bd5\u624b\u52a8\u5173\u95ed\u3002");
            }
        } else {
            Printer.instance.print("\u9519\u8bef\uff1a\u670d\u52a1\u5668\u5c1a\u672a\u542f\u52a8\u3002\u60a8\u53ef\u4ee5\u4f7f\u7528 -start \u547d\u4ee4\u542f\u52a8\u670d\u52a1\u5668\u6216\u4f7f\u7528 -status \u547d\u4ee4\u67e5\u770b\u670d\u52a1\u5668\u8fd0\u884c\u72b6\u6001\u3002");
        }
    }

    private void stopServer() {
        Printer.instance.print("\u6267\u884c\u547d\u4ee4\uff1a\u505c\u6b62\u670d\u52a1\u5668...");
        if (ctl.started()) {
            if (ctl.stop()) {
                Printer.instance.print("\u670d\u52a1\u5668\u5df2\u5173\u95ed\uff0c\u505c\u6b62\u6240\u6709\u8bbf\u95ee\u3002");
            } else {
                Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u5173\u95ed\u670d\u52a1\u5668\uff0c\u60a8\u53ef\u4ee5\u5c1d\u8bd5\u5f3a\u5236\u5173\u95ed\u3002");
            }
        } else {
            Printer.instance.print("\u9519\u8bef\uff1a\u670d\u52a1\u5668\u5c1a\u672a\u542f\u52a8\u3002\u60a8\u53ef\u4ee5\u4f7f\u7528 -start \u547d\u4ee4\u542f\u52a8\u670d\u52a1\u5668\u6216\u4f7f\u7528 -exit \u547d\u4ee4\u9000\u51fa\u5e94\u7528\u3002");
        }
    }

    private void awaiting() {
        Thread t = new Thread(() -> {
            this.reader = new Scanner(System.in);
            Printer.instance.print("\u547d\u4ee4\u5e2e\u52a9\uff1a\r\n" + commandTips + "\r\n");
            try {
                block24: while (true) {
                    String command;
                    Printer.instance.print("kiftd: console$ ");
                    switch (command = this.reader.nextLine().trim()) {
                        case "": {
                            continue block24;
                        }
                        case "-start": {
                            this.startServer();
                            continue block24;
                        }
                        case "-stop": {
                            this.stopServer();
                            continue block24;
                        }
                        case "-restart": {
                            this.restartServer();
                            continue block24;
                        }
                        case "-status": {
                            this.printServerStatus();
                            continue block24;
                        }
                        case "-files": {
                            this.fileSystemManagerModel();
                            continue block24;
                        }
                        case "-exit": {
                            this.reader.close();
                            this.exit();
                            return;
                        }
                        case "help": 
                        case "--help": 
                        case "-help": {
                            Printer.instance.print("\u547d\u4ee4\u5e2e\u52a9\uff1a\r\n" + commandTips);
                            continue block24;
                        }
                    }
                    Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u8bc6\u522b\u7684\u6307\u4ee4\u3002\r\n" + commandTips);
                }
            }
            catch (Exception e) {
                Printer.instance.print(e.toString());
                Printer.instance.print("\u9519\u8bef\uff1a\u8bfb\u53d6\u547d\u4ee4\u65f6\u51fa\u73b0\u610f\u5916\u5bfc\u81f4\u7a0b\u5e8f\u9000\u51fa\uff0c\u8bf7\u91cd\u542fkiftd\u3002");
                return;
            }
        });
        t.start();
    }

    private void printServerStatus() {
        Printer.instance.print("\u670d\u52a1\u5668\u72b6\u6001\uff1a\r\n<Port>\u7aef\u53e3\u53f7:" + ConfigureReader.instance().getPort() + "\r\n<LogLevel>\u65e5\u5fd7\u7b49\u7ea7:" + (Object)((Object)ConfigureReader.instance().getLogLevel()) + "\r\n<BufferSize>\u7f13\u51b2\u533a\u5927\u5c0f:" + ConfigureReader.instance().getBuffSize() + " B\r\n<FileSystemPath>\u6587\u4ef6\u7cfb\u7edf\u5b58\u50a8\u8def\u5f84\uff1a" + ConfigureReader.instance().getFileSystemPath() + "\r\n<MustLogin>\u662f\u5426\u5fc5\u987b\u767b\u5f55\uff1a" + ConfigureReader.instance().mustLogin() + "\r\n<Running>\u8fd0\u884c\u72b6\u6001\uff1a" + ctl.started());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fileSystemManagerModel() {
        Printer.instance.print("\u5df2\u8fdb\u5165\u6587\u4ef6\u7ba1\u7406\u529f\u80fd\u3002");
        try {
            if (currentFolder == null || currentFolder.getCurrent() == null || FileSystemManager.getInstance().selectFolderById(currentFolder.getCurrent().getFolderId()) == null) {
                this.getFolderView("root");
            }
        }
        catch (Exception e) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u6253\u5f00\u6587\u4ef6\u7cfb\u7edf\uff0c\u8be5\u6587\u4ef6\u7cfb\u7edf\u53ef\u80fd\u6b63\u5728\u88ab\u53e6\u4e00\u4e2akiftd\u5360\u7528\u3002");
            return;
        }
        System.out.println("\u547d\u4ee4\u5e2e\u52a9\uff1a\r\n" + fsCommandTips + "\r\n");
        try {
            block14: while (true) {
                System.out.println("kiftd: " + currentFolder.getCurrent().getFolderName() + "$ ");
                String command = this.reader.nextLine().trim();
                if (command.length() == 0) continue;
                if (command.startsWith("cd ")) {
                    this.gotoFolder(command.substring(3));
                    continue;
                }
                if (command.startsWith("import ")) {
                    this.doImport(command.substring(7));
                    continue;
                }
                if (command.startsWith("rm ")) {
                    this.doDelete(command.substring(3));
                    continue;
                }
                if (command.startsWith("export ")) {
                    this.doExport(command.substring(7));
                    continue;
                }
                if (command.startsWith("ls ") || command.equals("ls")) {
                    String[] oArgs = command.substring(2).trim().split(" ");
                    String[] args = (String[])Arrays.stream(oArgs).filter(s -> !s.isEmpty()).toArray(String[]::new);
                    if (args.length == 0) {
                        this.showCurrentFolder(false);
                        continue;
                    }
                    if (args.length == 1 && "-l".equals(args[0])) {
                        this.showCurrentFolder(true);
                        continue;
                    }
                    Printer.instance.print("\u9519\u8bef\uff1a\u663e\u793a\u5f53\u524d\u6587\u4ef6\u5939\u5185\u5bb9\u5931\u8d25\uff0c\u8f93\u5165\u53c2\u6570\u4e0d\u6b63\u786e\u3002");
                    continue;
                }
                switch (command) {
                    case "exit": {
                        Printer.instance.print("\u9000\u51fa\u6587\u4ef6\u7ba1\u7406\u3002");
                        return;
                    }
                    case "help": 
                    case "--help": 
                    case "-help": {
                        Printer.instance.print("\u547d\u4ee4\u5e2e\u52a9\uff1a\r\n" + fsCommandTips);
                        continue block14;
                    }
                }
                Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u8bc6\u522b\u7684\u6307\u4ee4\u3002\r\n" + fsCommandTips);
            }
        }
        catch (Exception e) {
            Printer.instance.print("\u9519\u8bef\uff1a\u8bfb\u53d6\u547d\u4ee4\u65f6\u51fa\u73b0\u610f\u5916\uff0c\u5df2\u9000\u51fa\u6587\u4ef6\u7ba1\u7406\u529f\u80fd\u3002");
            return;
        }
    }

    private void getFolderView(String fid) throws SQLException {
        currentFolder = FileSystemManager.getInstance().getFolderView(fid);
    }

    private void showCurrentFolder(boolean showDetailedInformation) {
        try {
            String folderId = currentFolder.getCurrent().getFolderId();
            if (Math.max(FileSystemManager.getInstance().getFilesTotalNumByFoldersId(folderId), FileSystemManager.getInstance().getFoldersTotalNumByFoldersId(folderId)) > Integer.MAX_VALUE) {
                System.out.println("\u8b66\u544a\uff1a\u6587\u4ef6\u5939\u5217\u8868\u957f\u5ea6\u8d85\u8fc7\u6700\u5927\u9650\u503c\uff0c\u53ea\u80fd\u663e\u793a\u524d2147483647\u884c\u3002");
            }
            currentFolder = FileSystemManager.getInstance().getFolderView(folderId);
        }
        catch (SQLException e) {
            this.openFolderError();
            return;
        }
        List<Folder> fls = currentFolder.getFolders();
        int index = 1;
        for (Folder f : fls) {
            StringBuffer row = new StringBuffer();
            row.append("--" + index);
            row.append("\t");
            row.append("[\u6587\u4ef6\u5939]");
            row.append("\t");
            row.append(f);
            if (showDetailedInformation) {
                row.append("\t");
                row.append(f.getFolderCreationDate());
                row.append("\t");
                row.append("--");
                row.append("\t");
                row.append(f.getFolderCreator());
            }
            System.out.println(row.toString());
            ++index;
        }
        List<Node> fs = currentFolder.getFiles();
        for (Node f : fs) {
            StringBuffer row = new StringBuffer();
            row.append("--" + index);
            row.append("\t");
            row.append("[\u6587\u4ef6]");
            row.append("\t");
            row.append(f.getFileName());
            if (showDetailedInformation) {
                row.append("\t");
                row.append(f.getFileCreationDate());
                row.append("\t");
                row.append(this.formatFileSize(f.getFileSize()));
                row.append("\t");
                row.append(f.getFileCreator());
            }
            System.out.println(row.toString());
            ++index;
        }
        System.out.println();
    }

    private String formatFileSize(String value) {
        String unit;
        double convertSize;
        long size = Long.parseLong(value);
        if (size < 1024L) {
            convertSize = size;
            unit = "B";
        } else if (size < 0x100000L) {
            convertSize = (double)size / 1024.0;
            unit = "KB";
        } else if (size < 0x40000000L) {
            convertSize = (double)size / 1048576.0;
            unit = "MB";
        } else if (size < 0x10000000000L) {
            convertSize = (double)size / 1.073741824E9;
            unit = "GB";
        } else {
            convertSize = (double)size / 1.099511627776E12;
            unit = "TB";
        }
        return String.format("%.1f", convertSize) + " " + unit;
    }

    private void gotoFolder(String fname) {
        fname = fname.trim();
        try {
            currentFolder = FileSystemManager.getInstance().getFolderView(currentFolder.getCurrent().getFolderId());
            String fid = this.getSelectFolderId(fname);
            if (fid != null) {
                this.getFolderView(fid);
                return;
            }
            Printer.instance.print("\u9519\u8bef\uff1a\u8be5\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u5176\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u5939\uff08" + fname + "\uff09\u3002");
        }
        catch (SQLException e) {
            this.openFolderError();
        }
    }

    public Object getPath(String path) {
        if (path.startsWith("/ROOT")) {
            String[] paths = path.split("/");
            try {
                String parent = "null";
                for (int i = 1; i < paths.length - 1; ++i) {
                    String folderName = paths[i];
                    parent = FileSystemManager.getInstance().getFoldersByParentId(parent).parallelStream().filter(e -> e.getFolderName().equals(folderName)).findFirst().get().getFolderId();
                }
                String fname = paths[paths.length - 1];
                List<Folder> folders = FileSystemManager.getInstance().getFoldersByParentId(parent);
                if (path.endsWith("/") || folders.parallelStream().anyMatch(e -> e.getFolderName().equals(fname))) {
                    return folders.parallelStream().filter(e -> e.getFolderName().equals(fname)).findFirst().get();
                }
                return FileSystemManager.getInstance().selectNodesByFolderId(parent).parallelStream().filter(e -> e.getFileName().equals(fname)).findFirst().get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String getSelectFolderId(String fname) {
        if ("../".equals(fname) || "..".equals(fname)) {
            if (currentFolder.getCurrent().getFolderId().equals("root")) {
                return "root";
            }
            return currentFolder.getCurrent().getFolderParent();
        }
        if ("./".equals(fname) || ".".equals(fname)) {
            return currentFolder.getCurrent().getFolderId();
        }
        if (fname.startsWith("--")) {
            try {
                int index = Integer.parseInt(fname.substring(2));
                if (index >= 1 && index <= currentFolder.getFolders().size()) {
                    return currentFolder.getFolders().get(index - 1).getFolderId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        try {
            return currentFolder.getFolders().parallelStream().filter(e -> e.getFolderName().equals(fname)).findFirst().get().getFolderId();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    private String getSelectFolderOrFileId(String fname) {
        if ("../".equals(fname) || "..".equals(fname)) {
            if (currentFolder.getCurrent().getFolderId().equals("root")) {
                return "root";
            }
            return currentFolder.getCurrent().getFolderParent();
        }
        if ("./".equals(fname) || ".".equals(fname)) {
            return currentFolder.getCurrent().getFolderId();
        }
        if (fname.startsWith("--")) {
            try {
                int index = Integer.parseInt(fname.substring(2));
                if (index >= 1 && index <= currentFolder.getFolders().size()) {
                    return currentFolder.getFolders().get(index - 1).getFolderId();
                }
                return currentFolder.getFiles().get(index - currentFolder.getFolders().size() - 1).getFileId();
            }
            catch (Exception index) {
                return null;
            }
        }
        try {
            return currentFolder.getFolders().parallelStream().filter(e -> e.getFolderName().equals(fname)).findFirst().get().getFolderId();
        }
        catch (NoSuchElementException e2) {
            try {
                return currentFolder.getFiles().parallelStream().filter(m -> m.getFileName().equals(fname)).findFirst().get().getFileId();
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doImport(String[] args) {
        try {
            String type;
            File target;
            Object path;
            String importPath;
            String importTarget;
            if (args.length == 2) {
                importTarget = args[1];
                importPath = "/ROOT";
                path = FileSystemManager.getInstance().selectFolderById("root");
                target = new File(importTarget);
            } else {
                if (args.length != 3 && args.length != 4) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u5fc5\u987b\u6307\u5b9a\u5bfc\u5165\u76ee\u6807\uff08\u793a\u4f8b\uff1a\u201c-import /ROOT/ /home/your/import/file.txt\u201d\uff09\u3002");
                    return;
                }
                importPath = args[1];
                importTarget = args[2];
                target = new File(importTarget);
                path = this.getPath(importPath);
            }
            if (!(path instanceof Folder)) {
                Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u5165\u4f4d\u7f6e\uff08" + importPath + "\uff09\u5fc5\u987b\u662f\u4e00\u4e2a\u6587\u4ef6\u5939\uff08\u793a\u4f8b\uff1a\u201c/ROOT\u201d\uff09\u3002");
                return;
            }
            String folderId = ((kohgylw.kiftd.server.model.Folder)path).getFolderId();
            if (!target.exists()) {
                Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u8981\u5bfc\u5165\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff08" + importTarget + "\uff09\u3002");
                return;
            }
            File[] files = new File[]{target};
            if (FileSystemManager.getInstance().hasExistsFilesOrFolders(files, folderId) > 0) {
                if (args.length == 4) {
                    switch (args[3]) {
                        case "-C": {
                            type = "COVER";
                            break;
                        }
                        case "-B": {
                            type = "BOTH";
                            break;
                        }
                        default: {
                            Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u8def\u5f84\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff08\u8bf7\u4f7f\u7528\u4ee5\u4e0b\u53c2\u6570\uff1a[-C]\u8986\u76d6 [-B]\u4fdd\u7559\u4e24\u8005\uff09\u3002");
                            return;
                        }
                    }
                } else {
                    if (args.length != 2) {
                        Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u8def\u5f84\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff08\u8bf7\u589e\u52a0\u4ee5\u4e0b\u53c2\u6570\uff1a[-C]\u8986\u76d6 [-B]\u4fdd\u7559\u4e24\u8005\uff09\u3002");
                        return;
                    }
                    type = "COVER";
                }
            } else {
                type = "cancel";
            }
            if (FileSystemManager.getInstance().importFrom(files, folderId, type)) {
                return;
            }
            Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u53ef\u80fd\u5bfc\u5165\u5168\u90e8\u6587\u4ef6\u3002");
            return;
        }
        catch (Exception e1) {
            Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u51fa\u73b0\u610f\u5916\u9519\u8bef\u3002");
        }
    }

    private void doImport(String fpath) {
        File f = new File(fpath = fpath.trim());
        if (!f.exists()) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u5bfc\u5165\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff0c\u8be5\u76ee\u6807\u4e0d\u5b58\u5728\uff08" + fpath + "\uff09\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002");
            return;
        }
        String targetFolder = currentFolder.getCurrent().getFolderId();
        String type = "";
        File[] importFiles = new File[]{f};
        ProgressListener pl = null;
        try {
            if (FileSystemManager.getInstance().hasExistsFilesOrFolders(importFiles, targetFolder) > 0) {
                System.out.println("\u63d0\u793a\uff1a\u8be5\u8def\u5f84\u4e0b\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff08" + f.getName() + "\uff09\uff0c\u60a8\u5e0c\u671b\uff1f[C]\u53d6\u6d88 [V]\u8986\u76d6 [B]\u4fdd\u7559\u4e24\u8005");
                block14: while (true) {
                    String command;
                    switch (command = this.reader.nextLine().trim()) {
                        case "C": {
                            Printer.instance.print("\u5bfc\u5165\u88ab\u53d6\u6d88\u3002");
                            return;
                        }
                        case "V": {
                            type = "COVER";
                            break block14;
                        }
                        case "B": {
                            type = "BOTH";
                            break block14;
                        }
                        default: {
                            System.out.println("\u8bf7\u8f93\u5165C\u3001V\u6216B\uff1a");
                            continue block14;
                        }
                    }
                    break;
                }
            }
            Printer.instance.print("\u6b63\u5728\u5bfc\u5165\uff0c\u8bf7\u7a0d\u5019...");
            pl = new ProgressListener();
            this.worker.execute(pl);
            FileSystemManager.getInstance().importFrom(importFiles, targetFolder, type);
            pl.c = false;
            Printer.instance.print("\u5bfc\u5165\u5b8c\u6210\u3002");
        }
        catch (FilesTotalOutOfLimitException e1) {
            if (pl != null) {
                pl.c = false;
            }
            Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u8be5\u6587\u4ef6\u5939\u5185\u7684\u6587\u4ef6\u6570\u76ee\u5df2\u8fbe\u4e0a\u9650\uff0c\u65e0\u6cd5\u5bfc\u5165\u66f4\u591a\u6587\u4ef6\u3002");
        }
        catch (FoldersTotalOutOfLimitException e2) {
            if (pl != null) {
                pl.c = false;
            }
            Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u8be5\u6587\u4ef6\u5939\u5185\u7684\u6587\u4ef6\u5939\u6570\u76ee\u5df2\u8fbe\u4e0a\u9650\uff0c\u65e0\u6cd5\u5bfc\u5165\u66f4\u591a\u6587\u4ef6\u5939\u3002");
        }
        catch (Exception e3) {
            if (pl != null) {
                pl.c = false;
            }
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u5bfc\u5165\u8be5\u6587\u4ef6\uff08\u6216\u6587\u4ef6\u5939\uff09\uff0c\u8bf7\u91cd\u8bd5\u3002");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doExport(String[] args) {
        try {
            String type;
            String[] filesId;
            String[] foldersId;
            Object target;
            File path;
            String exportTarget;
            String exportPath;
            if (args.length == 2) {
                exportPath = args[1];
                exportTarget = "/ROOT";
                path = new File(exportPath);
                target = FileSystemManager.getInstance().selectFolderById("root");
            } else {
                if (args.length != 3 && args.length != 4) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u51fa\u5931\u8d25\uff0c\u5fc5\u987b\u6307\u5b9a\u5bfc\u51fa\u8def\u5f84\uff08\u793a\u4f8b\uff1a\u201c-export /ROOT/ /home/your/export/folder\u201d\uff09\u3002");
                    return;
                }
                exportTarget = args[1];
                exportPath = args[2];
                target = this.getPath(exportTarget);
                path = new File(exportPath);
            }
            if (!path.isDirectory()) {
                Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u51fa\u8def\u5f84\uff08" + exportPath + "\uff09\u5fc5\u987b\u6307\u5411\u4e00\u4e2a\u5df2\u7ecf\u5b58\u5728\u7684\u6587\u4ef6\u5939\u3002");
                return;
            }
            if (target == null) {
                Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u51fa\u5931\u8d25\uff0c\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff08" + exportTarget + "\uff09\u3002");
                return;
            }
            if (target instanceof Node) {
                foldersId = new String[]{};
                filesId = new String[]{((Node)target).getFileId()};
            } else {
                if (!(target instanceof Folder)) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u51fa\u5931\u8d25\uff0c\u51fa\u73b0\u610f\u5916\u9519\u8bef\u3002");
                    return;
                }
                foldersId = new String[]{((Folder)target).getFolderId()};
                filesId = new String[]{};
            }
            if (FileSystemManager.getInstance().hasExistsFilesOrFolders(foldersId, filesId, path) > 0) {
                if (args.length == 4) {
                    switch (args[3]) {
                        case "-C": {
                            type = "COVER";
                            break;
                        }
                        case "-B": {
                            type = "BOTH";
                            break;
                        }
                        default: {
                            Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u51fa\u5931\u8d25\uff0c\u5bfc\u51fa\u8def\u5f84\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff08\u8bf7\u4f7f\u7528\u4ee5\u4e0b\u53c2\u6570\uff1a[-C]\u8986\u76d6 [-B]\u4fdd\u7559\u4e24\u8005\uff09\u3002");
                            return;
                        }
                    }
                } else {
                    if (args.length != 2) {
                        Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u51fa\u5931\u8d25\uff0c\u5bfc\u51fa\u8def\u5f84\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff08\u8bf7\u589e\u52a0\u4ee5\u4e0b\u53c2\u6570\uff1a[-C]\u8986\u76d6 [-B]\u4fdd\u7559\u4e24\u8005\uff09\u3002");
                        return;
                    }
                    type = "COVER";
                }
            } else {
                type = "cancel";
            }
            if (FileSystemManager.getInstance().exportTo(foldersId, filesId, path, type)) {
                return;
            }
            Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u51fa\u5931\u8d25\uff0c\u53ef\u80fd\u672a\u5bfc\u51fa\u5168\u90e8\u6587\u4ef6\u3002");
            return;
        }
        catch (Exception e1) {
            Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u51fa\u5931\u8d25\uff0c\u51fa\u73b0\u610f\u5916\u9519\u8bef\u3002");
        }
    }

    private void doExport(String command) {
        String id;
        String path;
        command = command.trim();
        String[] oArgs = command.split(" ");
        String[] args = (String[])Arrays.stream(oArgs).filter(s -> !s.isEmpty()).toArray(String[]::new);
        ProgressListener pl = null;
        if (args.length == 1) {
            path = args[0];
            id = currentFolder.getCurrent().getFolderId();
        } else if (args.length == 2) {
            id = this.getSelectFolderOrFileId(args[0]);
            path = args[1];
        } else {
            Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u51fa\u5931\u8d25\uff0c\u8f93\u5165\u53c2\u6570\u4e0d\u6b63\u786e\u3002");
            return;
        }
        File targetPath = new File(path);
        if (targetPath.isDirectory()) {
            if (id == null) {
                Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u51fa\u5931\u8d25\uff0c\u8be5\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff08" + args[0] + "\uff09\u3002");
                return;
            }
            try {
                String[] foldersId = null;
                String[] filesId = null;
                String type = "";
                if (id.equals(currentFolder.getCurrent().getFolderId()) || currentFolder.getFolders().parallelStream().anyMatch(e -> e.getFolderId().equals(id))) {
                    foldersId = new String[]{id};
                    filesId = new String[]{};
                } else if (currentFolder.getFiles().parallelStream().anyMatch(e -> e.getFileId().equals(id))) {
                    foldersId = new String[]{};
                    filesId = new String[]{id};
                } else {
                    Printer.instance.print("\u9519\u8bef\uff1a\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\uff08\u6216\u6587\u4ef6\u5939\uff09\u4e0d\u5408\u6cd5\uff0c\u53ea\u5141\u8bb8\u5728\u5f53\u524d\u6587\u4ef6\u5939\u5185\u7684\u9009\u62e9\uff08" + path + "\uff09\u3002");
                    return;
                }
                if (FileSystemManager.getInstance().hasExistsFilesOrFolders(foldersId, filesId, targetPath) > 0) {
                    System.out.println("\u63d0\u793a\uff1a\u8be5\u8def\u5f84\u4e0b\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff08" + targetPath.getName() + "\uff09\uff0c\u60a8\u5e0c\u671b\uff1f[C]\u53d6\u6d88 [V]\u8986\u76d6 [B]\u4fdd\u7559\u4e24\u8005");
                    block12: while (true) {
                        String command2;
                        switch (command2 = this.reader.nextLine().trim()) {
                            case "C": {
                                Printer.instance.print("\u5bfc\u51fa\u88ab\u53d6\u6d88\u3002");
                                return;
                            }
                            case "V": {
                                type = "COVER";
                                break block12;
                            }
                            case "B": {
                                type = "BOTH";
                                break block12;
                            }
                            default: {
                                System.out.println("\u8bf7\u8f93\u5165C\u3001V\u6216B\uff1a");
                                continue block12;
                            }
                        }
                        break;
                    }
                }
                Printer.instance.print("\u6b63\u5728\u5bfc\u51fa\uff0c\u8bf7\u7a0d\u5019...");
                pl = new ProgressListener();
                this.worker.execute(pl);
                FileSystemManager.getInstance().exportTo(foldersId, filesId, targetPath, type);
                pl.c = false;
                Printer.instance.print("\u5bfc\u51fa\u5b8c\u6210\u3002");
            }
            catch (Exception e1) {
                if (pl != null) {
                    pl.c = false;
                }
                Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u5bfc\u51fa\u8be5\u6587\u4ef6\uff08\u6216\u6587\u4ef6\u5939\uff09\uff0c\u8bf7\u91cd\u8bd5\u3002");
            }
        } else {
            Printer.instance.print("\u9519\u8bef\uff1a\u5bfc\u51fa\u5931\u8d25\uff0c\u5bfc\u51fa\u7684\u76ee\u6807\u5fc5\u987b\u662f\u4e00\u4e2a\u6587\u4ef6\u5939\uff08" + path + "\uff09\u3002");
        }
    }

    private void doTransfer(String[] args) {
        if (args.length == 3) {
            try {
                short extendStoreIndex = Short.parseShort(args[1]);
                File reservePath = new File(args[2]);
                if (!reservePath.isDirectory()) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u79fb\u51fa\u6570\u636e\u7684\u4fdd\u5b58\u8def\u5f84\uff08" + args[2] + "\uff09\u5fc5\u987b\u6307\u5411\u4e00\u4e2a\u5df2\u7ecf\u5b58\u5728\u7684\u6587\u4ef6\u5939\u3002");
                    return;
                }
                try {
                    long total = FileSystemManager.getInstance().getTotalOfNodesAtExtendStore(extendStoreIndex);
                    if (total > 0L) {
                        FileSystemManager.getInstance().transferExtendStore(extendStoreIndex, reservePath);
                        return;
                    }
                    Printer.instance.print("\u9519\u8bef\uff1a\u8be5\u6269\u5c55\u5b58\u50a8\u533a\uff08" + args[1] + "\uff09\u4e0d\u5b58\u5728\u6216\u5176\u5185\u90e8\u5c1a\u65e0\u4efb\u4f55\u6570\u636e\uff0c\u65e0\u9700\u6267\u884c\u8be5\u64cd\u4f5c\u3002");
                    return;
                }
                catch (FileAlreadyExistsException e1) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u76ee\u6807\u6587\u4ef6\u5939\u5185\u5b58\u5728\u540c\u540d\u6587\u4ef6\uff0c\u5efa\u8bae\u9009\u62e9\u4e00\u4e2a\u7a7a\u6587\u4ef6\u5939\u4f5c\u4e3a\u79fb\u51fa\u6570\u636e\u7684\u4fdd\u5b58\u8def\u5f84\u3002");
                }
                catch (Exception e2) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u79fb\u51fa\u8be5\u6269\u5c55\u5b58\u50a8\u533a\u5185\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u8bd5\u3002");
                }
            }
            catch (NumberFormatException e) {
                Printer.instance.print("\u9519\u8bef\uff1a\u6269\u5c55\u5b58\u50a8\u533a\u7f16\u53f7\uff08" + args[1] + "\uff09\u65e0\u6cd5\u88ab\u8bc6\u522b\u3002");
            }
        } else {
            Printer.instance.print("\u9519\u8bef\uff1a\u79fb\u51fa\u5931\u8d25\uff0c\u5fc5\u987b\u6307\u5b9a\u8981\u79fb\u51fa\u7684\u6269\u5c55\u5b58\u50a8\u533a\u7f16\u53f7\u548c\u79fb\u51fa\u6570\u636e\u7684\u4fdd\u5b58\u8def\u5f84\uff08\u793a\u4f8b\uff1a\u201c-transfer 1 /home/your/transfer/folder\u201d\uff09\u3002");
        }
    }

    private void doDelete(String fname) {
        fname = fname.trim();
        ProgressListener pl = null;
        try {
            currentFolder = FileSystemManager.getInstance().getFolderView(currentFolder.getCurrent().getFolderId());
        }
        catch (SQLException e2) {
            this.openFolderError();
            return;
        }
        String id = this.getSelectFolderOrFileId(fname);
        try {
            if (currentFolder.getFolders().parallelStream().anyMatch(e -> e.getFolderId().equals(id))) {
                if (this.confirmOpt("\u786e\u8ba4\u8981\u5220\u9664\u8be5\u6587\u4ef6\u5939\u4e48\uff1f")) {
                    Printer.instance.print("\u6b63\u5728\u5220\u9664\u6587\u4ef6\u5939\uff0c\u8bf7\u7a0d\u5019...");
                    pl = new ProgressListener();
                    this.worker.execute(pl);
                    if (FileSystemManager.getInstance().delete(new String[]{id}, new String[0])) {
                        Printer.instance.print("\u5220\u9664\u5b8c\u6bd5\u3002");
                    } else {
                        Printer.instance.print("\u5220\u9664\u5931\u8d25\uff0c\u53ef\u80fd\u672a\u80fd\u5220\u9664\u8be5\u6587\u4ef6\u5939\uff0c\u8bf7\u91cd\u8bd5\u3002");
                    }
                    pl.c = false;
                } else {
                    Printer.instance.print("\u5df2\u53d6\u6d88\u5220\u9664\u3002");
                }
                return;
            }
            if (currentFolder.getFiles().parallelStream().anyMatch(e -> e.getFileId().equals(id))) {
                if (this.confirmOpt("\u786e\u8ba4\u8981\u5220\u9664\u8be5\u6587\u4ef6\u4e48\uff1f")) {
                    Printer.instance.print("\u6b63\u5728\u5220\u9664\u6587\u4ef6\uff0c\u8bf7\u7a0d\u5019...");
                    pl = new ProgressListener();
                    this.worker.execute(pl);
                    if (FileSystemManager.getInstance().delete(new String[0], new String[]{id})) {
                        Printer.instance.print("\u5220\u9664\u5b8c\u6bd5\u3002");
                    } else {
                        Printer.instance.print("\u5220\u9664\u5931\u8d25\uff0c\u53ef\u80fd\u672a\u80fd\u5220\u9664\u8be5\u6587\u4ef6\uff0c\u8bf7\u91cd\u8bd5\u3002");
                    }
                    pl.c = false;
                } else {
                    Printer.instance.print("\u5df2\u53d6\u6d88\u5220\u9664\u3002");
                }
                return;
            }
        }
        catch (Exception e1) {
            if (pl != null) {
                pl.c = false;
            }
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u5220\u9664\u6587\u4ef6\uff0c\u8bf7\u91cd\u8bd5\u3002");
        }
        Printer.instance.print("\u9519\u8bef\uff1a\u8be5\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff08" + fname + "\uff09\u3002");
    }

    private boolean confirmOpt(String tip) {
        System.out.println("\u63d0\u793a\uff1a" + tip + " [Y/N]");
        while (true) {
            String command;
            System.out.print("> ");
            switch (command = this.reader.nextLine().trim()) {
                case "Y": {
                    return true;
                }
                case "N": {
                    return false;
                }
            }
            System.out.println("\u5fc5\u987b\u6b63\u786e\u8f93\u5165Y\u6216N\uff1a");
        }
    }

    private void openFolderError() {
        Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u8bfb\u53d6\u6307\u5b9a\u6587\u4ef6\u5939\uff0c\u662f\u5426\u8fd4\u56de\u6839\u76ee\u5f55\uff1f[Y/N]");
        while (true) {
            String command;
            System.out.print("> ");
            switch (command = this.reader.nextLine().trim()) {
                case "Y": {
                    try {
                        currentFolder = FileSystemManager.getInstance().getFolderView("root");
                    }
                    catch (SQLException e1) {
                        Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u8bfb\u53d6\u6839\u76ee\u5f55\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u6253\u5f00\u6587\u4ef6\u7ba1\u7406\u7cfb\u7edf\u6216\u91cd\u542fkiftd\u3002");
                    }
                    return;
                }
                case "N": {
                    return;
                }
            }
            System.out.println("\u8bf7\u8f93\u5165Y\u6216N\uff1a");
        }
    }

    class ProgressListener
    implements Runnable {
        private boolean c = true;

        ProgressListener() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (this.c) {
                System.out.println(FileSystemManager.message);
                System.out.println("\u5f53\u524d\u8fdb\u5ea6\uff1a" + FileSystemManager.per + "%");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

