/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.schild.jave.process.ProcessKiller;

public class ProcessWrapper
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessWrapper.class);
    private final String ffmpegExecutablePath;
    private final ArrayList<String> args = new ArrayList();
    private Process ffmpeg = null;
    private ProcessKiller ffmpegKiller = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private InputStream errorStream = null;

    public ProcessWrapper(String ffmpegExecutablePath) {
        this.ffmpegExecutablePath = ffmpegExecutablePath;
    }

    public void addArgument(String arg) {
        this.args.add(arg);
    }

    public void execute(boolean destroyOnRuntimeShutdown, boolean openIOStreams) throws IOException {
        Stream<String> execArgs = Stream.concat(Stream.of(this.ffmpegExecutablePath), this.args.stream());
        execArgs = this.enhanceArguments(execArgs);
        List<String> execList = execArgs.collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            LOG.debug("About to execute {}", (Object)execList.stream().collect(Collectors.joining(" ")));
        }
        Runtime runtime = Runtime.getRuntime();
        this.ffmpeg = runtime.exec(execList.toArray(new String[0]));
        if (destroyOnRuntimeShutdown) {
            this.ffmpegKiller = new ProcessKiller(this.ffmpeg);
            runtime.addShutdownHook(this.ffmpegKiller);
        }
        if (openIOStreams) {
            this.inputStream = this.ffmpeg.getInputStream();
            this.outputStream = this.ffmpeg.getOutputStream();
            this.errorStream = this.ffmpeg.getErrorStream();
        }
    }

    protected Stream<String> enhanceArguments(Stream<String> execArgs) {
        return execArgs;
    }

    public void execute() throws IOException {
        this.execute(true, true);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public void destroy() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Throwable t) {
                LOG.warn("Error closing input stream", t);
            }
            this.inputStream = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (Throwable t) {
                LOG.warn("Error closing output stream", t);
            }
            this.outputStream = null;
        }
        if (this.errorStream != null) {
            try {
                this.errorStream.close();
            }
            catch (Throwable t) {
                LOG.warn("Error closing error stream", t);
            }
            this.errorStream = null;
        }
        if (this.ffmpeg != null) {
            this.ffmpeg.destroy();
            this.ffmpeg = null;
        }
        if (this.ffmpegKiller != null) {
            Runtime runtime = Runtime.getRuntime();
            runtime.removeShutdownHook(this.ffmpegKiller);
            this.ffmpegKiller = null;
        }
    }

    public int getProcessExitCode() {
        try {
            this.ffmpeg.waitFor();
        }
        catch (InterruptedException ex) {
            LOG.warn("Interrupted during waiting on process, forced shutdown?", (Throwable)ex);
        }
        return this.ffmpeg.exitValue();
    }

    @Override
    public void close() {
        this.destroy();
    }
}

