/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.filters;

import ws.schild.jave.filters.Filter;
import ws.schild.jave.info.VideoSize;

public class ZoomPanFilter
extends Filter {
    public ZoomPanFilter() {
        super("zoompan");
    }

    public ZoomPanFilter(Integer durationFrames, VideoSize inputSize, VideoSize outputSize) {
        super("zoompan");
        this.addNamedArgument("d", durationFrames.toString());
        this.addNamedArgument("s", outputSize.asEncoderArgument());
        this.addNamedArgument("zoom", outputSize.aspectRatioExpression() + "/" + inputSize.aspectRatioExpression());
        this.addNamedArgument("x", "(" + inputSize.getWidth() + "*zoom-" + inputSize.getWidth() + ")/2");
        this.addNamedArgument("y", "1/(1+exp(-20*(on/(25*4)-0.5)))*(ih-ih/zoom)");
    }

    public ZoomPanFilter(Integer durationFrames, VideoSize outputSize, String zoomExpression, String xExpression, String yExpression) {
        super("zoompan");
        this.addNamedArgument("d", durationFrames.toString());
        this.addNamedArgument("s", outputSize.asEncoderArgument());
        this.addNamedArgument("zoom", zoomExpression);
        this.addNamedArgument("x", xExpression);
        this.addNamedArgument("y", yExpression);
    }
}

