/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.encode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import ws.schild.jave.encode.enums.VsyncMethod;
import ws.schild.jave.encode.enums.X264_PROFILE;
import ws.schild.jave.filters.FilterGraph;
import ws.schild.jave.filters.VideoFilter;
import ws.schild.jave.info.VideoSize;

public class VideoAttributes
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String DIRECT_STREAM_COPY = "copy";
    private String codec = null;
    private String tag = null;
    private Integer bitRate = null;
    private Integer frameRate = null;
    private VideoSize size = null;
    private Integer quality = null;
    private String pixelFormat = null;
    private VsyncMethod vsync = null;
    private FilterGraph complexFiltergraph = null;
    private final ArrayList<VideoFilter> videoFilters = new ArrayList();
    private boolean faststart = false;
    private X264_PROFILE x264Profile = null;

    public Optional<String> getCodec() {
        return Optional.ofNullable(this.codec);
    }

    public VideoAttributes setCodec(String codec) {
        this.codec = codec;
        return this;
    }

    public Optional<String> getTag() {
        return Optional.ofNullable(this.tag);
    }

    public VideoAttributes setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public Optional<Integer> getBitRate() {
        return Optional.ofNullable(this.bitRate);
    }

    public VideoAttributes setBitRate(Integer bitRate) {
        this.bitRate = bitRate;
        return this;
    }

    public Optional<Integer> getFrameRate() {
        return Optional.ofNullable(this.frameRate);
    }

    public VideoAttributes setFrameRate(Integer frameRate) {
        this.frameRate = frameRate;
        return this;
    }

    public Optional<VideoSize> getSize() {
        return Optional.ofNullable(this.size);
    }

    public VideoAttributes setSize(VideoSize size) {
        this.size = size;
        return this;
    }

    public boolean isFaststart() {
        return this.faststart;
    }

    public Optional<FilterGraph> getComplexFiltergraph() {
        return Optional.ofNullable(this.complexFiltergraph);
    }

    public VideoAttributes setComplexFiltergraph(FilterGraph complexFiltergraph) {
        this.complexFiltergraph = complexFiltergraph;
        return this;
    }

    public void addFilter(VideoFilter videoFilter) {
        this.videoFilters.add(videoFilter);
    }

    public ArrayList<VideoFilter> getVideoFilters() {
        return this.videoFilters;
    }

    public VideoAttributes setFaststart(boolean faststart) {
        this.faststart = faststart;
        return this;
    }

    public Optional<Integer> getQuality() {
        return Optional.ofNullable(this.quality);
    }

    public VideoAttributes setQuality(Integer quality) {
        this.quality = quality;
        return this;
    }

    public Optional<String> getPixelFormat() {
        return Optional.ofNullable(this.pixelFormat);
    }

    public VideoAttributes setPixelFormat(String pixelFormat) {
        this.pixelFormat = pixelFormat;
        return this;
    }

    public Optional<VsyncMethod> getVsync() {
        return Optional.ofNullable(this.vsync);
    }

    public VideoAttributes setVsync(VsyncMethod vsync) {
        this.vsync = vsync;
        return this;
    }

    public String toString() {
        return this.getClass().getName() + "(codec=" + this.codec + ", bitRate=" + this.bitRate + ", frameRate=" + this.frameRate + ", size=" + this.size + ", faststart=" + this.faststart + ", quality=" + this.quality + ")";
    }

    public Optional<X264_PROFILE> getX264Profile() {
        return Optional.ofNullable(this.x264Profile);
    }

    public VideoAttributes setX264Profile(X264_PROFILE x264Profile) {
        this.x264Profile = x264Profile;
        return this;
    }
}

