/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.schild.jave.EncoderException;
import ws.schild.jave.InputFormatException;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.info.MultimediaInfo;
import ws.schild.jave.process.ProcessLocator;
import ws.schild.jave.process.ProcessWrapper;
import ws.schild.jave.process.ffmpeg.DefaultFFMPEGLocator;
import ws.schild.jave.utils.RBufferedReader;
import ws.schild.jave.utils.Utils;

public class ScreenExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(ScreenExtractor.class);
    private final ProcessLocator locator;
    private int numberOfScreens;

    public ScreenExtractor() {
        this.locator = new DefaultFFMPEGLocator();
    }

    public int getNumberOfScreens() {
        return this.numberOfScreens;
    }

    public ScreenExtractor(ProcessLocator locator) {
        this.locator = locator;
    }

    public void render(MultimediaObject multimediaObject, int width, int height, int seconds, File outputDir, String fileNamePrefix, String extension, int quality) throws InputFormatException, EncoderException {
        String inputSource = multimediaObject.toString();
        try {
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                LOG.debug("Failed to create destination folder");
                throw new SecurityException();
            }
            if (!multimediaObject.isURL() && !multimediaObject.getFile().canRead()) {
                LOG.debug("Failed to open input file");
                throw new SecurityException();
            }
        }
        catch (SecurityException e) {
            LOG.debug("Access denied checking destination folder", (Throwable)e);
        }
        MultimediaInfo multimediaInfo = multimediaObject.getInfo();
        this.numberOfScreens = Math.round((float)multimediaInfo.getDuration() / 1000.0f / (float)seconds);
        ProcessWrapper ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-i");
        ffmpeg.addArgument(inputSource);
        ffmpeg.addArgument("-f");
        ffmpeg.addArgument("image2");
        ffmpeg.addArgument("-vf");
        ffmpeg.addArgument(String.format("fps=fps=1/%s", String.valueOf(seconds)));
        if (width != -1) {
            ffmpeg.addArgument("-s");
            ffmpeg.addArgument(String.format("%sx%s", String.valueOf(width), String.valueOf(height)));
        }
        ffmpeg.addArgument("-qscale");
        ffmpeg.addArgument(String.valueOf(quality));
        ffmpeg.addArgument(String.format("%s%s%s-%%04d.%s", outputDir.getAbsolutePath(), File.separator, fileNamePrefix, extension));
        try {
            ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            String line;
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            int lineNR = 0;
            while ((line = reader.readLine()) != null) {
                LOG.debug("Input Line ({}): {}", (Object)(++lineNR), (Object)line);
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
    }

    public void render(MultimediaObject multimediaObject, int width, int height, int seconds, File outputDir, int quality) throws EncoderException {
        String inputSource = multimediaObject.toString();
        outputDir = outputDir.getAbsoluteFile();
        outputDir.getParentFile().mkdirs();
        try {
            if (!multimediaObject.isURL() && !multimediaObject.getFile().canRead()) {
                LOG.debug("Failed to open input file");
                throw new SecurityException();
            }
        }
        catch (SecurityException e) {
            LOG.debug("Access denied checking destination folder", (Throwable)e);
        }
        MultimediaInfo multimediaInfo = multimediaObject.getInfo();
        int duration = (int)(multimediaInfo.getDuration() / 1000L);
        this.numberOfScreens = seconds <= duration ? 1 : 0;
        ProcessWrapper ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-i");
        ffmpeg.addArgument(inputSource);
        ffmpeg.addArgument("-f");
        ffmpeg.addArgument("image2");
        ffmpeg.addArgument("-vframes");
        ffmpeg.addArgument("1");
        ffmpeg.addArgument("-ss");
        ffmpeg.addArgument(Utils.buildTimeDuration(seconds * 1000));
        if (width != -1) {
            ffmpeg.addArgument("-s");
            ffmpeg.addArgument(String.format("%sx%s", String.valueOf(width), String.valueOf(height)));
        }
        ffmpeg.addArgument("-qscale");
        ffmpeg.addArgument(String.valueOf(quality));
        ffmpeg.addArgument(outputDir.getAbsolutePath());
        try {
            ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            String line;
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            int lineNR = 0;
            while ((line = reader.readLine()) != null) {
                LOG.debug("Input Line ({}): {}", (Object)(++lineNR), (Object)line);
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
    }

    public void renderOneImage(MultimediaObject multimediaObject, int width, int height, long millis, File outputFile, int quality) throws InputFormatException, EncoderException {
        this.renderOneImage(multimediaObject, width, height, millis, outputFile, quality, true);
    }

    public void renderOneImage(MultimediaObject multimediaObject, int width, int height, long millis, File outputFile, int quality, boolean keyframesSeeking) throws InputFormatException, EncoderException {
        String inputSource = multimediaObject.toString();
        try {
            if (outputFile.exists()) {
                outputFile.delete();
            }
            if (!multimediaObject.isURL() && !multimediaObject.getFile().canRead()) {
                LOG.debug("Failed to open input file");
                throw new SecurityException();
            }
        }
        catch (SecurityException e) {
            LOG.debug("Access denied checking destination folder", (Throwable)e);
        }
        ProcessWrapper ffmpeg = this.locator.createExecutor();
        if (keyframesSeeking) {
            ffmpeg.addArgument("-ss");
            ffmpeg.addArgument(Utils.buildTimeDuration(millis));
        }
        ffmpeg.addArgument("-i");
        ffmpeg.addArgument(inputSource);
        if (!keyframesSeeking) {
            ffmpeg.addArgument("-ss");
            ffmpeg.addArgument(Utils.buildTimeDuration(millis));
        }
        ffmpeg.addArgument("-vframes");
        ffmpeg.addArgument("1");
        if (width != -1) {
            ffmpeg.addArgument("-s");
            ffmpeg.addArgument(String.format("%sx%s", String.valueOf(width), String.valueOf(height)));
        }
        ffmpeg.addArgument("-qscale");
        ffmpeg.addArgument(String.valueOf(quality));
        ffmpeg.addArgument(outputFile.getAbsolutePath());
        try {
            ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            String line;
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            int lineNR = 0;
            while ((line = reader.readLine()) != null) {
                LOG.debug("Input Line ({}): {}", (Object)(++lineNR), (Object)line);
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
    }
}

