<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */

if (!defined('IN_DZZ')) {
    exit('Access Denied');
}
Hook::listen('check_login');
include_once libfile('function/organization');
$uid = isset($_GET['uid']) ? intval($_GET['uid']) : $_G['uid'];
$zero = $_GET['zero'] ? htmlspecialchars($_GET['zero']) : lang('no_institution_users');
$template = isset($_GET['template']) ? $_GET['template'] : '';
$limit = 1000;
if ($_GET['do'] == 'orgtree') {
    $id = intval($_GET['id']);
    $nouser = intval($_GET['nouser']);//不显示用户
    $stype = intval($_GET['stype']);  //0:可以选择部门群组和用户；1：仅选择部门群组：2：仅选择用户
    $moderator = intval($_GET['moderator']);//是否仅可以选择我管理的群组或部门
    $onlymyorg = intval($_GET['onlymyorg']);//是否只显示我所在的部门
    $range = intval($_GET['range']);//0：所有部门和群组；1：仅部门；2：仅群组
    $showjob = intval($_GET['showjob']); //是否显示职位
    //判断用户有没有操作权限
    $ismoderator = C::t('organization_admin')->ismoderator_by_uid_orgid($id, $_G['uid']);

    if (!$moderator || $ismoderator) {
        $disable = '';
        $type = 'user';
    } else {
        $disable = '"disabled":true,';
        $type = "disabled";
    }

    $data = [];
    if ($_GET['id'] == '#') {
        if ($_G['adminid'] != 1 && $moderator) $topids = C::t('organization_admin')->fetch_toporgids_by_uid($_G['uid']);
        foreach (C::t('organization')->fetch_all_by_forgid($id) as $value) {
            if ($_G['adminid'] != 1) {
                //仅显示我管理的部门时，判断用户是否有管理权限
                if($moderator && !in_array($value['orgid'], $topids)) continue;
                //仅显示我所在的部门时，判断用户是否在该部门中
                if ($onlymyorg && !C::t('organization')->ismember($value['orgid'], $_G['uid'])) continue;
            }
            if ($value['type'] == '1' && $range == 1) {
                continue;
            } elseif ($value['type'] == '0' && $range == 2) {
                continue;
            }
            if (!$moderator || C::t('organization_admin')->ismoderator_by_uid_orgid($value['orgid'], $_G['uid'])) {
                $orgdisable = false;
                $orgtype = 'organization';
            } else {
                $orgdisable = true;
                $orgtype = 'disable';
            }
            $arr = [
                'id' => $value['orgid'],
                'text' => $value['orgname'],
                'state' => ['disabled' => $orgdisable],
                "type" => $orgtype,
                'children' => true];

            if (preg_match('/^\d+$/', $value['aid']) && $value['aid'] > 0) {
                $arr['text'] = $value['orgname'];
                $arr['icon'] = 'index.php?mod=io&op=thumbnail&width=24&height=24&path=' . dzzencode('attach::' . $value['aid']);
            } else {
                $arr['text'] = avatar_group($value['orgid'], $value) . $value['orgname'];
                $arr['icon'] = false;
            }
            $data[] = $arr;
        }
        if ($stype != 1 && $range < 2 || $stype == 2 && $onlymyorg == 1) {
            $data[] = ['id' => 'other', 'text' => $zero, 'state' => ['disabled' => $disable], "type" => ($type == "disabled") ? $type : 'default', 'children' => true];
        }

    } elseif ($_GET['id'] == 'other') {//获取用户列表，无机构用户
        if (($moderator && $_G['adminid'] != 1) || $nouser || $stype == 1) {
        } else {
            $isother = true;
            //仅显示我所在的部门时，有部门的用户则不显示
            if ($_G['adminid'] != 1 && $onlymyorg && C::t('organization_user')->fetch_num_by_uid($_G['uid'])) {
                $isother = false;
            }
            if ($isother) {
                $datas = [];
                foreach (C::t('organization_user')->fetch_user_not_in_orgid($limit) as $value) {
                    $datas[] = [
                        'id' => 'uid_' . $value['uid'],
                        'text' => $value['username'] . '<em class="hide">' . $value['email'] . '</em>',
                        'icon' => 'dzz/system/images/user.png',
                        'state' => ['disabled' => $disable],
                        "type" => $type,
                        'li_attr' => [
                            'uid' => $value['uid'],
                            'username' => $value['username'],
                            'avatarstatus' => $value['avatarstatus'],
                            'headerColor'  => $value['headerColor'],
                        ]
                    ];
                }
                getuserIcon($datas, $data);
            }
        }
    } else {//获取用户列表，有机构用户
        foreach (C::t('organization')->fetch_all_by_forgid($id) as $value) {
            //仅显示我所在的部门时，判断用户是否在该部门中
            if ($_G['adminid'] != 1 && $onlymyorg && !C::t('organization')->ismember($value['orgid'], $_G['uid'])) continue;
            if (!$moderator || C::t('organization_admin')->ismoderator_by_uid_orgid($value['orgid'], $_G['uid'])) {
                $orgdisable = '';
                $orgtype = 'organization';
            } else {
                $orgdisable = '"disabled":true,';
                $orgtype = 'disabled';
            }
            $arr = [
                'id' => $value['orgid'],
                'text' => $value['orgname'],
                'state' => ['disabled' => $orgdisable],
                "type" => $orgtype,
                'children' => true];

            if (preg_match('/^\d+$/', $value['aid']) && $value['aid'] > 0) {
                $arr['text'] = $value['orgname'];
                $arr['icon'] = 'index.php?mod=io&op=thumbnail&width=24&height=24&path=' . dzzencode('attach::' . $value['aid']);
            } else {
                $arr['text'] = avatar_group($value['orgid'], $value) . $value['orgname'];
                $arr['icon'] = false;
            }
            $data[] = $arr;
        }
        if ($nouser || $stype == 1 || ($moderator && !$ismoderator)) {

        } else {
            $isorguid = true;
            //仅显示我所在的部门时，判断用户是否在该部门中
            if ($_G['adminid'] != 1 && $onlymyorg && !C::t('organization_user')->fetch_num_by_orgid_uid($id, $_G['uid'])) {
                $isorguid = false;
            }
            if ($isorguid) {
                $datas = [];
                foreach (C::t('organization_user')->fetch_user_by_orgid($id, $limit) as $value) {
                    if (!$value['uid']) continue;
                    if ($showjob && $value['jobid']) $jobname = DB::result_first("select name from %t where jobid=%d", ['organization_job', $value['jobid']]);
                    $datas[] = [
                        'id' => 'orgid_' . $value['orgid'] . '_uid_' . $value['uid'],
                        'text' => $value['username'] . ($jobname ? '<em> [' . $jobname . ']</em>' : '') . '<em class="hide">' . $value['email'] . '</em>',
                        'icon' => 'dzz/system/images/user.png',
                        'state' => ['disabled' => $disable],
                        "type" => $type,
                        'li_attr' => [
                            'uid' => $value['uid'],
                            'username' => $value['username'],
                            'avatarstatus' => $value['avatarstatus'],
                            'headerColor'  => $value['headerColor'],
                        ]
                    ];
                }
                getuserIcon($datas, $data);
            }
        }
    }
    exit(json_encode($data));
} elseif ($_GET['do'] == 'search') {
    $nouser = intval($_GET['nouser']);
    $str = trim($_GET['str']);
    $str = '%' . $str . '%';
    $sql = "username LIKE %s";
    $sql_org = "orgname LIKE %s";
    //搜索用户
    $data = ['other'];
    if (!$nouser) {
        $uids = [];
        foreach (DB::fetch_all("select * from %t where $sql ", ['user', $str]) as $value) {
            $uids[] = $value['uid'];
            $data['uid_' . $value['uid']] = 'uid_' . $value['uid'];
        }
        $orgids = [];
        foreach ($orgusers = C::t('organization_user')->fetch_all_by_uid($uids) as $value) {
            $data['uid_' . $value['uid']] = 'orgid_' . $value['orgid'] . '_uid_' . $value['uid'];
            $orgids[] = $value['orgid'];
        }
    }
    foreach (DB::fetch_all("select orgid from %t where $sql_org", ['organization', $str]) as $value) {
        $orgids[] = $value['orgid'];
    }
    $orgids = array_unique($orgids);
    foreach ($orgids as $orgid) {
        $uporgids = C::t('organization')->fetch_parent_by_orgid($orgid, true);
        foreach ($uporgids as $value) {
            $data[$value] = $value;
        }
    }
    $temp = [];
    foreach ($data as $value) {
        $temp[] = $value;
    }
    exit(json_encode($temp));
}
function getuserIcon($datas, &$data) {
    foreach ($datas as $v) {
        $uid = $v['li_attr']['uid'];
        if ($v['li_attr']['avatarstatus']) {
            $v['icon'] = 'avatar.php?uid=' . $uid;
        } else {
            $v['icon'] = false;
            $v['text'] = avatar_block($uid, [], null, $v['li_attr']) . $v['text'];
        }
        $data[] = $v;
    }
}

if ($template == '1') {
    include template('lyear_orgtree', 'lyear');
} else {
    include template('orgtree');
}
