<?php
/* @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */
if (!defined('IN_DZZ')) {
    exit('Access Denied');
}
$uid = $_G['uid'];
$space = dzzgetspace($uid);
$space['self'] = intval($space['self']);
$data = [];
$data['myuid'] = $uid;
$data['deletefinally'] = 0;
if (isset($_G['setting']['explorer_finallydelete'])) {
    if (intval($_G['setting']['explorer_finallydelete']) === 0) {
        $data['deletefinally'] = 1;
    }
}
$applist = C::t('app_market')->fetch_all_by_default($_G['uid'],true);
//获取系统桌面设置信息
$icosdata = [];
//获取打开方式
$data['extopen']['all'] = C::t('app_open')->fetch_all_ext();
$data['extopen']['ext'] = C::t('app_open')->fetch_all_orderby_ext($_G['uid'], $data['extopen']['all'], $applist);
$data['extopen']['user'] = C::t('app_open_default')->fetch_all_by_uid($_G['uid']);
//目录数据
$folderdata = [];
$data['cut'] = [];
//用户粘贴板数据
$clipboardinfo = C::t('resources_clipboard')->fetch_by_uid($uid);
if ($clipboardinfo) {
    //复制类型1为复制，2为剪切
    $copttype = $clipboardinfo['copytype'];
    $data['cut']['iscut'] = ($copttype == 1) ? 0 : 1;

    $files = explode(',', $clipboardinfo['files']);
    foreach ($files as $v) {
        $resourcesdata = C::t('resources')->fetch_by_rid($v, true);
        if ($resourcesdata['type'] == 'folder') {
            $folderdata[$resourcesdata['fid']] = C::t('folder')->fetch_by_fid($resourcedata['oid']);
        }
        $icosdata[$v] = $resourcesdata;
    }
    $data['cut']['icos'] = $files;
} else {
    $data['cut']['icos'] = [];
}

$data['formhash'] = $_G['formhash'];
$data['sourcedata'] = [
    'icos' => $icosdata ?: [],
    'folder' => $folderdata ?: []
];
$space['attachextensions'] = $space['attachextensions'] ? explode(',', $space['attachextensions']) : [];
$space['explorermyset'] = dunserialize(C::t('user_setting')->fetch_by_skey('explorermyset', $uid));
$space['limitConcurrentUploads'] = $_G['setting']['explorer_limitConcurrentUploads'] ? intval($_G['setting']['explorer_limitConcurrentUploads']) : 3;
$data['space'] = $space;
$infoPanelOpened = C::t('user_setting')->fetch_by_skey('infoPanelOpened');
if (isset($infoPanelOpened)) {
    $data['infoPanelOpened'] = ($infoPanelOpened) ? 1 : 0;
} else {
    C::t('user_setting')->update_by_skey('infoPanelOpened', 1);
    $data['infoPanelOpened'] = 1;
}
echo json_encode($data);
exit();