<?php
/* @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */
if (!defined('IN_DZZ')) {
    exit('Access Denied');
}
$do = empty($_GET['do']) ? '' : trim($_GET['do']);
$uid = $_G['uid'];
$space = dzzgetspace($uid);
$space['self'] = intval($space['self']);
$refer = dreferer();

if ($do == 'deleteIco') {//删除文件到回收站
    $arr = [];
    $names = [];
    $icoids = $_GET['rids'];
    $ridarr = [];
    $bz = isset($_GET['bz']) ? trim($_GET['bz']) : '';
    $deletefinally = 0;
    if (isset($_G['setting']['explorer_finallydelete'])) {
        if (intval($_G['setting']['explorer_finallydelete']) === 0) {
            $deletefinally = 1;
        }
    }
    foreach ($icoids as $icoid) {
        $icoid = dzzdecode($icoid);
        if (empty($icoid)) {
            continue;
        }
        if (strpos($icoid, '../') !== false) {
            $arr['msg'][$return['rid']] = lang('illegal_calls');
        } else {
            $return = IO::Delete($icoid,$deletefinally);
            if (!$return['error']) {
                //处理数据
                $arr['sucessicoids'][$return['rid']] = $return['rid'];
                $arr['msg'][$return['rid']] = 'success';
                $ridarr[] = $return['rid'];
            } else {
                $arr['msg'][$return['rid']] = $return['error'];
            }
        }
    }
    //更新剪切板数据
    if (!empty($ridarr)) {
        C::t('resources_clipboard')->update_data_by_delrid($ridarr);
    }
    exit(json_encode($arr));
} elseif ($do == 'copyfile') {//复制或者剪切文件到云粘贴板
    $rids = isset($_GET['rids']) ? $_GET['rids'] : '';
    $bzrid = isset($_GET['rid']) ? $_GET['rid'] : '';
    $bz = isset($_GET['bz']) ? trim($_GET['bz']) : '';
    $paths = [];
    foreach ($rids as $rid) {
        $paths[] = dzzdecode($rid);
    }
    $copytype = isset($_GET['copytype']) ? intval($_GET['copytype']) : 1;
    $return = C::t('resources_clipboard')->insert_data($paths, $copytype, $bz);
    if ($return['error']) {
        $arr = ['msg' => $return['error']];
    } else {
        if ($bz && $bz !== 'dzz') {
            $rids = $bzrid;
        } else {
            $rids = explode(',', $return['rid']);
        }
        $arr = ['msg' => 'success', 'rid' => $rids, 'copyid' => $return['copyid'], 'type' => $return['type']];
    }
    exit(json_encode($arr));
} elseif ($do == 'rename') {
    if (!$path = dzzdecode($_GET['path'])) {
        exit(json_encode(['error' => lang('parameter_error')]));
    }
    $text = str_replace('...', '', getstr(IO::name_filter($_GET['text']), 80));
    $ret = IO::rename($path, $text);
    exit(json_encode($ret));

} elseif ($do == 'paste') {//粘贴复制或者剪切的文件
    $copyinfo = C::t('resources_clipboard')->fetch_by_uid();
    //复制文件rid
    $icoids = explode(',', $copyinfo['files']);
    //复制文件的bz
    $obz = !empty($copyinfo['bz']) ? $copyinfo['bz'] : '';
    //目标位置的bz
    $tbz = trim($_GET['tbz']);
    $tpath = trim($_GET['tpath']);

    $icoarr = [];
    $folderarr = [];

    //判断是否有粘贴文件
    if (!$icoids) {
        $data = ['error' => lang('data_error')];
        echo json_encode($data);
        exit();
    }
    //判断是否是剪切
    $iscopy = ($copyinfo['copytype'] == 1) ? 1 : 0;

    $data = [];
    $totalsize = 0;
    $icos = $folderids = [];
    //分4种情况：a：本地到api；b：api到api；c：api到本地；d：本地到本地；
    foreach ($icoids as $icoid) {
        if (empty($icoid)) {
            $data['error'][] = $icoid . '：' . lang('forbid_operation');
            continue;
        }
        $rid = rawurldecode($icoid);
        $path = rawurldecode($tpath);
        $return = IO::CopyTo($rid, $path, $iscopy);
        if ($return['success'] === true) {
            if (!$iscopy && $return['moved'] !== true) {
                IO::DeleteByData($return);
            }
            $data['icoarr'][] = $return['newdata'];
            if (!$tbz) {
                addtoconfig($return['newdata'], $ticoid);
            }

            if ($return['newdata']['type'] == 'folder') $data['folderarr'][] = IO::getFolderByIcosdata($return['newdata']);
            $data['successicos'][$return['rid']] = $return['newdata']['rid'];

        } else {
            $data['error'][] = $return['name'] . ':' . $return['success'];
        }
    }

    if ($data['successicos']) {
        $data['msg'] = 'success';
        C::t('resources_clipboard')->delete_by_uid();
        if (isset($data['error'])) $data['error'] = implode(';', $data['error']);
        $data['copytype'] = $iscopy;
    } else {
        $data['error'] = implode(';', $data['error']);
    }
    echo json_encode($data);
    exit();
} elseif ($do == 'recoverFile') {//恢复文件
    $arr = [];
    $icoids = $_GET['rids'];
    $bz = isset($_GET['bz']) ? trim($_GET['bz']) : '';
    foreach ($icoids as $icoid) {
        $icoid = dzzdecode($icoid);
        if (empty($icoid)) {
            continue;
        }
        //判断文件是否在回收站
        if (!$recycleinfo = C::t('resources_recyle')->get_data_by_rid($icoid)) {
            $arr['msg'][$icoid] = lang('file_longer_exists');
        } else {
            $return = IO::Recover($icoid);
        }
        if (!$return['error']) {
            $arr['sucessicoids'][$return['rid']] = $return['rid'];
            $arr['msg'][$return['rid']] = 'success';
            $arr['name'][$return['rid']] = $return['name'];
        } else {
            $arr['msg'][$return['rid']] = $return['error'];
        }
    }
    exit(json_encode($arr));
} elseif ($do == 'recoverAll') {//恢复所有文件
    $rids = C::t('resources_recyle')->fetch_all_rid();
    if (count($rids) < 1) exit(json_encode(['error' => lang('recycle_not_data')]));
    foreach ($rids as $icoid) {
        if (empty($icoid)) {
            continue;
        }
        //判断文件是否在回收站
        if (!$recycleinfo = C::t('resources_recyle')->get_data_by_rid($icoid)) {
            $arr['msg'][$icoid] = lang('file_longer_exists');
        } else {
            $return = IO::Recover($icoid);
        }

        if (!$return['error']) {
            $arr['sucessicoids'][$return['rid']] = $return['rid'];
            $arr['msg'][$return['rid']] = 'success';
            $arr['name'][$return['rid']] = $return['name'];
        } else {
            $arr['msg'][$return['rid']] = $return['error'];
        }
    }
    exit(json_encode($arr));
} elseif ($do == 'finallydelete') {//彻底删除文件
    $arr = [];
    $icoids = $_GET['rids'];
    $bz = isset($_GET['bz']) ? trim($_GET['bz']) : '';
    foreach ($icoids as $icoid) {
        $icoid = dzzdecode($icoid);
        if (empty($icoid)) {
            continue;
        }
        $return = IO::Delete($icoid, true);
        if (!$return['error']) {
            //处理数据
            $arr['sucessicoids'][$return['rid']] = $return['rid'];
            $arr['msg'][$return['rid']] = 'success';
            $arr['name'][$return['rid']] = $return['name'];
        } else {
            $arr['msg'][$return['rid']] = $return['error'];
        }
    }
    exit(json_encode($arr));
} elseif ($do == 'emptyallrecycle') {//清空回收站
    $rids = C::t('resources_recyle')->fetch_all_rid();
    if (count($rids) < 1) exit(json_encode(['error' => lang('recycle_not_data')]));
    foreach ($rids as $icoid) {
        //$icoid=dzzdecode($icoid);
        $return = IO::Delete($icoid, true);
        if (!isset($return['error'])) {
            //处理数据
            $arr['sucessicoids'][$return['rid']] = $return['rid'];
            $arr['msg'][$return['rid']] = 'success';
            $arr['name'][$return['rid']] = $return['name'];
        } else {
            $arr['msg'][$return['rid']] = $return['error'];
        }
    }
    exit(json_encode($arr));
} elseif ($do == 'uploadnewVersion') {//更新文件版本
    $rid = isset($_GET['rid']) ? $_GET['rid'] : '';
    $aid = isset($_GET['aid']) ? intval($_GET['aid']) : 0;
    if (!$rid || !$aid) {
        exit(json_encode(array('error' => '参数错误')));
    }
    $attach = C::t('attachment')->fetch($aid);
    if (!$attach) {
        exit(json_encode(array('error' => '文件不存在')));
    }
    $name = getstr($_GET['name']);
    $setarr = [
        'uid' => $uid,
        'username' => $_G['username'],
        'name' => $name ?: $attach['filename'],
        'aid' => intval($_GET['aid']),
        'size' => $attach['filesize'],
        'ext' => $attach['filetype'],
        'dateline' => TIMESTAMP
    ];
    $return = C::t('resources_version')->add_new_version_by_rid($rid, $setarr);
    if ($return['error']) {
        exit(json_encode(['error' => $return['error']]));
    } else {
        $resources = C::t('resources')->fetch_by_rid($rid, true);
        exit(json_encode(['success' => true, 'data' => $return, 'filedata' => $resources]));
    }
} elseif ($do == 'setpramiryversion') {//设置主版本
    $vid = isset($_GET['vid']) ? intval($_GET['vid']) : '';
    $return = C::t('resources_version')->set_primary_version_by_vid($vid);
    if ($return['rid']) {
        $resourcesdata = C::t('resources')->fetch_by_rid($return['rid'], true);
        exit(json_encode(['success' => true, 'data' => $resourcesdata]));
    } else {
        exit(json_encode(['error' => true, 'msg' => $return['error']]));
    }

} elseif ($do == 'setversionname') {//修改版本名称
    $vid = isset($_GET['vid']) ? intval($_GET['vid']) : '';
    $rid = isset($_GET['rid']) ? trim($_GET['rid']) : '';
    $vname = isset($_GET['vname']) ? getstr($_GET['vname']) : '';
    if (!$vname) exit(json_encode(['error' => lang('explorer_do_failed')]));
    $vdesc = isset($_GET['vdesc']) ? dhtmlspecialchars(substr(trim($_GET['vdesc']), 0, 120)) : '';
    $return = [];
    if ($vid) {
        $return = C::t('resources_version')->update_versionname_by_vid($vid, $vname, $vdesc);
    } else {
        $return = C::t('resources_version')->update_versionname_by_rid($rid, $vname, $vdesc);
    }
    if ($return['vid']) {
        exit(json_encode($return));
    } else {
        $msg = (!isset($return['error'])) ? lang('explorer_do_failed') : $return['error'];
        exit(json_encode(['error' => $msg]));
    }
} elseif ($do == 'riddesc') {//修改文件描述
    $rid = isset($_GET['rid']) ? trim($_GET['rid']) : '';
    if (!$rid) exit(json_encode(['error' => lang('explorer_do_failed')]));
    $fileinfo = C::t('resources')->get_property_by_rid($rid,false);
    if($fileinfo['error']) showmessage($fileinfo['error']);
    if(!$fileinfo['editperm']) showmessage('file_edit_no_privilege');
    $desc = isset($_GET['desc']) ? htmlspecialchars(trim($_GET['desc'])) : '';
    C::t('resources_meta')->update_by_key($rid, ['desc' => $desc]);
    exit(json_encode(['success' => true]));
}