<?php
if (!defined('IN_DZZ')) {
    exit('Access Denied');
}

class table_user_setting extends dzz_table {
    public function __construct() {
        $this->_table = 'user_setting';
        $this->_pk = 'id';
        $this->_pre_cache_key = 'user_setting_';
        $this->_cache_ttl = 60 * 60;
        parent::__construct();

    }

    public function insert($skeyarr, $uid = 0, $replace = false, $silent = false) {//插入用户设置
        if (!$uid) $uid = getglobal('uid');
        if (!$uid) return false;
        $cachkeys = [];
        foreach ($skeyarr as $key => $value) {
            $setarr = ['uid' => $uid,
                'skey' => $key,
                'svalue' => $value
            ];
            $cachkeys[] = $uid . '_' . $key;
            DB::insert($this->_table, $setarr, 0, 1);
        }
        //更新缓存
        $this->clear_cache($cachkeys);
        $this->clear_cache($uid);
        return true;
    }

    public function update($skeyarr, $uid = 0, $unbuffered = false, $low_priority = false) {//更新用户设置
        if (!$uid) $uid = getglobal('uid');
        if (!$uid) return false;
        $cachkeys = [];
        foreach ($skeyarr as $key => $value) {
            $setarr = ['uid' => $uid,
                'skey' => $key,
                'svalue' => $value,
            ];
            $cachkeys[] = $uid . '_' . $key;
            DB::insert($this->_table, $setarr, 0, 1);
        }
        //更新缓存
        $this->clear_cache($cachkeys);
        $this->clear_cache($uid);
        return true;
    }

    public function update_by_skey($skey, $val, $uid = 0) {
        if (!$uid) $uid = getglobal('uid');
        if (!$uid) return false;
        if (!DB::update($this->_table, ['svalue' => $val], ['uid' => $uid, 'skey' => $skey])) {
            $setarr = [
                'uid' => $uid,
                'skey' => $skey,
                'svalue' => $val
            ];
            DB::insert($this->_table, $setarr, 0, 1);
        }
        //更新缓存
        $this->clear_cache($uid . '_' . $skey);
        $this->clear_cache($uid);
        return true;
    }

    public function insert_by_skey($skey, $val, $uid = 0) {
        if (!$uid) $uid = getglobal('uid');
        if (!$uid) return false;
        $setarr = [
            'uid' => $uid,
            'skey' => $skey,
            'svalue' => $val
        ];
        parent::insert($setarr, 0, 1);
        //更新缓存
        $this->clear_cache($uid . '_' . $skey);
        $this->clear_cache($uid);
        return true;
    }

    public function fetch_by_skey($skey, $uid = 0) { //获取用户某项设置值
        if (!$uid) $uid = getglobal('uid');
        if (!$uid) return [];
        $cachekey = $uid . '_' . $skey;//增加缓存
        if ($ret = $this->fetch_cache($cachekey)) {
            return $ret;
        } else {
            $val = DB::result_first("select svalue from %t where uid=%d and skey=%s", [$this->_table, $uid, $skey]);
            $this->store_cache($cachekey, $val);
            return $val;
        }
    }

    public function delete_by_field($skeys, $uid = 0) { //删除用户某项设置值
        if (!$uid) $uid = getglobal('uid');
        if (!$uid) return false;
        $skeys = (array)$skeys;
        $cachekeys = [];
        foreach ($skeys as $skey) {
            $cachekeys[] = $uid . '_' . $skey;
        }
        if ($ret = DB::delete($this->_table, "skey IN (" . dimplode($skeys) . ") and uid=" . $uid)) {
            $this->clear_cache($cachekeys);
            $this->clear_cache($uid);
            return $ret;
        }
        return false;
    }

    public function delete_by_uid($uids) { //删除设置
        $uids = (array)$uids;
        $cachekeys = [];

        foreach (DB::fetch_all("select skey,uid from %t where uid IN (%n)", [$this->_table, $uids]) as $value) {
            $cachekeys[] = $value['uid'] . '_' . $value['skey'];
        }
        if ($ret = DB::delete($this->_table, "uid IN (" . dimplode($uids) . ")")) {
            $this->clear_cache($cachekeys);
            $this->clear_cache($uids);
            return $ret;
        }
        return false;

    }

    //获取当前用户所有设置项
    public function fetch_all_user_setting($uid = 0) {
        if (!$uid) $uid = getglobal('uid');
        if (!$uid) return [];
        $settings = [];
        $cachekey = 'settings_' . $uid;
        if (!($settings = $this->fetch_cache($cachekey))) {
            foreach (DB::fetch_all("select * from %t where uid = %d", [$this->_table, $uid]) as $v) {
                $settings[$v['skey']] = $v['svalue'];
            }
            $this->store_cache($cachekey, $settings);
        }
        return $settings;
    }
}