<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */
if (!defined('IN_DZZ')) {
    exit('Access Denied');
}

class table_user extends dzz_table {
    public function __construct() {

        $this->_table = 'user';
        $this->_pk = 'uid';
        $this->_pre_cache_key = 'user_';

        parent::__construct();
    }
    //更新数据
    public function update($uid, $data, $unbuffered = false, $replace = false) {
        $ret = parent::update($uid, $data, $unbuffered, $replace);
        if ($ret) {
            $fields = ['username', 'password', 'groupid', 'status', 'email', 'phone', 'nickname', 'adminid', 'salt'];
            
            $isfield = false;
            foreach ($fields as $field) {
                if (isset($data[$field])) {
                    $isfield = true;
                    break;
                }
            }

            if ($isfield) {
                if (isset($data['password'])) {
                    $data['password'] = '****';
                }

                writelog('updatelog', '修改用户(UID:' . $uid . ')信息：' . implodearray($data));
            }
        }

        return $ret;
    }

    /*public function fetch_safebindstatus($uid){
        $uid = intval($uid);
        $result = DB::fetch_first("select emailstatus,phonestatus from %t where uid = %d",array($this->_table,$uid));
        return $result;
    }*/
    public function add_user($userArr) {

        global $_G;

        if (empty($userArr)) return;
        $salt = substr(uniqid(rand()), -6);
        $groupid = '';
        if ($_G['setting']['regverify']) {
            $groupid = 8;
        } else {
            $groupid = $_G['setting']['newusergroupid'];
        }
        $setarr = [
            'username' => addslashes($userArr['username']),
            'nickname'=>addslashes($userArr['nickname']),
            'email' => isset($userArr['email']) ? $userArr['email'] : '',
            'phone' => isset($userArr['phone']) ? $userArr['phone'] : '',
            'salt' => $salt,
            'password' => md5(md5($userArr['password']) . $salt),
            'regdate' => TIMESTAMP,
            'regip' => $_G['clientip'],
            'groupid' => $groupid
        ];
        $setarr['uid'] = self::insert($setarr, 1);
        return $setarr;
    }

    public function user_register($userArr, $addorg = 1) {

        if (empty($userArr)) return;

        if ($userArr['username'] && ($status = uc_user_checkname($userArr['username'])) < 0) {
            return $status;
        }

        if (($status = uc_user_checkemail($userArr['email'])) < 0) {

            return $status;
        }

        $uid = self::add_user($userArr);

        //默认机构
        if ($addorg && is_array($uid) && getglobal('setting/defaultdepartment') && DB::fetch_first("select orgid from %t where orgid=%d ", ['organization', getglobal('setting/defaultdepartment')])) {
            C::t('organization_user')->insert_by_orgid(getglobal('setting/defaultdepartment'), $uid['uid']);
        }

        return $uid;
    }

    public function delete_by_uid($uid) {
        $user = parent::fetch($uid);
        if (self::checkfounder($user)) {//创始人不能删除
            return false;
        }
        return self::delete($uid);
    }

    public function checkfounder($user) {
        if (!$user['uid'] || $user['groupid'] != 1 || $user['adminid'] != 1) {
            return false;
        }
        $founders = str_replace(' ', '', getglobal('config/admincp/founder'));
        if (empty($founders)) {
            return false;
        } elseif (strexists(",$founders,", ",$user[uid],")) {
            return true;
        } elseif (!is_numeric($user['nickname']) && strexists(",$founders,", ",$user[nickname],")) {
            return true;
        } else {
            return false;
        }
    }

    public function setAdministror($uid, $groupid) {
        $user = getuserbyuid($uid);
        //if($user['adminid']==$adminid) return true;
        if (self::checkfounder($user)) { //创始人不允许修改
            return true;
        }
        $arr = [];
        if ($groupid == 1) {
            self::update($uid, ['adminid' => 1, 'groupid' => 1]);
        } else {
            if (empty($groupid)) $groupid = 9;
            //因为用户组权限开放，所有这里就不强制设为机构管理员了，以免用户组权限被覆盖
            // if(C::t('organization_admin')->fetch_orgids_by_uid($uid)){
            //     $groupid=2;
            // } elseif($groupid == 2) {
            //     $groupid=9;
            // }
            self::update($uid, ['adminid' => 0, 'groupid' => $groupid]);
        }
    }

    public function fetch_userbasic_by_uid($uid) {
        return DB::fetch_first("select uid,email,username from %t where uid = %d", [$this->_table, $uid]);
    }

    public function increase($uids, $setarr) {
        $uids = dintval((array)$uids, true);
        $sql = [];
        $allowkey = ['newprompt'];
        foreach ($setarr as $key => $value) {
            if (($value = intval($value)) && in_array($key, $allowkey)) {
                $sql[] = "`$key`=`$key`+'$value'";
            }
        }
        if (!empty($sql)) {
            DB::query("UPDATE " . DB::table($this->_table) . " SET " . implode(',', $sql) . " WHERE uid IN (" . dimplode($uids) . ")", 'UNBUFFERED');
            $this->increase_cache($uids, $setarr);
        }
    }


    public function fetch_all_by_username($usernames, $fetch_archive = 1) {
        $users = [];
        if (!empty($usernames)) {
            $users = DB::fetch_all('SELECT * FROM %t WHERE username IN (%n)', [$this->_table, (array)$usernames], 'username');
        }
        return $users;
    }

    /*
     * 新增
     * 以uid查询用户数据
     * **/
    public function get_user_by_uid($uid) {

        $uid = intval($uid);

        static $users = [];

        if ($uid && empty($users[$uid])) {

            $users[$uid] = DB::fetch_first("select * from %t  where uid = %d", [$this->_table, $uid]);
        }

        if ($users[$uid]['adminid'] == 1) $users[$uid]['self'] = 2;

        return $users[$uid];

    }

    public function fetch_uid_by_username($username, $fetch_archive = 0) {
        $uid = 0;
        if ($username) {
            $uid = DB::result_first('SELECT uid FROM %t WHERE username=%s', [$this->_table, $username]);
        }
        return $uid;
    }

    public function fetch_all_uid_by_username($usernames, $fetch_archive = 1) {
        $uids = [];
        if ($usernames) {
            foreach ($this->fetch_all_by_username($usernames, $fetch_archive) as $username => $value) {
                $uids[$username] = $value['uid'];
            }
        }
        return $uids;
    }

    public function fetch_all_by_adminid($adminids, $fetch_archive = 1) {
        $users = [];
        $adminids = dintval((array)$adminids, true);
        if ($adminids) {
            $users = DB::fetch_all('SELECT * FROM %t WHERE adminid IN (%n) ORDER BY adminid, uid', [$this->_table, (array)$adminids], $this->_pk);
        }
        return $users;
    }

    public function fetch_all_username_by_uid($uids) {
        $users = [];
        if (($uids = dintval($uids, true))) {
            foreach ($this->fetch_all($uids) as $uid => $value) {
                $users[$uid] = $value['username'];
            }
        }
        return $users;
    }

    public function count_by_groupid($groupid) {
        return $groupid ? DB::result_first('SELECT COUNT(*) FROM %t WHERE ' . DB::field('groupid', $groupid), [$this->_table]) : 0;
    }

    public function fetch_all_by_groupid($groupid, $start = 0, $limit = 0) {
        $users = [];
        if (($groupid = dintval($groupid, true))) {
            $users = DB::fetch_all('SELECT * FROM ' . DB::table($this->_table) . ' WHERE ' . DB::field('groupid', $groupid) . ' ' . DB::limit($start, $limit), null, 'uid');
        }
        return $users;
    }

    public function fetch_all_groupid() {
        return DB::fetch_all('SELECT DISTINCT(groupid) FROM ' . DB::table($this->_table), null, 'groupid');
    }

    public function fetch_all_by_allowadmincp($val, $glue = '=') {
        return DB::fetch_all('SELECT * FROM ' . DB::table($this->_table) . ' WHERE ' . DB::field('allowadmincp', intval($val), $glue), NULL, 'uid');
    }

    public function update_admincp_manage($uids) {
        if (($uids = dintval($uids, true))) {
            $data = DB::query('UPDATE ' . DB::table($this->_table) . ' SET allowadmincp=allowadmincp | 1 WHERE uid IN (' . dimplode($uids) . ')');
            $this->reset_cache($uids);
            return $data;
        }
        return false;
    }

    public function clean_admincp_manage($uids) {
        if (($uids = dintval($uids, true))) {
            $data = DB::query('UPDATE ' . DB::table($this->_table) . ' SET allowadmincp=allowadmincp & 0xFE WHERE uid IN (' . dimplode($uids) . ')');
            $this->reset_cache($uids);
            return $data;
        }
        return false;
    }

    public function chk_email_by_uid($email, $uid) {
        if (parent::fetch_all("select uid from %t where email = %s and uid != %d", [$this->_table, $email, $uid])) {
            return true;
        }
        return false;
    }

    public function fetch_by_email($email, $fetch_archive = 0) {
        $user = [];
        if ($email) {
            $user = DB::fetch_first('SELECT * FROM %t WHERE email=%s', [$this->_table, $email]);
        }
        return $user;
    }

    public function fetch_by_username($username, $fetch_archive = 0) {
        $user = [];
        if ($username) {
            $user = DB::fetch_first('SELECT * FROM %t WHERE username=%s', [$this->_table, $username]);
        }
        return $user;
    }

    public function fetch_by_nickname($username, $fetch_archive = 0) {
        $user = [];
        if ($username) {
            $user = DB::fetch_first('SELECT * FROM %t WHERE nickname=%s', [$this->_table, $username]);
        }
        return $user;
    }

    public function fetch_by_phone($username, $fetch_archive = 0) {
        $user = [];
        if ($username) {
            $user = DB::fetch_first('SELECT * FROM %t WHERE phone=%s', [$this->_table, $username]);
        }
        return $user;
    }

    public function fetch_by_weixinid($username, $fetch_archive = 0) {
        $user = [];
        if ($username) {
            $user = DB::fetch_first('SELECT * FROM %t WHERE weixinid=%s', [$this->_table, $username]);
        }
        return $user;
    }

    public function fetch_by_wechat_userid($username, $fetch_archive = 0) {
        $user = [];
        if ($username) {
            $user = DB::fetch_first('SELECT * FROM %t WHERE wechat_userid=%s', [$this->_table, $username]);
        }
        return $user;
    }

    public function fetch_by_uid($uid, $fetch_archive = 0) {
        $user = [];
        if ($uid) {
            $user = DB::fetch_first('SELECT * FROM %t WHERE uid=%d', [$this->_table, $uid]);
        }
        return $user;
    }

    public function fetch_by_username_uid($uid, $fetch_archive = 0) {
        $user = DB::fetch_first('SELECT username FROM %t WHERE uid=%d', [$this->_table, $uid]);
        return $user['username'];
    }

    public function fetch_all_by_email($emails, $fetch_archive = 1) {
        $users = [];
        if (!empty($emails)) {
            $users = DB::fetch_all('SELECT * FROM %t WHERE %i', [$this->_table, DB::field('email', $emails)], 'email');
        }
        return $users;
    }

    public function count_by_email($email, $fetch_archive = 0) {
        $count = 0;
        if ($email) {
            $count = DB::result_first('SELECT COUNT(*) FROM %t WHERE email=%s', [$this->_table, $email]);
        }
        return $count;
    }

    public function fetch_all_by_like_username($username, $start = 0, $limit = 0) {
        $data = [];
        if ($username) {
            $data = DB::fetch_all('SELECT * FROM %t WHERE username LIKE %s' . DB::limit($start, $limit), [$this->_table, stripsearchkey($username) . '%'], 'uid');
        }
        return $data;
    }

    public function count_by_like_username($username) {
        return !empty($username) ? DB::result_first('SELECT COUNT(*) FROM %t WHERE username LIKE %s', [$this->_table, stripsearchkey($username) . '%']) : 0;
    }


    public function fetch_runtime() {
        return DB::result_first("SELECT (MAX(regdate)-MIN(regdate))/86400 AS runtime FROM " . DB::table($this->_table));
    }

    public function count_admins() {
        return DB::result_first("SELECT COUNT(*) FROM " . DB::table($this->_table) . " WHERE adminid<>'0' AND adminid<>'-1'");
    }

    public function count_by_regdate($timestamp) {
        return DB::result_first('SELECT COUNT(*) FROM %t WHERE regdate>%d', [$this->_table, $timestamp]);
    }

    //根据用户组id，查询用户id
    public function fetch_uid_by_groupid($groupid) {
        $groupid = intval($groupid);
        return DB::fetch_all("select uid from %t where groupid = %d", [$this->_table, $groupid]);
    }

    public function fetch_all_stat_memberlist($username, $orderby = '', $sort = '', $start = 0, $limit = 0) {
        $orderby = in_array($orderby, ['uid', 'credits', 'regdate', 'gender', 'username', 'posts', 'lastvisit'], true) ? $orderby : 'uid';
        $sql = '';

        $sql = !empty($username) ? " WHERE username LIKE '" . addslashes(stripsearchkey($username)) . "%'" : '';

        $memberlist = [];
        $query = DB::query("SELECT m.uid, m.username, mp.gender, m.email, m.regdate, ms.lastvisit, mc.posts, m.credits
			FROM " . DB::table($this->_table) . " m
			LEFT JOIN " . DB::table('user_profile') . " mp ON mp.uid=m.uid
			LEFT JOIN " . DB::table('user_status') . " ms ON ms.uid=m.uid
			$sql ORDER BY " . DB::order($orderby, $sort) . DB::limit($start, $limit));
        while ($member = DB::fetch($query)) {
            $member['usernameenc'] = rawurlencode($member['username']);
            $member['regdate'] = dgmdate($member['regdate']);
            $member['lastvisit'] = dgmdate($member['lastvisit']);
            $memberlist[$member['uid']] = $member;
        }
        return $memberlist;
    }

    //添加用户
    public function insert($arr, $return_insert_id = false, $replace = false, $silent = false) {
        if ($uid = parent::insert($arr, 1)) {
            $log = '添加用户(UID:' . $uid . ')：';
            $arr['password'] = '******';
            $log .= implodearray($arr);
            writelog('updatelog', $log);
        }
        return $uid;
    }

    public function insert_user($userarr, $groupid = 9, $profilearr = []) {
        global $_G;
        if (empty($userarr)) {
            return false;
        }
        $ip = $_G['clientip'];
        $salt = substr(uniqid(rand()), -6);
        $setarr = [
            'username' => addslashes($userarr['username']),
            'email' => $userarr['email'],
            'salt' => $salt,
            'password' => md5(md5($userarr['password']) . $salt),
            'regdate' => TIMESTAMP,
            'regip' => $ip,
            'groupid' => $groupid,
            'phone' => $userarr['phone'],
            'phonestatus' => $userarr['phonestatus']
        ];
        $uid = self::insert($setarr, 1);
        if ($uid) {
            $status = [
                'uid' => $uid,
                'regip' => (string)$ip,
                'lastip' => (string)$ip,
                'lastvisit' => TIMESTAMP,
                'lastactivity' => TIMESTAMP,
                'lastsendmail' => 0
            ];
            C::t('user_status')->insert($status, 1);
            if (!empty($profilearr)) {
                C::t('user_profile')->update($uid, $profilearr);
            }
            $setarr['uid'] = $uid;
            return $setarr;
        } else {
            return false;
        }
    }

    public function delete($val, $unbuffered = false, $fetch_archive = 0) {
        $ret = false;

        if (($val = dintval($val, true))) {
            foreach ((array)$val as $key => $uid) {
                if ($uid == 1) unset($val[$key]); //暂时限制uid=1的用户不允许删除
            }
            $ret = parent::delete($val, $unbuffered, $fetch_archive);
            if ($this->_allowmem) {
                $data = ($data = memory('get', 'deleteuids')) === false ? [] : $data;
                foreach ((array)$val as $uid) {
                    $data[$uid] = $uid;
                }
                memory('set', 'deleteuids', $data, 86400 * 2);
            }
            if ($ret) {
                $log = '删除了用户UID：' . $uid;
                writelog('deletelog', $log);
                //删除用户字段
                C::t('user_field')->delete($uid);
                //删除用户资料
                C::t('user_profile')->delete($uid);
                //删除用户状态
                C::t('user_status')->delete($uid);
                //删除用户设置
                C::t('user_setting')->delete_by_uid($uid);
                //删除用户组织关系(含organization_admin表)
                C::t('organization_user')->delete_by_uid($uid, 0);
                //删除用户认证信息
                C::t('user_verify')->delete($uid);
                C::t('user_verify_info')->delete_by_uid($uid);
                
                //删除用户文件
                if ($homefid = DB::result_first("select fid from %t where uid=%d and flag='home' ", ['folder', $uid])) {
                    C::t('folder')->delete_by_fid($homefid, true);
                }
                //删除用户邮件代发列表
                C::t('mailcron')->delete_by_touid($uid);
                //删除用户通知
                C::t('notification')->delete_by_uid($uid);
                //删除用户
                C::t('onlinetime')->delete($uid);
                Hook::listen('syntoline_user', $uid, 'del');//删除对应到三方用户表
            }
        }
        return $ret;
    }

    public function max_uid() {
        return DB::result_first('SELECT MAX(uid) FROM %t', [$this->_table]);
    }

    public function range_by_uid($from, $limit) {
        return DB::fetch_all('SELECT * FROM %t WHERE uid >= %d ORDER BY uid LIMIT %d', [$this->_table, $from, $limit], $this->_pk);
    }

    public function update_groupid_by_groupid($source, $target) {
        return DB::query('UPDATE %t SET groupid=%d WHERE adminid <= 0 AND groupid=%d', [$this->_table, $target, $source]);
    }

    public function fetch_all_user() {
        return DB::fetch_all("select * from %t", [$this->_table]);
    }

    //获取用户独享空间配置值,若未分配，则获取用户已使用空间
    public function get_allotspace() {
        global $_G;
        $setting = $_G['setting'];
        $userallotspace = 0;
        $uids = [];
        foreach (DB::fetch_all("select uid from %t", [$this->_table]) as $v) {
            $uids[] = $v['uid'];
        }
        foreach (DB::fetch_all("select userspace,usesize from %t where uid in(%n)", ['user_field', $uids]) as $val) {
            if ($val['userspace'] > 0) {
                $userallotspace += $val['userspace'] * 1024 * 1024;
            } else {
                $userallotspace += $val['usesize'];
            }
        }
        return $userallotspace;
    }

    //获取用户信息包含头像信息
    public function fetch_user_avatar_by_uids($uids) {
        $uids = array_unique((array)$uids);
        if (empty($uids)) {
            return [];
        }
        
        return DB::fetch_all("SELECT avatarstatus, uid, username, headerColor FROM %t WHERE uid IN (%n)", ['user', $uids], 'uid');
    }

    public function fetch_userinfo_detail_by_uid($uid) {
        $uid = intval($uid);
        $users = DB::fetch_first("select u.uid,u.phone,u.email,ug.* from %t u left join %t ug  on u.groupid=ug.groupid where uid = %d", ['user', 'usergroup', $uid]);
        foreach (DB::fetch_all("select * from %t where uid = %d", ['user_profile', $uid]) as $v) {
            if (!$v['privacy']) {
                $users['information'][$v['fieldid']] = $v['value'];
            }
        }
        return $users;
    }

    public function fetch_all_user_data() {
        return DB::fetch_all("select * from %t where 1", [$this->_table]);
    }
}
