<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */
if (!defined('IN_DZZ')) {
    exit('Access Denied');
}

class table_admincp_session extends dzz_table {
    public function __construct() {

        $this->_table = 'admincp_session';
        $this->_pk = 'uid';

        parent::__construct();
    }

    public function fetch($uid, $panel = false) {
        $sql = 'SELECT * FROM %t WHERE uid=%d AND panel=%d';
        return DB::fetch_first($sql, [$this->_table, $uid, $panel]);
    }

    public function fetch_all_by_panel($panel) {
        return DB::fetch_all('SELECT * FROM %t WHERE panel=%d', [$this->_table, $panel], 'uid');
    }

    public function delete($uid, $panel = false, $ttl = 3600) {


        $sql = 'DELETE FROM %t WHERE (uid=%d AND panel=%d) OR dateline<%d';
        DB::query($sql, [$this->_table, $uid, $panel, TIMESTAMP - intval($ttl)]);

    }

    public function update($uid, $panel, $data = false, $low_priority = false) {
        if (!empty($data) && is_array($data)) {
            DB::update($this->_table, $data, ['uid' => $uid, 'panel' => $panel]);
        }
    }

}


