<?php
/* @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */
if (!defined('IN_DZZ')) {
    exit('Access Denied');
}
include_once DZZ_ROOT . './core/core_version.php';
require_once libfile('function/admin');
include_once libfile('function/cache');
$map = [];
$today = dgmdate(TIMESTAMP, 'Ymd');
$map["available"] = 1;
$applist = DB::fetch_all("select * from %t where `available`>0", ['app_market']);

$return = ["sum" => 0];
$num = 0;
if ($applist) {
    $dzz_upgrade = new dzz_upgrade_app();
    $appinfo = [];
    $appinfo["mysqlversion"] = helper_dbtool::dbversion();
    $appinfo["phpversion"] = PHP_VERSION;
    $appinfo["dzzversion"] = CORE_VERSION;
    foreach ($applist as $k => $v) {
        if (empty($v['app_path'])) $v['app_path'] = 'dzz';
        $savedata = [];
        if ($v["mid"] > 0) {//云端检测
            $info = array_merge($v, $appinfo);
            $response = $dzz_upgrade->check_upgrade_byversion($info);
            $map = [
                "upgrade_version" => '',
                "check_upgrade_time" => ''
            ];
            if ($response && $response["status"] == 1) {
                $map = [
                    "upgrade_version" => serialize($response["data"]),
                    "check_upgrade_time" => dgmdate(TIMESTAMP, 'Ymd')
                ];

            }
            $re = C::t('app_market')->update($v['appid'], $map);
            $num++;
        } else {//本地检测
            $file = DZZ_ROOT . './' . $v['app_path'] . '/' . $v['identifier'] . '/dzz_app_' . $v['identifier'] . '.xml';
            if (file_exists($file)) {
                $importtxt = @implode('', file($file));
                $apparray = getimportdata('Dzz! app', 0, 0, $importtxt);
                if (version_compare($apparray["app"]["version"], $v["version"]) > 0) {
                    $num++;
                    $savedata = [
                        "upgrade_version" => serialize($apparray["app"]),
                        "check_upgrade_time" => dgmdate(TIMESTAMP, 'Ymd')
                    ];
                } else {
                    $savedata = [
                        "upgrade_version" => '',
                        "check_upgrade_time" => dgmdate(TIMESTAMP, 'Ymd')
                    ];
                }
                $re = C::t('app_market')->update($v['appid'], $savedata);
            }
        }
    }
}
$return["sum"] = $num;
exit(json_encode($return));
