# Security Policy

## Supported Versions

We actively maintain and provide security updates for the following versions of DzzOffice:

| Version | Supported          |
| ------- | ------------------ |
| Latest stable release | ✅ |
| Previous stable release | ✅ (critical security fixes only) |
| Older versions | ❌ |

> Note: It's strongly recommended to keep your DzzOffice installation updated to the latest stable version to ensure you receive the latest security patches.

## Reporting a Vulnerability

If you discover a security vulnerability in DzzOffice, please report it promptly using the following process:

1. Send an email to **zyx@dzz.cc** with the subject line "DzzOffice Security Vulnerability Report"
2. Include the following details in your report:
   - A detailed description of the vulnerability
   - Steps to reproduce the issue
   - Potential impact of the vulnerability
   - Any suggested mitigation or fix (if available)
   - Your contact information for follow-up questions

We kindly request that you:
- Do not disclose the vulnerability publicly until we have had a chance to address it
- Give us a reasonable amount of time to respond and fix the issue before any public disclosure
- Avoid exploiting the vulnerability in any way that could harm users or their data

## Response Timeline

- We aim to acknowledge receipt of your vulnerability report within 48 hours
- We will provide an initial assessment of the vulnerability and a timeline for a fix within 7 days
- For critical vulnerabilities, we will prioritize the fix and may release an emergency update
- We will keep you informed of our progress throughout the resolution process
- After the vulnerability is fixed, we will credit you in the release notes (with your permission)

## Security Audit

We conduct regular security audits of the DzzOffice codebase and welcome contributions from the security community to help identify and address potential vulnerabilities.

## Contact

For any security-related questions or concerns not related to a specific vulnerability, please contact us at zyx@dzz.cc.
