## 附录五：如何调试 Docker

### 开启 Debug 模式

在 dockerd 配置文件 daemon.json (默认位于 /etc/docker/) 中添加

```json
{
  "debug": true
}
```

重启守护进程。

```bash
$ sudo kill -SIGHUP $(pidof dockerd)
```

此时 dockerd 会在日志中输入更多信息供分析。

### 检查内核日志

```bash
$ sudo dmesg |grep dockerd
$ sudo dmesg |grep runc
```

### Docker 不响应时处理

可以杀死 dockerd 进程查看其堆栈调用情况。

```bash
$ sudo kill -SIGUSR1 $(pidof dockerd)
```

### 重置 Docker 本地数据

*注意，本操作会移除所有的 Docker 本地数据，包括镜像和容器等。*

更安全的替代方式是优先使用以下命令进行清理：

```bash
$ docker system prune
```

如果你只是想 “恢复出厂设置”，在 Docker Desktop 里也提供了相应入口。

```bash
$ sudo rm -rf /var/lib/docker
```

### 常见故障排查

#### 容器启动失败

如果容器启动后立即退出，可以使用 `docker logs` 查看原因。

* **Exit Code 1**：应用程序错误。通常是配置错误或依赖缺失。
* **Exit Code 137**：OOM (Out Of Memory)。容器内存不足被内核杀掉。
  * 检查宿主机内存。
  * 调整容器内存限制 (`--memory`)。
* **Exit Code 127**：命令未找到。可能是 `ENTRYPOINT` 或 `CMD` 指定的命令不存在。

#### 网络连接问题

##### 容器内部无法联网

1. 检查 Docker DNS 配置 (`/etc/docker/daemon.json`)。
2. 检查宿主机防火墙 (iptables/firewalld) 是否拦截了转发。
3. 容器内测试：`ping 8.8.8.8` (测试连通性)，`nslookup google.com` (测试 DNS)。

##### 端口映射不通

1. 检查容器端口是否正确监听：`netstat -tunlp` (宿主机) 或 `docker exec <container> netstat -tunlp`。
2. 确认应用监听地址是 `0.0.0.0` 而不是 `127.0.0.1`。
   * 如果应用监听在 `127.0.0.1`，只有容器内部能访问，映射到宿主机外部也无法被外部请求访问。

#### 镜像拉取失败

* **connection refused**：检查网络或代理设置。
* **image not found**：检查镜像名称和 Tag 拼写。
* **EOF / timeout**：网络不稳定，尝试配置镜像加速器。
