# 本章小结

本章从两个维度介绍了容器可观测性：

* **指标监控**：以 Prometheus + Grafana 为主，完成指标采集、存储与可视化。
* **日志管理**：以 EFK/ELK 为例，完成容器日志的集中采集、检索与分析。

生产环境中，建议将“可观测性”当成一个完整闭环：**采集 -> 存储 -> 展示 -> 告警 -> 排错 -> 容量治理**。

## 19.3 Docker 日志驱动

Docker 提供了多种日志驱动 (Log Driver)，用于将容器标准输出的日志转发到不同后端。

常见的日志驱动包括：

* `json-file`：默认驱动，将日志以 JSON 格式写入本地文件。
* `syslog`：将日志转发到 syslog 服务器。
* `journald`：将日志写入 systemd journal。
* `fluentd`：将日志转发到 fluentd 收集器。
* `gelf`：支持 GELF 协议的日志后端 (如 Graylog)。
* `awslogs`：发送到 Amazon CloudWatch Logs。

生产建议：无论采用哪种驱动，都要明确日志的保留周期、容量上限与传输可靠性，避免“日志把磁盘写满”或“链路抖动导致丢日志”。

## 19.4 日志平台选型对比与注意事项

日志平台通常由“采集/处理/存储/查询展示”几部分组成。常见选型包括：

* **EFK/ELK**：Elasticsearch + Fluentd/Logstash + Kibana，适合全文检索与结构化查询。
* **Loki + Grafana**：更偏“日志像指标一样存储”的思路，部署与成本可能更友好，但查询能力与使用习惯不同。

选型时建议关注：

* **写入压力与背压**：当存储端变慢时，采集端是否会缓冲、落盘、重试，是否会影响业务。
* **容量治理**：是否具备按天/按大小滚动、保留策略、生命周期管理 (ILM) 等能力。
* **安全与合规**：鉴权、TLS、审计、敏感字段脱敏。
* **可运维性**：升级策略、备份恢复、告警指标是否齐全。

## 19.5 上线前检查清单

你可以用下面的清单快速检查“是否具备最小生产可用性”：

* Prometheus 数据目录已持久化，并设置了合理的保留周期。
* Prometheus Targets 全部为 `UP`，并且关键查询 (CPU/内存/容器指标) 有数据。
* Grafana 已导入面板并能定位到具体实例/容器；默认账号密码已修改。
* 至少有一条关键告警已打通 Alertmanager 的接收链路，并验证告警能被正确发送与抑制。
* Elasticsearch 数据目录已持久化，并有明确的日志保留周期与容量上限策略。
* Kibana 能查询到最新日志；当 UI 异常时能用 Elasticsearch API 验证入库。
* 可观测性组件未直接暴露到公网，访问已加鉴权或置于内网。
