## 16.5 多云部署策略

企业在选择容器云平台时，通常会在 AWS EKS，Azure AKS，Google GKE 以及国内的阿里云 ACK，腾讯云 TKE 之间进行权衡。

### 16.5.1 三大公有云 Kubernetes 服务对比

| 特性 | Google GKE | AWS EKS | Azure AKS |
| :--- | :--- | :--- | :--- |
| **版本更新** | 最快，通常是 K8s 新特性的首发地 | 相对保守，注重稳定性 | 跟随社区，更新速度适中 |
| **控制平面管理** | 全托管，自动升级，免费 (部分区域)| 托管，每小时收费 | 全托管，控制平面免费 |
| **节点管理** | GKE Autopilot 模式完全托管节点 | Managed Node Groups 简化管理 | Virtual Machine Scale Sets |
| **网络模型** | VPC-native, 性能优秀 | AWS VPC CNI, Pod 直接获取 VPC IP | Azure CNI (消耗 IP 多) 或 Kubenet |
| **集成度** | 与 GCP 数据分析、AI 服务集成紧密 | 与 AWS IAM, ALB, CloudWatch 集成深度高 | 与 Active Directory, Azure DevOps 集成好 |

### 16.5.2 多云部署策略

随着企业业务的扩展，单一云平台可能无法满足所有需求，多云部署成为趋势。

#### 1. 跨云灾备 (Active-Passive)

主要业务运行在一个云 (如 AWS)，数据实时复制到另一个云 (如阿里云)。当主云发生故障时，流量切换到备云。

* **优点**：架构相对简单，数据一致性好控制。
* **缺点**：资源闲置浪费，切换可能有 RTO。

#### 2. 多活部署 (Active-Active)

业务同时在多个云上运行，通过全局流量管理 (DNS/GSLB) 分发流量。

* **优点**：高可用，就近接入提升用户体验。
* **缺点**：数据同步复杂，跨云网络延迟问题。

#### 3. 混合云

核心数据和敏感业务保留在私有云 (IDC)，弹性业务或前端业务部署在公有云。

* **工具**：Google Anthos，AWS Outposts，Azure Arc 都是为了解决混合云统一管理而生。

### 16.5.3 建议

* **技术选型**：尽量使用标准的 Kubernetes API，避免过度依赖特定云厂商的 CRD 或专有服务，以保持应用的可移植性。
* **IaC 管理**：使用 Terraform 或 Pulumi 等工具统一管理多云基础设施。
