## 11.2 安装与卸载

`Compose` 是 Docker 官方的开源项目，负责实现对 Docker 容器集群的快速编排。

从 `v2` 版本开始，`Compose` 作为 `docker` 的子命令存在，例如 `docker compose up`。

`Compose` 支持 Linux、macOS、Windows 10 三大平台。

`Docker Desktop for Mac/Windows` 自带 `docker compose` 命令。

Linux 系统请使用以下介绍的方法安装。

### 11.2.1 Linux

在 Linux 上，你可以通过下载 Docker Compose CLI 插件 (二进制文件名为 `docker-compose`) 来安装。

从[官方 GitHub Release](https://github.com/docker/compose/releases) 处直接下载编译好的二进制文件即可。

> **提示**：版本更新较快，请访问上述链接获取最新版本号，替换下方命令中的版本号。

例如，在 Linux 64 位系统上直接下载对应的二进制包 (以 v5.0.2 为例)。

```bash
$ DOCKER_CONFIG=${DOCKER_CONFIG:-$HOME/.docker}
$ mkdir -p $DOCKER_CONFIG/cli-plugins
$ curl -SL https://github.com/docker/compose/releases/download/v5.0.2/docker-compose-linux-x86_64 -o $DOCKER_CONFIG/cli-plugins/docker-compose
```

之后，执行

```bash
$ chmod +x $DOCKER_CONFIG/cli-plugins/docker-compose
```

### 11.2.2 测试安装

```bash
$ docker compose version
Docker Compose version v5.0.2
```

### 11.2.3 bash 补全命令

```bash
$ curl -L https://raw.githubusercontent.com/docker/compose/v5.0.2/contrib/completion/bash/docker-compose | sudo tee /etc/bash_completion.d/docker-compose > /dev/null
```

### 11.2.4 卸载

如果是二进制包方式安装的，删除二进制文件即可。

```bash
$ rm $DOCKER_CONFIG/cli-plugins/docker-compose
```
