## 11.1 简介

`Compose` 项目是 Docker 官方的开源项目，负责实现对 Docker 容器集群的快速编排。从功能上看，跟 `OpenStack` 中的 `Heat` 十分类似。

其代码目前在 [https://github.com/docker/compose](https://github.com/docker/compose) 上开源。

`Compose` 定位是 “定义和运行多个 Docker 容器的应用 (Defining and running multi-container Docker applications)”，其前身是开源项目 Fig。

通过第一部分中的介绍，我们知道使用一个 `Dockerfile` 模板文件，可以让用户很方便的定义一个单独的应用容器。然而，在日常工作中，经常会碰到需要多个容器相互配合来完成某项任务的情况。例如要实现一个 Web 项目，除了 Web 服务容器本身，往往还需要再加上后端的数据库服务容器，甚至还包括负载均衡容器等。

`Compose` 恰好满足了这样的需求。它允许用户通过一个单独的 `compose.yaml` (历史默认名也常见为 `docker-compose.yml`) 模板文件 (YAML 格式) 来定义一组相关联的应用容器为一个项目 (project)。

### 11.1.1 概述

### 11.1.2 模板文件规范

Compose 模板文件采用 YAML 格式，扩展名为 `.yml` 或 `.yaml`。

> **注意**：自 Compose V2 起，`version` 字段已不再强制要求。在 Docker Compose v5 中，规范已完全不需要顶层 `version` 字段。为了保持最佳兼容性，建议不在新文件中使用该字段。

Docker Compose 默认使用 `compose.yaml`，也兼容 `compose.yml`、`docker-compose.yaml`、`docker-compose.yml` 等文件名。

`Compose` 中有两个重要的概念：

* 服务 (`service`)：一个应用的容器，实际上可以包括若干运行相同镜像的容器实例。

* 项目 (`project`)：由一组关联的应用容器组成的一个完整业务单元，在 Compose 文件中定义。

`Compose` 的默认管理对象是项目，通过子命令对项目中的一组容器进行便捷地生命周期管理。

`Compose` 项目早期由 Python 编写，称为 Docker Compose V1。

现在的 Docker Compose V2 是一个 Go 语言编写的 Docker CLI 插件，已经集成到 Docker Desktop 和 Docker Engine 中，直接通过 `docker compose` 命令使用。它提供了更快的性能和更好的集成体验。

只要所操作的平台支持 Docker API，就可以在其上利用 `Compose` 来进行编排管理。
