/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.awt.font;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.FontStyle;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.Typeface_jvmKt;
import org.jetbrains.skiko.awt.font.FontFamily;
import org.jetbrains.skiko.awt.font.FontFamilyKey;
import org.jetbrains.skiko.awt.font.InMemoryTypefaceCache;
import org.jetbrains.skiko.awt.font.TypefaceCache;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001b\b\u0002\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J!\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001f\u001a\u00020\nH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\nH\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lorg/jetbrains/skiko/awt/font/InMemoryTypefaceCache;", "Lorg/jetbrains/skiko/awt/font/TypefaceCache;", "()V", "fontFamiliesCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/skiko/awt/font/FontFamilyKey;", "Lorg/jetbrains/skiko/awt/font/FontFamily;", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "familyNamesCache", "", "", "size", "", "getSize", "()I", "addFile", "", "file", "Ljava/io/File;", "addResource", "resource", "loader", "Ljava/lang/ClassLoader;", "(Ljava/lang/String;Ljava/lang/ClassLoader;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addTypeface", "typeface", "Lorg/jetbrains/skia/Typeface;", "clear", "familyNames", "", "getFontFamilyOrNull", "familyName", "getTypefaceOrNull", "fontStyle", "Lorg/jetbrains/skia/FontStyle;", "removeFontFamily", "skiko"})
@SourceDebugExtension(value={"SMAP\nTypefaceCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypefaceCache.kt\norg/jetbrains/skiko/awt/font/InMemoryTypefaceCache\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n73#2,2:173\n1#3:175\n*S KotlinDebug\n*F\n+ 1 TypefaceCache.kt\norg/jetbrains/skiko/awt/font/InMemoryTypefaceCache\n*L\n146#1:173,2\n146#1:175\n*E\n"})
final class InMemoryTypefaceCache
implements TypefaceCache {
    @NotNull
    private final ConcurrentHashMap<FontFamilyKey, FontFamily> fontFamiliesCache;
    @NotNull
    private final Set<String> familyNamesCache;

    private InMemoryTypefaceCache(ConcurrentHashMap<FontFamilyKey, FontFamily> fontFamiliesCache) {
        this.fontFamiliesCache = fontFamiliesCache;
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet()");
        this.familyNamesCache = keySetView;
    }

    public InMemoryTypefaceCache() {
        this(new ConcurrentHashMap<FontFamilyKey, FontFamily>());
    }

    @Override
    public int getSize() {
        return this.fontFamiliesCache.size();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object addResource(@NotNull String var1_1, @NotNull ClassLoader var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof addResource.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ InMemoryTypefaceCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.addResource(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = loader.getResourceAsStream((String)resource);
                if (v0 == null) {
                    v0 = ClassLoader.getSystemResourceAsStream((String)resource);
                }
                if ((var5_7 = v0) == null) {
                    throw new IllegalStateException("Unable to access the resources from the provided classloader".toString());
                }
                res = var5_7;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(res, null){
                    int label;
                    final /* synthetic */ InputStream $res;
                    {
                        this.$res = $res;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return this.$res.readAllBytes();
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super byte[]> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                this = (InMemoryTypefaceCache)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                resourceBytes = (byte[])v1;
                Intrinsics.checkNotNullExpressionValue((Object)resourceBytes, (String)"resourceBytes");
                typeface = Typeface.Companion.makeFromData$default(Typeface.Companion, Data.Companion.makeFromBytes$default(Data.Companion, resourceBytes, 0, 0, 6, null), 0, 2, null);
                this.addTypeface(typeface);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void addFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
        Typeface typeface = Typeface_jvmKt.makeFromFile$default(Typeface.Companion, string, 0, 2, null);
        this.addTypeface(typeface);
    }

    @Override
    public void addTypeface(@NotNull Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        FontFamilyKey key = new FontFamilyKey(typeface.getFamilyName());
        Typeface[] typefaceArray = new Typeface[]{typeface};
        FontFamily fontFamily = FontFamily.Companion.fromTypefaces(typeface.getFamilyName(), FontFamily.FontFamilySource.Custom, typefaceArray);
        ConcurrentMap $this$getOrPut$iv = this.fontFamiliesCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key);
        if (object == null) {
            boolean bl = false;
            FontFamily default$iv = fontFamily;
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        ((Collection)this.familyNamesCache).add(typeface.getFamilyName());
    }

    @Override
    public void removeFontFamily(@NotNull String familyName) {
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        ((Map)this.fontFamiliesCache).remove(new FontFamilyKey(familyName));
        ((Collection)this.familyNamesCache).remove(familyName);
    }

    @Override
    public void clear() {
        this.fontFamiliesCache.clear();
        this.familyNamesCache.clear();
    }

    @Override
    @Nullable
    public Typeface getTypefaceOrNull(@NotNull String familyName, @NotNull FontStyle fontStyle) {
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        Intrinsics.checkNotNullParameter((Object)fontStyle, (String)"fontStyle");
        FontFamily fontFamily = this.getFontFamilyOrNull(familyName);
        if (fontFamily == null) {
            return null;
        }
        FontFamily family = fontFamily;
        return (Typeface)family.get((Object)fontStyle);
    }

    @Override
    @Nullable
    public FontFamily getFontFamilyOrNull(@NotNull String familyName) {
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        return this.fontFamiliesCache.get(new FontFamilyKey(familyName));
    }

    @Override
    @NotNull
    public Set<String> familyNames() {
        return this.familyNamesCache;
    }

    @Override
    public boolean isEmpty() {
        return TypefaceCache.DefaultImpls.isEmpty(this);
    }
}

