/*
 * Decompiled with CFR 0.152.
 */
package util;

import androidx.compose.runtime.internal.StabilityInferred;
import io.File;
import io.Paths;
import io.PathsKt;
import io.github.aakira.napier.Antilog;
import io.github.aakira.napier.DebugAntilog;
import io.github.aakira.napier.LogLevel;
import io.github.aakira.napier.Napier;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import util.ExceptionKt;
import util.FileAntilog;
import util.LocaleKt;
import util.Log;
import util.LogKt;
import util.Platform;
import util.PlatformKt;
import util.RuntimeKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lutil/Log;", "", "()V", "logFile", "Lio/File;", "getLogFile", "()Lio/File;", "napierDisabled", "", "getNapierDisabled", "()Z", "d", "", "message", "", "e", "throwable", "", "i", "initialize", "w", "shared"})
@StabilityInferred(parameters=0)
public final class Log {
    @NotNull
    public static final Log INSTANCE = new Log();
    public static final int $stable;

    private Log() {
    }

    private final boolean getNapierDisabled() {
        return PlatformKt.isDesktop();
    }

    private final File getLogFile() {
        return PathsKt.getLogsDirectory(Paths.INSTANCE).resolve("error.log");
    }

    public final void initialize() {
        boolean success;
        if (!PathsKt.getLogsDirectory(Paths.INSTANCE).exists() && !(success = PathsKt.getLogsDirectory(Paths.INSTANCE).mkdirs())) {
            System.out.println((Object)"Failed to create logs directory");
        }
        if (!this.getNapierDisabled()) {
            Napier.INSTANCE.base((Antilog)new DebugAntilog(null, 1, null));
            Napier.INSTANCE.base((Antilog)new FileAntilog(this.getLogFile(), LogLevel.ERROR));
        }
        ExceptionKt.setupUncaughtExceptionHandler((Function1<? super Throwable, Unit>)((Function1)initialize.1.INSTANCE));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"target", (Object)((Object)Platform.INSTANCE.getTarget())), TuplesKt.to((Object)"os", (Object)Platform.INSTANCE.getOs()), TuplesKt.to((Object)"appVersion", (Object)RuntimeKt.getAppVersion()), TuplesKt.to((Object)"debug", (Object)RuntimeKt.isDebug()), TuplesKt.to((Object)"locale", (Object)LocaleKt.getLocale())};
        Map launchInfo = MapsKt.mapOf((Pair[])pairArray);
        this.i("Launched via " + CollectionsKt.joinToString$default((Iterable)launchInfo.entrySet(), (CharSequence)", ", null, null, (int)0, null, (Function1)initialize.2.INSTANCE, (int)30, null));
    }

    public final void d(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.getNapierDisabled()) {
            LogKt.access$nativePerformLog(LogLevel.DEBUG, null, null, message);
        } else {
            Napier.d$default((Napier)Napier.INSTANCE, (String)message, null, null, (int)6, null);
        }
    }

    public final void i(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.getNapierDisabled()) {
            LogKt.access$nativePerformLog(LogLevel.INFO, null, null, message);
        } else {
            Napier.i$default((Napier)Napier.INSTANCE, (String)message, null, null, (int)6, null);
        }
    }

    public final void w(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.getNapierDisabled()) {
            LogKt.access$nativePerformLog(LogLevel.WARNING, null, null, message);
        } else {
            Napier.w$default((Napier)Napier.INSTANCE, (String)message, null, null, (int)6, null);
        }
    }

    public final void w(@NotNull String message, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (this.getNapierDisabled()) {
            LogKt.access$nativePerformLog(LogLevel.WARNING, null, throwable, message);
        } else {
            Napier.w$default((Napier)Napier.INSTANCE, (String)message, (Throwable)throwable, null, (int)4, null);
        }
    }

    public final void w(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (this.getNapierDisabled()) {
            LogKt.access$nativePerformLog(LogLevel.WARNING, null, throwable, null);
        } else {
            String string = throwable.getMessage();
            if (string == null) {
                string = "";
            }
            Napier.w$default((Napier)Napier.INSTANCE, (String)string, (Throwable)throwable, null, (int)4, null);
        }
    }

    public final void e(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.getNapierDisabled()) {
            LogKt.access$nativePerformLog(LogLevel.ERROR, null, null, message);
        } else {
            Napier.e$default((Napier)Napier.INSTANCE, (String)message, null, null, (int)6, null);
        }
    }

    public final void e(@NotNull String message, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (this.getNapierDisabled()) {
            LogKt.access$nativePerformLog(LogLevel.ERROR, null, throwable, message);
        } else {
            Napier.e$default((Napier)Napier.INSTANCE, (String)message, (Throwable)throwable, null, (int)4, null);
        }
    }

    public final void e(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (this.getNapierDisabled()) {
            LogKt.access$nativePerformLog(LogLevel.ERROR, null, throwable, null);
        } else {
            String string = throwable.getMessage();
            if (string == null) {
                string = "";
            }
            Napier.e$default((Napier)Napier.INSTANCE, (String)string, (Throwable)throwable, null, (int)4, null);
        }
    }
}

