/*
 * Decompiled with CFR 0.152.
 */
package ui.screen;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.snapshots.SnapshotStateList;
import audio.AudioPlayer;
import audio.AudioPlayerProvider;
import audio.AudioRecorder;
import audio.AudioRecorderProvider;
import audio.PostRecordingScheduler;
import audio.RecordingScheduler;
import cafe.adriel.voyager.core.model.ScreenModel;
import cafe.adriel.voyager.core.model.ScreenModelKt;
import exception.SessionRenameExistingException;
import exception.SessionRenameInvalidException;
import graph.WaveformPainter;
import io.File;
import io.FileInteractor;
import io.PermissionChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import model.AppPreference;
import model.GuideAudio;
import model.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import repository.AppPreferenceRepository;
import repository.SessionRepository;
import ui.common.AlertDialogController;
import ui.common.AlertDialogKt;
import ui.common.ErrorNotifier;
import ui.model.AppContext;
import ui.model.Sentence;
import ui.screen.SessionScreenModel;
import ui.string.Strings;
import ui.string.StringsKt;
import util.Log;
import util.SavedMutableState;
import util.SavedMutableStateKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00cf\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\"*\u0003@\\j\b\u0007\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0003\u0010\u0085\u0001J\u000f\u0010\u0086\u0001\u001a\u00020\u001aH\u0007\u00a2\u0006\u0003\u0010\u0085\u0001J\u0012\u0010\u0087\u0001\u001a\u00020\u001c2\u0007\u0010\u0088\u0001\u001a\u00020\u001aH\u0002J\u0011\u0010\u0089\u0001\u001a\u0004\u0018\u00010)H\u0002\u00a2\u0006\u0003\u0010\u008a\u0001J\u0011\u0010\u008b\u0001\u001a\u0004\u0018\u00010)H\u0002\u00a2\u0006\u0003\u0010\u008a\u0001J\u0012\u0010\u008c\u0001\u001a\u00020C2\u0007\u0010\u0088\u0001\u001a\u00020\u001aH\u0002J\u0007\u0010\u008d\u0001\u001a\u00020\u0013J\t\u0010\u008e\u0001\u001a\u00020\u0013H\u0002J\t\u0010\u008f\u0001\u001a\u00020\u0013H\u0016J\t\u0010\u0090\u0001\u001a\u00020\u0013H\u0002J\u0007\u0010\u0091\u0001\u001a\u00020\u0013J\u0011\u0010\u0092\u0001\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0093\u0001\u001a\u00020\u00132\u0007\u0010\u0094\u0001\u001a\u00020\u001aJ\t\u0010\u0095\u0001\u001a\u00020\u0013H\u0002J\t\u0010\u0096\u0001\u001a\u00020\u0013H\u0002J\t\u0010\u0097\u0001\u001a\u00020\u0013H\u0002J\u001b\u0010\u0098\u0001\u001a\u00020\u00132\u0007\u0010\u0099\u0001\u001a\u00020)2\t\b\u0002\u0010\u009a\u0001\u001a\u00020CJ\t\u0010\u009b\u0001\u001a\u00020\u0013H\u0002J\t\u0010\u009c\u0001\u001a\u00020\u0013H\u0002J\t\u0010\u009d\u0001\u001a\u00020\u0013H\u0002J\t\u0010\u009e\u0001\u001a\u00020\u0013H\u0002J\t\u0010\u009f\u0001\u001a\u00020\u0013H\u0002J\t\u0010\u00a0\u0001\u001a\u00020\u0013H\u0002J\u0007\u0010\u00a1\u0001\u001a\u00020\u0013J\u0007\u0010\u00a2\u0001\u001a\u00020\u0013J\t\u0010\u00a3\u0001\u001a\u00020\u0013H\u0002J\u0012\u0010\u00a4\u0001\u001a\u00020\u00132\u0007\u0010\u0099\u0001\u001a\u00020)H\u0002R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0016\u0010$\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001fR+\u0010*\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020)8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0011\u00101\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u00107\u001a\u0004\u0018\u0001062\b\u0010\u001b\u001a\u0004\u0018\u0001068F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b<\u0010#\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010AR\u0011\u0010B\u001a\u00020C8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0011\u0010F\u001a\u00020C8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010ER\u0011\u0010H\u001a\u00020C8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010ER\u000e\u0010I\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010J\u001a\u00020C8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010ER+\u0010K\u001a\u00020C2\u0006\u0010\u001b\u001a\u00020C8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bN\u0010#\u001a\u0004\bK\u0010E\"\u0004\bL\u0010MR+\u0010O\u001a\u00020C2\u0006\u0010\u001b\u001a\u00020C8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bQ\u0010#\u001a\u0004\bO\u0010E\"\u0004\bP\u0010MR+\u0010R\u001a\u00020C2\u0006\u0010\u001b\u001a\u00020C8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bT\u0010#\u001a\u0004\bR\u0010E\"\u0004\bS\u0010MR+\u0010U\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bY\u0010#\u001a\u0004\bV\u0010&\"\u0004\bW\u0010XR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010[\u001a\u00020\\X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010]R/\u0010_\u001a\u0004\u0018\u00010^2\b\u0010\u001b\u001a\u0004\u0018\u00010^8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bd\u0010#\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR\u000e\u0010e\u001a\u00020fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010g\u001a\u00020hX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010i\u001a\u00020jX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010kR\u0017\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00130m\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010oR\u0017\u0010p\u001a\b\u0012\u0004\u0012\u00020\u00130m\u00a2\u0006\b\n\u0000\u001a\u0004\bq\u0010oR\u000e\u0010r\u001a\u00020sX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010t\u001a\b\u0012\u0004\u0012\u00020\u00170u8F\u00a2\u0006\u0006\u001a\u0004\bv\u0010wR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010x\u001a\u00020C8F\u00a2\u0006\u0006\u001a\u0004\by\u0010ER+\u0010z\u001a\u00020C2\u0006\u0010\u001b\u001a\u00020C8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b}\u00100\u001a\u0004\b{\u0010E\"\u0004\b|\u0010MR%\u0010~\u001a\u0015\u0012\u0011\u0012\u000f\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u0080\u00010\u007f0\u007f0m\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0081\u0001\u0010oR\u0010\u0010\u0082\u0001\u001a\u00030\u0083\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a5\u0001"}, d2={"Lui/screen/SessionScreenModel;", "Lcafe/adriel/voyager/core/model/ScreenModel;", "session", "Lmodel/Session;", "context", "Lui/model/AppContext;", "appPreferenceRepository", "Lrepository/AppPreferenceRepository;", "sessionRepository", "Lrepository/SessionRepository;", "alertDialogController", "Lui/common/AlertDialogController;", "permissionChecker", "Lio/PermissionChecker;", "fileInteractor", "Lio/FileInteractor;", "(Lmodel/Session;Lui/model/AppContext;Lrepository/AppPreferenceRepository;Lrepository/SessionRepository;Lui/common/AlertDialogController;Lio/PermissionChecker;Lio/FileInteractor;)V", "_requestExit", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "_requestScrollToCurrentSentenceFlow", "_sentences", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "Lui/model/Sentence;", "comments", "", "", "<set-?>", "Lio/File;", "contentDirectory", "getContentDirectory", "()Lio/File;", "setContentDirectory", "(Lio/File;)V", "contentDirectory$delegate", "Landroidx/compose/runtime/MutableState;", "currentComment", "getCurrentComment", "()Ljava/lang/String;", "currentFile", "getCurrentFile", "", "currentIndex", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "currentIndex$delegate", "Lutil/SavedMutableState;", "currentSentence", "getCurrentSentence", "()Lui/model/Sentence;", "errorNotifier", "Lui/common/ErrorNotifier;", "Lmodel/GuideAudio;", "guideAudioConfig", "getGuideAudioConfig", "()Lmodel/GuideAudio;", "setGuideAudioConfig", "(Lmodel/GuideAudio;)V", "guideAudioConfig$delegate", "guidePlayer", "Laudio/AudioPlayer;", "guidePlayerListener", "ui/screen/SessionScreenModel$guidePlayerListener$1", "Lui/screen/SessionScreenModel$guidePlayerListener$1;", "hasNext", "", "getHasNext", "()Z", "hasPrevious", "getHasPrevious", "isBusy", "isPermissionGranted", "isPlaying", "isRecording", "setRecording", "(Z)V", "isRecording$delegate", "isRequestedPlaying", "setRequestedPlaying", "isRequestedPlaying$delegate", "isRequestedRecording", "setRequestedRecording", "isRequestedRecording$delegate", "name", "getName", "setName", "(Ljava/lang/String;)V", "name$delegate", "player", "playerListener", "ui/screen/SessionScreenModel$playerListener$1", "Lui/screen/SessionScreenModel$playerListener$1;", "", "playingProgress", "getPlayingProgress", "()Ljava/lang/Float;", "setPlayingProgress", "(Ljava/lang/Float;)V", "playingProgress$delegate", "postScheduler", "Laudio/PostRecordingScheduler;", "recorder", "Laudio/AudioRecorder;", "recorderListener", "ui/screen/SessionScreenModel$recorderListener$1", "Lui/screen/SessionScreenModel$recorderListener$1;", "requestExit", "Lkotlinx/coroutines/flow/Flow;", "getRequestExit", "()Lkotlinx/coroutines/flow/Flow;", "requestScrollToCurrentSentenceFlow", "getRequestScrollToCurrentSentenceFlow", "scheduler", "Laudio/RecordingScheduler;", "sentences", "", "getSentences", "()Ljava/util/List;", "shouldShowSubTitle", "getShouldShowSubTitle", "skipFinishedSentences", "getSkipFinishedSentences", "setSkipFinishedSentences", "skipFinishedSentences$delegate", "waveformFlow", "", "", "getWaveformFlow", "waveformPainter", "Lgraph/WaveformPainter;", "getCurrentSentenceSubTitle", "(Landroidx/compose/runtime/Composer;I)Ljava/lang/String;", "getCurrentSentenceTitle", "getFile", "sentence", "getNextSentenceIndex", "()Ljava/lang/Integer;", "getPreviousSentenceIndex", "isFileExisting", "next", "nextWithScheduler", "onDispose", "prepareOutputFile", "previous", "reload", "renameSession", "newName", "requestScrollToCurrentSentence", "requestStartRecording", "requestStopRecording", "selectSentence", "index", "scheduled", "startPlaying", "startRecording", "startRecordingSchedule", "stopPlaying", "stopRecording", "switchScheduled", "togglePlaying", "toggleRecording", "updateCurrentSentence", "updateSentence", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSessionScreenModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionScreenModel.kt\nui/screen/SessionScreenModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,578:1\n1549#2:579\n1620#2,3:580\n1549#2:595\n1620#2,3:596\n350#2,7:614\n378#2,7:621\n81#3:583\n107#3,2:584\n81#3:586\n107#3,2:587\n81#3:589\n107#3,2:590\n81#3:592\n107#3,2:593\n81#3:599\n107#3,2:600\n81#3:602\n107#3,2:603\n81#3:605\n107#3,2:606\n81#3:608\n107#3,2:609\n81#3:611\n107#3,2:612\n1#4:628\n*S KotlinDebug\n*F\n+ 1 SessionScreenModel.kt\nui/screen/SessionScreenModel\n*L\n69#1:579\n69#1:580,3\n95#1:595\n95#1:596,3\n471#1:614,7\n511#1:621,7\n62#1:583\n62#1:584,2\n65#1:586\n65#1:587,2\n75#1:589\n75#1:590,2\n81#1:592\n81#1:593,2\n136#1:599\n136#1:600,2\n139#1:602\n139#1:603,2\n141#1:605\n141#1:606,2\n144#1:608\n144#1:609,2\n149#1:611\n149#1:612,2\n*E\n"})
public final class SessionScreenModel
implements ScreenModel {
    @NotNull
    private final AppPreferenceRepository appPreferenceRepository;
    @NotNull
    private final SessionRepository sessionRepository;
    @NotNull
    private final AlertDialogController alertDialogController;
    @NotNull
    private final PermissionChecker permissionChecker;
    @NotNull
    private final MutableState name$delegate;
    @NotNull
    private final MutableState contentDirectory$delegate;
    @NotNull
    private SnapshotStateList<Sentence> _sentences;
    @Nullable
    private Map<String, String> comments;
    @NotNull
    private final MutableState guideAudioConfig$delegate;
    @NotNull
    private final RecordingScheduler scheduler;
    @NotNull
    private final PostRecordingScheduler postScheduler;
    @NotNull
    private final SavedMutableState skipFinishedSentences$delegate;
    @NotNull
    private final MutableSharedFlow<Unit> _requestExit;
    @NotNull
    private final Flow<Unit> requestExit;
    @NotNull
    private final SavedMutableState currentIndex$delegate;
    @NotNull
    private final MutableState isRequestedRecording$delegate;
    @NotNull
    private final MutableState isRecording$delegate;
    @NotNull
    private final MutableState playingProgress$delegate;
    @NotNull
    private final MutableState isRequestedPlaying$delegate;
    @NotNull
    private final playerListener.1 playerListener;
    @NotNull
    private final recorderListener.1 recorderListener;
    @NotNull
    private final guidePlayerListener.1 guidePlayerListener;
    @NotNull
    private final ErrorNotifier errorNotifier;
    @NotNull
    private final AudioPlayer player;
    @NotNull
    private final AudioRecorder recorder;
    @NotNull
    private final WaveformPainter waveformPainter;
    @NotNull
    private final Flow<float[][][]> waveformFlow;
    @NotNull
    private final AudioPlayer guidePlayer;
    private boolean isPermissionGranted;
    @NotNull
    private final MutableSharedFlow<Unit> _requestScrollToCurrentSentenceFlow;
    @NotNull
    private final Flow<Unit> requestScrollToCurrentSentenceFlow;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SessionScreenModel(@NotNull Session session, @NotNull AppContext context, @NotNull AppPreferenceRepository appPreferenceRepository, @NotNull SessionRepository sessionRepository, @NotNull AlertDialogController alertDialogController, @NotNull PermissionChecker permissionChecker, @NotNull FileInteractor fileInteractor) {
        void $this$waveformPainter_u24lambda_u242;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appPreferenceRepository, (String)"appPreferenceRepository");
        Intrinsics.checkNotNullParameter((Object)sessionRepository, (String)"sessionRepository");
        Intrinsics.checkNotNullParameter((Object)alertDialogController, (String)"alertDialogController");
        Intrinsics.checkNotNullParameter((Object)permissionChecker, (String)"permissionChecker");
        Intrinsics.checkNotNullParameter((Object)fileInteractor, (String)"fileInteractor");
        this.appPreferenceRepository = appPreferenceRepository;
        this.sessionRepository = sessionRepository;
        this.alertDialogController = alertDialogController;
        this.permissionChecker = permissionChecker;
        this.name$delegate = SnapshotStateKt.mutableStateOf$default((Object)session.getName(), null, (int)2, null);
        this.contentDirectory$delegate = SnapshotStateKt.mutableStateOf$default((Object)session.getDirectory(), null, (int)2, null);
        Object object = session.getReclist().getLines();
        SessionScreenModel sessionScreenModel = this;
        boolean $i$f$map22 = false;
        void var10_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Sentence((String)it, this.isFileExisting((String)it)));
        }
        sessionScreenModel._sentences = SnapshotStateKt.toMutableStateList((Collection)((List)destination$iv$iv));
        this.comments = session.getReclist().getComments();
        this.guideAudioConfig$delegate = SnapshotStateKt.mutableStateOf$default((Object)session.getGuideAudioConfig(), null, (int)2, null);
        this.scheduler = new RecordingScheduler(this.appPreferenceRepository, ScreenModelKt.getScreenModelScope((ScreenModel)this));
        this.postScheduler = new PostRecordingScheduler(this.appPreferenceRepository, ScreenModelKt.getScreenModelScope((ScreenModel)this));
        this.skipFinishedSentences$delegate = SavedMutableStateKt.savedMutableStateOf(session.getSkipFinishedSentence(), (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ SessionScreenModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean it) {
                BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, it, null){
                    int label;
                    final /* synthetic */ SessionScreenModel this$0;
                    final /* synthetic */ boolean $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                SessionRepository sessionRepository = SessionScreenModel.access$getSessionRepository$p(this.this$0);
                                Object object3 = SessionScreenModel.access$getSessionRepository$p(this.this$0).get-IoAF18A(this.this$0.getName());
                                ResultKt.throwOnFailure((Object)object3);
                                this.label = 1;
                                Object object4 = sessionRepository.update(Session.copy$default((Session)object3, null, null, null, null, this.$it, 15, null), (Continuation<? super Unit>)((Continuation)this));
                                if (object4 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object4 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
        this._requestExit = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.requestExit = (Flow)this._requestExit;
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SessionScreenModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest(this.this$0.sessionRepository.getSessionUpdated(), (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ SessionScreenModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        String updatedName = (String)this.L$0;
                                        if (Intrinsics.areEqual((Object)updatedName, (Object)this.this$0.getName())) {
                                            Object object2 = this.this$0.sessionRepository.get-IoAF18A(updatedName);
                                            ResultKt.throwOnFailure((Object)object2);
                                            this.this$0.reload((Session)object2);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull String p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SessionScreenModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest(this.this$0.scheduler.getEventFlow(), (Function2)((Function2)new Function2<RecordingScheduler.Event, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ SessionScreenModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        RecordingScheduler.Event event;
                                        ResultKt.throwOnFailure((Object)object);
                                        RecordingScheduler.Event event2 = event = (RecordingScheduler.Event)((Object)this.L$0);
                                        switch (WhenMappings.$EnumSwitchMapping$0[event2.ordinal()]) {
                                            case 1: {
                                                this.this$0.nextWithScheduler();
                                                break;
                                            }
                                            case 2: {
                                                this.this$0.requestStopRecording();
                                                break;
                                            }
                                            case 3: {
                                                this.this$0.startRecording();
                                                break;
                                            }
                                            case 4: {
                                                this.this$0.stopRecording();
                                            }
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull RecordingScheduler.Event p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create((Object)p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            @Metadata(mv={1, 9, 0}, k=3, xi=48)
                            public final class WhenMappings {
                                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                                static {
                                    int[] nArray = new int[RecordingScheduler.Event.values().length];
                                    try {
                                        nArray[RecordingScheduler.Event.Next.ordinal()] = 1;
                                    }
                                    catch (NoSuchFieldError noSuchFieldError) {
                                        // empty catch block
                                    }
                                    try {
                                        nArray[RecordingScheduler.Event.Stop.ordinal()] = 2;
                                    }
                                    catch (NoSuchFieldError noSuchFieldError) {
                                        // empty catch block
                                    }
                                    try {
                                        nArray[RecordingScheduler.Event.StartRecording.ordinal()] = 3;
                                    }
                                    catch (NoSuchFieldError noSuchFieldError) {
                                        // empty catch block
                                    }
                                    try {
                                        nArray[RecordingScheduler.Event.StopRecording.ordinal()] = 4;
                                    }
                                    catch (NoSuchFieldError noSuchFieldError) {
                                        // empty catch block
                                    }
                                    $EnumSwitchMapping$0 = nArray;
                                }
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SessionScreenModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest(this.this$0.postScheduler.getEventFlow(), (Function2)((Function2)new Function2<PostRecordingScheduler.Event, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ SessionScreenModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        PostRecordingScheduler.Event event;
                                        ResultKt.throwOnFailure((Object)object);
                                        PostRecordingScheduler.Event event2 = event = (PostRecordingScheduler.Event)((Object)this.L$0);
                                        switch (WhenMappings.$EnumSwitchMapping$0[event2.ordinal()]) {
                                            case 1: {
                                                if (this.this$0.isPlaying()) break;
                                                this.this$0.startPlaying();
                                                break;
                                            }
                                            case 2: {
                                                this.this$0.next();
                                            }
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull PostRecordingScheduler.Event p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create((Object)p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            @Metadata(mv={1, 9, 0}, k=3, xi=48)
                            public final class WhenMappings {
                                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                                static {
                                    int[] nArray = new int[PostRecordingScheduler.Event.values().length];
                                    try {
                                        nArray[PostRecordingScheduler.Event.Playback.ordinal()] = 1;
                                    }
                                    catch (NoSuchFieldError noSuchFieldError) {
                                        // empty catch block
                                    }
                                    try {
                                        nArray[PostRecordingScheduler.Event.Next.ordinal()] = 2;
                                    }
                                    catch (NoSuchFieldError noSuchFieldError) {
                                        // empty catch block
                                    }
                                    $EnumSwitchMapping$0 = nArray;
                                }
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.sessionRepository.updateUsedTime(session.getName());
        this.currentIndex$delegate = SavedMutableStateKt.savedMutableStateOf(0, (Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ SessionScreenModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                SessionScreenModel.access$getWaveformPainter$p(this.this$0).switch(SessionScreenModel.access$getCurrentFile(this.this$0));
            }
        });
        this.isRequestedRecording$delegate = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
        this.isRecording$delegate = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
        this.playingProgress$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
        this.isRequestedPlaying$delegate = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
        this.playerListener = new AudioPlayer.Listener(this){
            final /* synthetic */ SessionScreenModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStarted() {
            }

            public void onProgress(float progress) {
                SessionScreenModel.access$setPlayingProgress(this.this$0, Float.valueOf(progress));
            }

            public void onStopped() {
                SessionScreenModel.access$setPlayingProgress(this.this$0, null);
                SessionScreenModel.access$setRequestedPlaying(this.this$0, false);
                SessionScreenModel.access$getPostScheduler$p(this.this$0).onFinishPlayback(this.this$0.getGuideAudioConfig());
            }
        };
        this.recorderListener = new AudioRecorder.Listener(this){
            @Nullable
            private WaveformPainter waveformPainter;
            @Nullable
            private Integer lastSentenceIndex;
            final /* synthetic */ SessionScreenModel this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public final WaveformPainter getWaveformPainter() {
                return this.waveformPainter;
            }

            public final void setWaveformPainter(@Nullable WaveformPainter waveformPainter) {
                this.waveformPainter = waveformPainter;
            }

            @Nullable
            public final Integer getLastSentenceIndex() {
                return this.lastSentenceIndex;
            }

            public final void setLastSentenceIndex(@Nullable Integer n) {
                this.lastSentenceIndex = n;
            }

            public void onStarted() {
                SessionScreenModel.access$setRecording(this.this$0, true);
                this.lastSentenceIndex = this.this$0.getCurrentIndex();
            }

            public void onStopped() {
                block6: {
                    boolean isSwitching;
                    RecordingScheduler.State state = SessionScreenModel.access$getScheduler$p(this.this$0).getState();
                    Log.INSTANCE.d("AudioRecorderListener onStopped, state: " + state);
                    boolean bl = isSwitching = state == RecordingScheduler.State.Switching;
                    if (state != RecordingScheduler.State.RecordingStandby) {
                        WaveformPainter waveformPainter = this.waveformPainter;
                        if (waveformPainter != null) {
                            waveformPainter.onStopRecording(isSwitching);
                        }
                    }
                    if (isSwitching) {
                        SessionScreenModel.access$switchScheduled(this.this$0);
                    } else if (state == RecordingScheduler.State.Stopping || !SessionScreenModel.access$isRequestedRecording(this.this$0)) {
                        SessionScreenModel.access$setRecording(this.this$0, false);
                        SessionScreenModel.access$getPostScheduler$p(this.this$0).onFinishRecording(this.this$0.getGuideAudioConfig());
                    }
                    if (state == RecordingScheduler.State.RecordingStandby) break block6;
                    Integer n = this.lastSentenceIndex;
                    if (n != null) {
                        Integer n2 = n;
                        SessionScreenModel sessionScreenModel = this.this$0;
                        int it = ((Number)n2).intValue();
                        boolean bl2 = false;
                        SessionScreenModel.access$updateSentence(sessionScreenModel, it);
                    }
                }
            }
        };
        this.guidePlayerListener = new AudioPlayer.Listener(this){
            final /* synthetic */ SessionScreenModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStarted() {
                if (SessionScreenModel.access$getScheduler$p(this.this$0).getState() == RecordingScheduler.State.Switching || !this.this$0.isRecording()) {
                    SessionScreenModel.access$startRecordingSchedule(this.this$0);
                    SessionScreenModel.access$getWaveformPainter$p(this.this$0).clear();
                    SessionScreenModel.access$setRecording(this.this$0, true);
                }
            }

            public void onProgress(float progress) {
            }

            public void onStopped() {
                if (SessionScreenModel.access$getScheduler$p(this.this$0).getState() == RecordingScheduler.State.Recording) {
                    SessionScreenModel.access$getScheduler$p(this.this$0).onGuideAudioEnd();
                }
            }
        };
        this.errorNotifier = new ErrorNotifier(this.alertDialogController, context, fileInteractor, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SessionScreenModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this.this$0), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                    int label;
                    final /* synthetic */ SessionScreenModel this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = SessionScreenModel.access$get_requestExit$p(this.this$0).emit((Object)Unit.INSTANCE, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }));
        this.player = new AudioPlayerProvider(this.playerListener, context, this.errorNotifier, this.appPreferenceRepository).get();
        this.recorder = new AudioRecorderProvider(this.recorderListener, context, this.errorNotifier, this.appPreferenceRepository).get();
        Object $i$f$map22 = object = new WaveformPainter(this.recorder.getWaveDataFlow(), ScreenModelKt.getScreenModelScope((ScreenModel)this), this.errorNotifier);
        sessionScreenModel = this;
        boolean bl = false;
        $this$waveformPainter_u24lambda_u242.switch(this.getCurrentFile());
        this.recorderListener.setWaveformPainter((WaveformPainter)$this$waveformPainter_u24lambda_u242);
        sessionScreenModel.waveformPainter = object;
        this.waveformFlow = this.waveformPainter.getFlow();
        this.guidePlayer = new AudioPlayerProvider(this.guidePlayerListener, context, this.errorNotifier, this.appPreferenceRepository).get();
        this.isPermissionGranted = this.permissionChecker.checkAndRequestRecordingPermission();
        this._requestScrollToCurrentSentenceFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.requestScrollToCurrentSentenceFlow = (Flow)this._requestScrollToCurrentSentenceFlow;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getName() {
        void $this$getValue$iv;
        State state = (State)this.name$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (String)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setName(String string) {
        void $this$setValue$iv;
        MutableState mutableState = this.name$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File getContentDirectory() {
        void $this$getValue$iv;
        State state = (State)this.contentDirectory$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (File)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setContentDirectory(File file) {
        void $this$setValue$iv;
        MutableState mutableState = this.contentDirectory$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)file);
    }

    @NotNull
    public final List<Sentence> getSentences() {
        return (List)this._sentences;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final GuideAudio getGuideAudioConfig() {
        void $this$getValue$iv;
        State state = (State)this.guideAudioConfig$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (GuideAudio)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setGuideAudioConfig(GuideAudio guideAudio) {
        void $this$setValue$iv;
        MutableState mutableState = this.guideAudioConfig$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)guideAudio);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getSkipFinishedSentences() {
        void $this$getValue$iv;
        State state = (State)this.skipFinishedSentences$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setSkipFinishedSentences(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.skipFinishedSentences$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    public final boolean getShouldShowSubTitle() {
        return this.comments != null && this.appPreferenceRepository.getValue().getTitleBarStyle().getHasSub();
    }

    @NotNull
    public final Flow<Unit> getRequestExit() {
        return this.requestExit;
    }

    /*
     * WARNING - void declaration
     */
    private final void reload(Session session) {
        void $this$mapTo$iv$iv;
        this.setName(session.getName());
        this.setContentDirectory(session.getDirectory());
        Iterable $this$map$iv = session.getReclist().getLines();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Sentence((String)it, this.isFileExisting((String)it)));
        }
        List newSentences = (List)destination$iv$iv;
        this.setCurrentIndex(RangesKt.coerceAtMost((int)this.getCurrentIndex(), (int)(newSentences.size() - 1)));
        this._sentences.clear();
        this._sentences.addAll((Collection)newSentences);
        this.comments = session.getReclist().getComments();
        this.setGuideAudioConfig(session.getGuideAudioConfig());
        Log.INSTANCE.d("Reloading session: " + this.getName());
        Log.INSTANCE.d("guideAudioConfig: " + this.getGuideAudioConfig());
    }

    /*
     * WARNING - void declaration
     */
    public final int getCurrentIndex() {
        void $this$getValue$iv;
        State state = (State)this.currentIndex$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCurrentIndex(int n) {
        void $this$setValue$iv;
        MutableState mutableState = this.currentIndex$delegate;
        Object var3_3 = null;
        Integer value$iv = n;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRequestedRecording() {
        void $this$getValue$iv;
        State state = (State)this.isRequestedRecording$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setRequestedRecording(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.isRequestedRecording$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRecording() {
        void $this$getValue$iv;
        State state = (State)this.isRecording$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setRecording(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.isRecording$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Float getPlayingProgress() {
        void $this$getValue$iv;
        State state = (State)this.playingProgress$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Float)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setPlayingProgress(Float f) {
        void $this$setValue$iv;
        MutableState mutableState = this.playingProgress$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)f);
    }

    public final boolean isPlaying() {
        return this.getPlayingProgress() != null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRequestedPlaying() {
        void $this$getValue$iv;
        State state = (State)this.isRequestedPlaying$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setRequestedPlaying(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.isRequestedPlaying$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    public final boolean isBusy() {
        return this.isRequestedRecording() != this.isRecording() || this.isRequestedPlaying() != this.isPlaying();
    }

    @NotNull
    public final Sentence getCurrentSentence() {
        return (Sentence)this._sentences.get(this.getCurrentIndex());
    }

    private final String getCurrentComment() {
        Map<String, String> map2 = this.comments;
        return map2 != null ? map2.get(this.getCurrentSentence().getText()) : null;
    }

    @Composable
    @NotNull
    public final String getCurrentSentenceTitle(@Nullable Composer $composer, int $changed) {
        String string;
        AppPreference.TitleBarStyle titleBarStyle;
        $composer.startReplaceableGroup(2004856675);
        ComposerKt.sourceInformation((Composer)$composer, (String)"C(getCurrentSentenceTitle)");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)2004856675, (int)$changed, (int)-1, (String)"ui.screen.SessionScreenModel.getCurrentSentenceTitle (SessionScreenModel.kt:162)");
        }
        if ((titleBarStyle = this.appPreferenceRepository.getValue().getTitleBarStyle()) == AppPreference.TitleBarStyle.FileName ? true : titleBarStyle == AppPreference.TitleBarStyle.FileNameWithComment) {
            string = this.getCurrentSentence().getText();
        } else if (titleBarStyle == AppPreference.TitleBarStyle.CommentWithFileName ? true : titleBarStyle == AppPreference.TitleBarStyle.Comment) {
            boolean reclistHasComment;
            boolean bl = reclistHasComment = this.comments != null;
            if (reclistHasComment) {
                Map<String, String> map2 = this.comments;
                string = map2 != null ? map2.get(this.getCurrentSentence().getText()) : null;
                if (string == null) {
                    string = StringsKt.string(Strings.SessionScreenCommentEmpty, new Object[0], $composer, 70);
                }
            } else {
                string = this.getCurrentSentence().getText();
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string2 = string;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceableGroup();
        return string2;
    }

    @Composable
    @Nullable
    public final String getCurrentSentenceSubTitle(@Nullable Composer $composer, int $changed) {
        $composer.startReplaceableGroup(-1047973269);
        ComposerKt.sourceInformation((Composer)$composer, (String)"C(getCurrentSentenceSubTitle)");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1047973269, (int)$changed, (int)-1, (String)"ui.screen.SessionScreenModel.getCurrentSentenceSubTitle (SessionScreenModel.kt:181)");
        }
        String string = switch (WhenMappings.$EnumSwitchMapping$0[this.appPreferenceRepository.getValue().getTitleBarStyle().ordinal()]) {
            case 1, 2 -> null;
            case 3 -> this.getCurrentSentence().getText();
            case 4 -> this.getCurrentComment();
            default -> throw new NoWhenBranchMatchedException();
        };
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceableGroup();
        return string;
    }

    @NotNull
    public final Flow<float[][][]> getWaveformFlow() {
        return this.waveformFlow;
    }

    @NotNull
    public final Flow<Unit> getRequestScrollToCurrentSentenceFlow() {
        return this.requestScrollToCurrentSentenceFlow;
    }

    private final void requestScrollToCurrentSentence() {
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SessionScreenModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SessionScreenModel.access$get_requestScrollToCurrentSentenceFlow$p(this.this$0).emit((Object)Unit.INSTANCE, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final File getFile(String sentence) {
        return this.getContentDirectory().resolve(sentence + ".wav");
    }

    private final boolean isFileExisting(String sentence) {
        return this.getFile(sentence).isFile();
    }

    private final File getCurrentFile() {
        return this.getFile(this.getCurrentSentence().getText());
    }

    private final void updateCurrentSentence() {
        this.updateSentence(this.getCurrentIndex());
    }

    private final void updateSentence(int index) {
        this._sentences.set(index, (Object)Sentence.copy$default((Sentence)this._sentences.get(index), null, this.isFileExisting(((Sentence)this._sentences.get(index)).getText()), 1, null));
    }

    public final void toggleRecording() {
        if (this.isRecording()) {
            this.requestStopRecording();
        } else {
            this.requestStartRecording();
        }
    }

    private final void requestStartRecording() {
        GuideAudio guideAudio;
        if (!this.isPermissionGranted) {
            boolean isPermissionIgnored = this.permissionChecker.checkRecordingPermissionIgnored();
            if (isPermissionIgnored) {
                AlertDialogKt.requestConfirm$default(this.alertDialogController, StringsKt.stringStatic(Strings.AlertNeedManualPermissionGrantTitle, new Object[0]), StringsKt.stringStatic(Strings.AlertNeedManualPermissionGrantMessage, new Object[0]), null, null, 12, null);
                return;
            }
            this.isPermissionGranted = this.permissionChecker.checkAndRequestRecordingPermission();
            if (!this.isPermissionGranted) {
                return;
            }
        }
        if ((guideAudio = this.getGuideAudioConfig()) != null && !guideAudio.getFile().exists()) {
            Log.INSTANCE.d("Guide audio file not found: " + guideAudio.getFile().getAbsolutePath());
            AlertDialogKt.requestConfirm$default(this.alertDialogController, null, StringsKt.stringStatic(Strings.SessionScreenAlertGuideAudioNotFoundMessage, new Object[0]), null, null, 13, null);
            return;
        }
        this.setRequestedRecording(true);
        this.prepareOutputFile();
        if (guideAudio != null) {
            Object object;
            this.guidePlayer.play(guideAudio.getFile(), (object = guideAudio.getStartNode()) != null && (object = ((GuideAudio.Node)object).getTimeMs()) != null ? (Long)object : 0L);
        } else {
            this.startRecordingSchedule();
        }
    }

    private final void startRecordingSchedule() {
        this.scheduler.start(this.getGuideAudioConfig());
    }

    private final void startRecording() {
        if (this.recorder.isRecording()) {
            Log.INSTANCE.w("AudioRecorder is already recording");
            return;
        }
        this.recorder.start(this.getCurrentFile());
        this.waveformPainter.onStartRecording();
    }

    private final void prepareOutputFile() {
        File file = this.getCurrentFile().getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        if (this.getCurrentFile().exists()) {
            Log.INSTANCE.i("Deleting existing file: " + this.getCurrentFile() + " for recording");
            this.getCurrentFile().delete();
        }
    }

    private final void requestStopRecording() {
        this.setRequestedRecording(false);
        this.scheduler.finish();
        if (this.recorder.isRecording()) {
            this.stopRecording();
        } else {
            this.updateCurrentSentence();
            this.setRecording(false);
            this.waveformPainter.onStopRecording(false);
            this.postScheduler.onFinishRecording(this.getGuideAudioConfig());
        }
        if (this.guidePlayer.isPlaying()) {
            this.guidePlayer.stop();
        }
    }

    private final void stopRecording() {
        if (!this.recorder.isRecording()) {
            Log.INSTANCE.w("AudioRecorder is not recording");
            return;
        }
        this.recorder.stop();
    }

    public final void togglePlaying() {
        if (this.isPlaying()) {
            this.stopPlaying();
        } else {
            this.startPlaying();
        }
    }

    private final void startPlaying() {
        if (!this.getCurrentFile().exists()) {
            this.postScheduler.onFinishPlayback(this.getGuideAudioConfig());
            return;
        }
        this.setRequestedPlaying(true);
        AudioPlayer.DefaultImpls.play$default(this.player, this.getCurrentFile(), 0L, 2, null);
    }

    private final void stopPlaying() {
        this.setRequestedPlaying(false);
        this.player.stop();
    }

    public final void selectSentence(int index, boolean scheduled) {
        if (index == this.getCurrentIndex()) {
            return;
        }
        this.updateSentence(this.getCurrentIndex());
        this.setCurrentIndex(index);
        if (scheduled) {
            if (this.recorder.isRecording()) {
                this.stopRecording();
            } else {
                this.switchScheduled();
            }
        } else {
            if (this.isRecording() || this.isRequestedRecording()) {
                this.requestStopRecording();
            } else {
                this.updateCurrentSentence();
            }
            if (this.isPlaying() || this.isRequestedPlaying()) {
                this.stopPlaying();
            }
        }
        this.requestScrollToCurrentSentence();
    }

    public static /* synthetic */ void selectSentence$default(SessionScreenModel sessionScreenModel, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        sessionScreenModel.selectSentence(n, bl);
    }

    private final Integer getNextSentenceIndex() {
        int n;
        block5: {
            boolean isLast;
            boolean bl = isLast = this.getCurrentIndex() == this._sentences.size() - 1;
            if (isLast) {
                return null;
            }
            if (!this.getSkipFinishedSentences()) {
                return this.getCurrentIndex() + 1;
            }
            List $this$indexOfFirst$iv = CollectionsKt.drop((Iterable)((Iterable)this._sentences), (int)(this.getCurrentIndex() + 1));
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                Sentence it = (Sentence)item$iv;
                boolean bl2 = false;
                if (!it.isFinished()) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        if (it == -1) {
            return null;
        }
        return this.getCurrentIndex() + 1 + it;
    }

    public final boolean getHasNext() {
        return this.getNextSentenceIndex() != null;
    }

    public final void next() {
        Integer n = this.getNextSentenceIndex();
        if (n == null) {
            return;
        }
        int index = n;
        SessionScreenModel.selectSentence$default(this, index, false, 2, null);
    }

    private final void nextWithScheduler() {
        Integer index = this.getNextSentenceIndex();
        if (index == null) {
            Log.INSTANCE.d("SessionScreenModel nextWithScheduler: no next sentence");
            this.scheduler.finish();
            this.requestStopRecording();
            return;
        }
        this.selectSentence(index, true);
    }

    private final void switchScheduled() {
        GuideAudio config = this.getGuideAudioConfig();
        if (config != null) {
            Object object = config.getRepeatStartingNode();
            if (object != null && (object = ((GuideAudio.Node)object).getTimeMs()) != null) {
                long it = ((Number)object).longValue();
                boolean bl = false;
                this.guidePlayer.seekAndPlay(it);
            }
        } else {
            Log.INSTANCE.e("SessionScreenModel switchScheduled: guideAudioConfig is null");
        }
    }

    private final Integer getPreviousSentenceIndex() {
        int n;
        block3: {
            boolean isFirst;
            boolean bl = isFirst = this.getCurrentIndex() == 0;
            if (isFirst) {
                return null;
            }
            if (!this.getSkipFinishedSentences()) {
                return this.getCurrentIndex() - 1;
            }
            List $this$indexOfLast$iv = CollectionsKt.take((Iterable)((Iterable)this._sentences), (int)this.getCurrentIndex());
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                Sentence it = (Sentence)iterator$iv.previous();
                boolean bl2 = false;
                if (!(!it.isFinished())) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = -1;
        }
        Integer n2 = n;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        return it != -1 ? n2 : null;
    }

    public final boolean getHasPrevious() {
        return this.getPreviousSentenceIndex() != null;
    }

    public final void previous() {
        Integer n = this.getPreviousSentenceIndex();
        if (n == null) {
            return;
        }
        int index = n;
        SessionScreenModel.selectSentence$default(this, index, false, 2, null);
    }

    public final void renameSession(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, newName, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SessionScreenModel this$0;
            final /* synthetic */ String $newName;
            {
                this.this$0 = $receiver;
                this.$newName = $newName;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object3;
                        CoroutineScope $this$launch;
                        ResultKt.throwOnFailure((Object)object);
                        Object object4 = $this$launch = (CoroutineScope)this.L$0;
                        SessionScreenModel sessionScreenModel = this.this$0;
                        Object object5 = this.$newName;
                        boolean $i$f$runCatchingCancellable = false;
                        try {
                            boolean bl = false;
                            Object object6 = SessionScreenModel.access$getSessionRepository$p(sessionScreenModel).rename-gIAlu-s(sessionScreenModel.getName(), (String)object5);
                            ResultKt.throwOnFailure((Object)object6);
                            Session newSession = (Session)object6;
                            SessionScreenModel.access$reload(sessionScreenModel, newSession);
                            object3 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable e$iv) {
                            if (e$iv instanceof CancellationException) {
                                throw e$iv;
                            }
                            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
                        }
                        object4 = object3;
                        sessionScreenModel = this.this$0;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object4);
                        if (throwable == null) break;
                        Object it = object5 = throwable;
                        boolean bl = false;
                        this.L$0 = object4;
                        this.label = 1;
                        Object object7 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Throwable)it, sessionScreenModel, null){
                            int label;
                            final /* synthetic */ Throwable $it;
                            final /* synthetic */ SessionScreenModel this$0;
                            {
                                this.$it = $it;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Log.INSTANCE.e("Failed to rename session", this.$it);
                                        Throwable throwable = this.$it;
                                        if (throwable instanceof SessionRenameInvalidException ? true : throwable instanceof SessionRenameExistingException) {
                                            AlertDialogKt.requestConfirmError$default(SessionScreenModel.access$getAlertDialogController$p(this.this$0), this.$it.getMessage(), null, null, 6, null);
                                        } else {
                                            AlertDialogKt.requestConfirm$default(SessionScreenModel.access$getAlertDialogController$p(this.this$0), null, StringsKt.stringStatic(Strings.ExceptionRenameSessionUnexpected, new Object[0]), null, null, 13, null);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        if (object7 == object2) {
                            return object2;
                        }
                        break;
                    }
                    case 1: {
                        void $result;
                        boolean bl = false;
                        Object object8 = this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object7 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public void onDispose() {
        this.scheduler.dispose();
        this.recorder.dispose();
        this.player.dispose();
        this.guidePlayer.dispose();
        this.waveformPainter.dispose();
        ScreenModel.DefaultImpls.onDispose((ScreenModel)this);
    }

    public static final /* synthetic */ MutableSharedFlow access$get_requestScrollToCurrentSentenceFlow$p(SessionScreenModel $this) {
        return $this._requestScrollToCurrentSentenceFlow;
    }

    public static final /* synthetic */ AlertDialogController access$getAlertDialogController$p(SessionScreenModel $this) {
        return $this.alertDialogController;
    }

    public static final /* synthetic */ WaveformPainter access$getWaveformPainter$p(SessionScreenModel $this) {
        return $this.waveformPainter;
    }

    public static final /* synthetic */ File access$getCurrentFile(SessionScreenModel $this) {
        return $this.getCurrentFile();
    }

    public static final /* synthetic */ void access$setPlayingProgress(SessionScreenModel $this, Float f) {
        $this.setPlayingProgress(f);
    }

    public static final /* synthetic */ void access$setRequestedPlaying(SessionScreenModel $this, boolean bl) {
        $this.setRequestedPlaying(bl);
    }

    public static final /* synthetic */ void access$setRecording(SessionScreenModel $this, boolean bl) {
        $this.setRecording(bl);
    }

    public static final /* synthetic */ void access$switchScheduled(SessionScreenModel $this) {
        $this.switchScheduled();
    }

    public static final /* synthetic */ boolean access$isRequestedRecording(SessionScreenModel $this) {
        return $this.isRequestedRecording();
    }

    public static final /* synthetic */ void access$updateSentence(SessionScreenModel $this, int index) {
        $this.updateSentence(index);
    }

    public static final /* synthetic */ void access$startRecordingSchedule(SessionScreenModel $this) {
        $this.startRecordingSchedule();
    }

    public static final /* synthetic */ MutableSharedFlow access$get_requestExit$p(SessionScreenModel $this) {
        return $this._requestExit;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AppPreference.TitleBarStyle.values().length];
            try {
                nArray[AppPreference.TitleBarStyle.FileName.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppPreference.TitleBarStyle.Comment.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppPreference.TitleBarStyle.CommentWithFileName.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppPreference.TitleBarStyle.FileNameWithComment.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

