/*
 * Decompiled with CFR 0.152.
 */
package repository;

import androidx.compose.runtime.internal.StabilityInferred;
import exception.ReclistNotFoundException;
import exception.SessionRenameExistingException;
import exception.SessionRenameInvalidException;
import io.File;
import io.Paths;
import io.PathsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import model.GuideAudio;
import model.Reclist;
import model.Session;
import model.SessionItem;
import model.SessionParams;
import model.SessionParamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import repository.GuideAudioRepository;
import repository.ItemUsedTimeRepository;
import repository.ItemUsedTimeRepositoryImpl;
import repository.ReclistRepository;
import util.DateTime;
import util.JsonKt;
import util.StringKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u000f\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ \u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\tJ\u0006\u0010'\u001a\u00020%J!\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u0010 \u001a\u00020\r\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b)\u0010*J\u0011\u0010+\u001a\u00020,2\u0006\u0010 \u001a\u00020\rH\u0096\u0001J\u0006\u0010-\u001a\u00020%J\t\u0010.\u001a\u00020%H\u0096\u0001J)\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020\r\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b2\u00103J\u0010\u00104\u001a\u00020%2\u0006\u00105\u001a\u00020\u0016H\u0002J\u0019\u00106\u001a\u00020%2\u0006\u0010 \u001a\u00020\r2\u0006\u00107\u001a\u00020,H\u0096\u0001J\u0016\u00108\u001a\u00020%2\u0006\u00105\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u00109J\u0011\u0010:\u001a\u00020%2\u0006\u0010 \u001a\u00020\rH\u0096\u0001R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006;"}, d2={"Lrepository/SessionRepository;", "Lrepository/ItemUsedTimeRepository;", "Lmodel/SessionItem;", "reclistRepository", "Lrepository/ReclistRepository;", "guideAudioRepository", "Lrepository/GuideAudioRepository;", "_items", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "(Lrepository/ReclistRepository;Lrepository/GuideAudioRepository;Lkotlinx/coroutines/flow/MutableStateFlow;)V", "_sessionUpdated", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "folder", "Lio/File;", "items", "Lkotlinx/coroutines/flow/Flow;", "getItems", "()Lkotlinx/coroutines/flow/Flow;", "map", "", "Lmodel/Session;", "sessionUpdated", "getSessionUpdated", "create", "Lkotlin/Result;", "reclist", "Lmodel/Reclist;", "create-IoAF18A", "(Lmodel/Reclist;)Ljava/lang/Object;", "createFromParams", "name", "directory", "params", "Lmodel/SessionParams;", "delete", "", "names", "fetch", "get", "get-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "getUsedTime", "", "init", "loadUsedTimes", "rename", "oldName", "newName", "rename-gIAlu-s", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "save", "session", "saveUsedTime", "time", "update", "(Lmodel/Session;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateUsedTime", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSessionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionRepository.kt\nrepository/SessionRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nutil/JsonKt\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,219:1\n766#2:220\n857#2,2:221\n766#2:223\n857#2,2:224\n1549#2:226\n1620#2,3:227\n1549#2:230\n1620#2,3:231\n1855#2,2:239\n819#2:241\n847#2,2:242\n1#3:234\n21#4:235\n21#4:237\n28#4:244\n123#5:236\n123#5:238\n113#5:245\n*S KotlinDebug\n*F\n+ 1 SessionRepository.kt\nrepository/SessionRepository\n*L\n76#1:220\n76#1:221,2\n77#1:223\n77#1:224,2\n78#1:226\n78#1:227,3\n91#1:230\n91#1:231,3\n195#1:239,2\n200#1:241\n200#1:242,2\n136#1:235\n164#1:237\n210#1:244\n136#1:236\n164#1:238\n210#1:245\n*E\n"})
public final class SessionRepository
implements ItemUsedTimeRepository<SessionItem> {
    @NotNull
    private final ReclistRepository reclistRepository;
    @NotNull
    private final GuideAudioRepository guideAudioRepository;
    @NotNull
    private final MutableStateFlow<List<SessionItem>> _items;
    private final /* synthetic */ ItemUsedTimeRepositoryImpl<SessionItem> $$delegate_0;
    private File folder;
    @NotNull
    private final Map<String, Session> map;
    @NotNull
    private final Flow<List<SessionItem>> items;
    @NotNull
    private final MutableSharedFlow<String> _sessionUpdated;
    @NotNull
    private final Flow<String> sessionUpdated;
    public static final int $stable = 8;

    public SessionRepository(@NotNull ReclistRepository reclistRepository, @NotNull GuideAudioRepository guideAudioRepository, final @NotNull MutableStateFlow<List<SessionItem>> _items) {
        Intrinsics.checkNotNullParameter((Object)reclistRepository, (String)"reclistRepository");
        Intrinsics.checkNotNullParameter((Object)guideAudioRepository, (String)"guideAudioRepository");
        Intrinsics.checkNotNullParameter(_items, (String)"_items");
        this.reclistRepository = reclistRepository;
        this.guideAudioRepository = guideAudioRepository;
        this._items = _items;
        this.$$delegate_0 = new ItemUsedTimeRepositoryImpl(PathsKt.getSessionUsageRecordFile(Paths.INSTANCE), (Function1)new Function1<Function1<? super List<? extends SessionItem>, ? extends List<? extends SessionItem>>, Unit>(){

            public final void invoke(@NotNull Function1<? super List<SessionItem>, ? extends List<SessionItem>> update) {
                Intrinsics.checkNotNullParameter(update, (String)"update");
                _items.setValue(update.invoke(_items.getValue()));
            }
        });
        this.map = new LinkedHashMap();
        this.items = (Flow)this._items;
        this._sessionUpdated = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.sessionUpdated = (Flow)this._sessionUpdated;
        this.init();
    }

    public /* synthetic */ SessionRepository(ReclistRepository reclistRepository, GuideAudioRepository guideAudioRepository, MutableStateFlow mutableStateFlow, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            mutableStateFlow = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        }
        this(reclistRepository, guideAudioRepository, (MutableStateFlow<List<SessionItem>>)mutableStateFlow);
    }

    @Override
    public long getUsedTime(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.$$delegate_0.getUsedTime(name);
    }

    @Override
    public void loadUsedTimes() {
        this.$$delegate_0.loadUsedTimes();
    }

    @Override
    public void saveUsedTime(@NotNull String name, long time) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.$$delegate_0.saveUsedTime(name, time);
    }

    @Override
    public void updateUsedTime(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.$$delegate_0.updateUsedTime(name);
    }

    @NotNull
    public final Flow<List<SessionItem>> getItems() {
        return this.items;
    }

    @NotNull
    public final Flow<String> getSessionUpdated() {
        return this.sessionUpdated;
    }

    /*
     * WARNING - void declaration
     */
    public final void init() {
        void it;
        File file;
        File file2 = file = PathsKt.getSessionsDirectory(Paths.INSTANCE);
        SessionRepository sessionRepository = this;
        boolean bl = false;
        if (!it.exists()) {
            it.mkdirs();
        }
        sessionRepository.folder = file;
        this.map.clear();
        this._items.setValue((Object)CollectionsKt.emptyList());
        this.loadUsedTimes();
    }

    /*
     * WARNING - void declaration
     */
    public final void fetch() {
        void $this$mapTo$iv$iv;
        File it;
        Iterable $this$filterTo$iv$iv;
        File file = this.folder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
            file = null;
        }
        Iterable $this$filter$iv = file.listFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.resolve("session.json").isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SessionItem(it.getName(), this.getUsedTime(it.getName())));
        }
        List items2 = (List)destination$iv$iv;
        this._items.setValue((Object)items2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object create-IoAF18A(@NotNull Reclist reclist) {
        Object $this$create_IoAF18A_u24lambda_u245;
        Intrinsics.checkNotNullParameter((Object)reclist, (String)"reclist");
        Object object = this;
        try {
            String defaultName;
            $this$create_IoAF18A_u24lambda_u245 = object;
            boolean bl = false;
            String timeSuffix = DateTime.getNowReadableString$default(DateTime.INSTANCE, false, false, false, false, 13, null);
            String name = defaultName = reclist.getName() + " " + timeSuffix;
            int repeat = 0;
            while (true) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)((SessionRepository)$this$create_IoAF18A_u24lambda_u245)._items.getValue();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SessionItem sessionItem = (SessionItem)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getName());
                }
                if (!((List)destination$iv$iv).contains(name)) break;
                name = defaultName + " (" + ++repeat + ")";
            }
            File file = ((SessionRepository)$this$create_IoAF18A_u24lambda_u245).folder;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
                file = null;
            }
            $this$create_IoAF18A_u24lambda_u245 = Result.constructor-impl((Object)new Session(name, reclist, file.resolve(name).getAbsolutePath(), null, false, 24, null));
        }
        catch (Throwable bl) {
            $this$create_IoAF18A_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$create_IoAF18A_u24lambda_u245;
        if (Result.isSuccess-impl((Object)object)) {
            Session newSession = (Session)object;
            boolean bl = false;
            SessionItem newItem = new SessionItem(newSession.getName(), DateTime.INSTANCE.getNow());
            List items2 = CollectionsKt.toMutableList((Collection)((Collection)this._items.getValue()));
            CollectionsKt.removeAll((List)items2, (Function1)((Function1)new Function1<SessionItem, Boolean>(newItem){
                final /* synthetic */ SessionItem $newItem;
                {
                    this.$newItem = $newItem;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SessionItem it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getName(), (Object)this.$newItem.getName());
                }
            }));
            items2.add(newItem);
            this._items.setValue((Object)items2);
            this.map.put(newSession.getName(), newSession);
            this.saveUsedTime(newSession.getName(), newItem.getLastUsed());
            this.save(newSession);
        }
        return object;
    }

    private final Session createFromParams(String name, File directory, SessionParams params) {
        GuideAudio guideAudio;
        Object object = this.reclistRepository.get-IoAF18A(params.getReclistName());
        Reclist reclist = (Reclist)(Result.isFailure-impl((Object)object) ? null : object);
        if (reclist == null) {
            throw new ReclistNotFoundException(params.getReclistName());
        }
        Reclist reclist2 = reclist;
        String string = params.getGuideAudioName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            guideAudio = this.guideAudioRepository.get(it);
        } else {
            guideAudio = null;
        }
        GuideAudio guideAudioConfig = guideAudio;
        return new Session(name, reclist2, directory.getAbsolutePath(), guideAudioConfig, params.getSkipFinishedSentence());
    }

    @NotNull
    public final Object get-IoAF18A(@NotNull String name) {
        Object $this$get_IoAF18A_u24lambda_u249;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this;
        try {
            Session session;
            $this$get_IoAF18A_u24lambda_u249 = object;
            boolean bl = false;
            Session session2 = ((SessionRepository)$this$get_IoAF18A_u24lambda_u249).map.get(name);
            if (session2 != null) {
                Session it = session2;
                boolean bl2 = false;
                session = it;
            } else {
                File file = ((SessionRepository)$this$get_IoAF18A_u24lambda_u249).folder;
                if (file == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
                    file = null;
                }
                File directory = file.resolve(name);
                File file2 = directory.resolve("session.json");
                String $this$parseJson$iv = File.readText$default(file2, null, 1, null);
                boolean $i$f$parseJson = false;
                StringFormat $this$decodeFromString$iv$iv = (StringFormat)JsonKt.getJson();
                boolean $i$f$decodeFromString = false;
                $this$decodeFromString$iv$iv.getSerializersModule();
                SessionParams params = (SessionParams)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)SessionParams.Companion.serializer(), $this$parseJson$iv);
                session = super.createFromParams(name, directory, params);
            }
            $this$get_IoAF18A_u24lambda_u249 = Result.constructor-impl((Object)session);
        }
        catch (Throwable bl) {
            $this$get_IoAF18A_u24lambda_u249 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$get_IoAF18A_u24lambda_u249;
        if (Result.isSuccess-impl((Object)object)) {
            Session it = (Session)object;
            boolean bl = false;
            this.map.put(name, it);
        }
        return object;
    }

    @NotNull
    public final Object rename-gIAlu-s(@NotNull String oldName, @NotNull String newName) {
        Object $this$rename_gIAlu_s_u24lambda_u2411;
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Object object = this;
        try {
            Session session;
            $this$rename_gIAlu_s_u24lambda_u2411 = object;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)oldName, (Object)newName)) {
                Object object2 = ((SessionRepository)$this$rename_gIAlu_s_u24lambda_u2411).get-IoAF18A(oldName);
                ResultKt.throwOnFailure((Object)object2);
                session = (Session)object2;
            } else {
                File newDirectory;
                if (!StringKt.isValidFileName(newName)) {
                    throw new SessionRenameInvalidException(newName);
                }
                File file = ((SessionRepository)$this$rename_gIAlu_s_u24lambda_u2411).folder;
                if (file == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
                    file = null;
                }
                File oldDirectory = file.resolve(oldName);
                File file2 = ((SessionRepository)$this$rename_gIAlu_s_u24lambda_u2411).folder;
                if (file2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
                    file2 = null;
                }
                if ((newDirectory = file2.resolve(newName)).exists()) {
                    throw new SessionRenameExistingException(newName);
                }
                File.copyTo$default(oldDirectory, newDirectory, false, 2, null);
                oldDirectory.delete();
                File file3 = newDirectory.resolve("session.json");
                String $this$parseJson$iv = File.readText$default(file3, null, 1, null);
                boolean $i$f$parseJson = false;
                StringFormat $this$decodeFromString$iv$iv = (StringFormat)JsonKt.getJson();
                boolean $i$f$decodeFromString = false;
                $this$decodeFromString$iv$iv.getSerializersModule();
                SessionParams params = (SessionParams)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)SessionParams.Companion.serializer(), $this$parseJson$iv);
                session = super.createFromParams(newName, newDirectory, params);
            }
            $this$rename_gIAlu_s_u24lambda_u2411 = Result.constructor-impl((Object)session);
        }
        catch (Throwable bl) {
            $this$rename_gIAlu_s_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$rename_gIAlu_s_u24lambda_u2411;
        if (Result.isSuccess-impl((Object)object)) {
            Session newSession = (Session)object;
            boolean bl = false;
            List items2 = CollectionsKt.toMutableList((Collection)((Collection)this._items.getValue()));
            CollectionsKt.removeAll((List)items2, (Function1)((Function1)new Function1<SessionItem, Boolean>(oldName){
                final /* synthetic */ String $oldName;
                {
                    this.$oldName = $oldName;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SessionItem it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getName(), (Object)this.$oldName);
                }
            }));
            SessionItem newItem = new SessionItem(newName, DateTime.INSTANCE.getNow());
            items2.add(newItem);
            this._items.setValue((Object)items2);
            this.map.remove(oldName);
            this.map.put(newItem.getName(), newSession);
            this.save(newSession);
            this.saveUsedTime(newName, newItem.getLastUsed());
        }
        return object;
    }

    @Nullable
    public final Object update(@NotNull Session session, @NotNull Continuation<? super Unit> $completion) {
        this.map.put(session.getName(), session);
        this.save(session);
        Object object = this._sessionUpdated.emit((Object)session.getName(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public final void delete(@NotNull List<String> names) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Iterable $this$forEach$iv = names;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            File file = this.folder;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
                file = null;
            }
            File directory = file.resolve(name);
            directory.delete();
            this.map.remove(name);
        }
        $this$forEach$iv = (Iterable)this._items.getValue();
        MutableStateFlow<List<SessionItem>> mutableStateFlow = this._items;
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            SessionItem it = (SessionItem)element$iv$iv;
            boolean bl = false;
            if (names.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mutableStateFlow.setValue((Object)((List)destination$iv$iv));
    }

    private final void save(Session session) {
        SessionParams params;
        File directory;
        File file = this.folder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
            file = null;
        }
        if (!(directory = file.resolve(session.getName())).exists()) {
            directory.mkdirs();
        }
        File file2 = directory.resolve("session.json");
        SessionParams $this$stringifyJson$iv = params = SessionParamsKt.toParams(session);
        boolean $i$f$stringifyJson = false;
        StringFormat $this$encodeToString$iv$iv = (StringFormat)JsonKt.getJson();
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv$iv.getSerializersModule();
        file2.writeText($this$encodeToString$iv$iv.encodeToString((SerializationStrategy)SessionParams.Companion.serializer(), (Object)$this$stringifyJson$iv));
    }
}

