/*
 * Decompiled with CFR 0.152.
 */
package repository;

import androidx.compose.runtime.internal.StabilityInferred;
import io.File;
import io.Paths;
import io.PathsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import model.Reclist;
import model.ReclistItem;
import model.ReclistKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import repository.ItemEncodingRepository;
import repository.ItemEncodingRepositoryImpl;
import repository.ItemUsedTimeRepository;
import repository.ItemUsedTimeRepositoryImpl;
import util.DateTime;
import util.Encoding;
import util.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001b\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006J\u0006\u0010\u0015\u001a\u00020\u0013J!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\u0006\u0010\u0018\u001a\u00020\u0010\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00102\b\b\u0002\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\u001b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0010H\u0096\u0001J?\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010#\u001a\u00020\t2\b\u0010$\u001a\u0004\u0018\u00010\u001e2\b\u0010%\u001a\u0004\u0018\u00010\t2\b\u0010&\u001a\u0004\u0018\u00010\u001e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b'\u0010(J\u0006\u0010)\u001a\u00020\u0013J\t\u0010*\u001a\u00020\u0013H\u0096\u0001J#\u0010+\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\b\u0010,\u001a\u0004\u0018\u00010\u001eH\u0096\u0001J\u0019\u0010-\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010.\u001a\u00020!H\u0096\u0001J\u0011\u0010/\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0010H\u0096\u0001R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00060"}, d2={"Lrepository/ReclistRepository;", "Lrepository/ItemUsedTimeRepository;", "Lmodel/ReclistItem;", "Lrepository/ItemEncodingRepository;", "_items", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "(Lkotlinx/coroutines/flow/MutableStateFlow;)V", "folder", "Lio/File;", "items", "Lkotlinx/coroutines/flow/StateFlow;", "getItems", "()Lkotlinx/coroutines/flow/StateFlow;", "map", "", "", "Lmodel/Reclist;", "delete", "", "names", "fetch", "get", "Lkotlin/Result;", "name", "get-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "getCommentFile", "getFile", "getItemEncoding", "Lutil/Encoding;", "category", "getUsedTime", "", "import", "file", "fileEncoding", "commentFile", "commentFileEncoding", "import-BWLJW6A", "(Lio/File;Lutil/Encoding;Lio/File;Lutil/Encoding;)Ljava/lang/Object;", "init", "loadUsedTimes", "putItemEncoding", "encoding", "saveUsedTime", "time", "updateUsedTime", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nReclistRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReclistRepository.kt\nrepository/ReclistRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n766#2:149\n857#2,2:150\n819#2:152\n847#2,2:153\n1549#2:155\n1620#2,3:156\n1549#2:159\n1620#2,3:160\n1855#2,2:164\n819#2:166\n847#2,2:167\n1#3:163\n*S KotlinDebug\n*F\n+ 1 ReclistRepository.kt\nrepository/ReclistRepository\n*L\n105#1:149\n105#1:150,2\n106#1:152\n106#1:153,2\n107#1:155\n107#1:156,3\n108#1:159\n108#1:160,3\n129#1:164,2\n133#1:166\n133#1:167,2\n*E\n"})
public final class ReclistRepository
implements ItemUsedTimeRepository<ReclistItem>,
ItemEncodingRepository {
    @NotNull
    private final MutableStateFlow<List<ReclistItem>> _items;
    private final /* synthetic */ ItemUsedTimeRepositoryImpl<ReclistItem> $$delegate_0;
    private final /* synthetic */ ItemEncodingRepositoryImpl $$delegate_1;
    private File folder;
    @NotNull
    private final Map<String, Reclist> map;
    @NotNull
    private final StateFlow<List<ReclistItem>> items;
    public static final int $stable = 8;

    public ReclistRepository(final @NotNull MutableStateFlow<List<ReclistItem>> _items) {
        Intrinsics.checkNotNullParameter(_items, (String)"_items");
        this._items = _items;
        this.$$delegate_0 = new ItemUsedTimeRepositoryImpl(PathsKt.getReclistRecordFile(Paths.INSTANCE), (Function1)new Function1<Function1<? super List<? extends ReclistItem>, ? extends List<? extends ReclistItem>>, Unit>(){

            public final void invoke(@NotNull Function1<? super List<ReclistItem>, ? extends List<ReclistItem>> update) {
                Intrinsics.checkNotNullParameter(update, (String)"update");
                _items.setValue(update.invoke(_items.getValue()));
            }
        });
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"reclist", (Object)PathsKt.getReclistEncodingRecordFile(Paths.INSTANCE)), TuplesKt.to((Object)"comment", (Object)PathsKt.getReclistCommentEncodingRecordFile(Paths.INSTANCE))};
        this.$$delegate_1 = new ItemEncodingRepositoryImpl(MapsKt.mapOf((Pair[])pairArray));
        this.map = new LinkedHashMap();
        this.items = (StateFlow)this._items;
        this.init();
    }

    public /* synthetic */ ReclistRepository(MutableStateFlow mutableStateFlow, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            mutableStateFlow = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        }
        this((MutableStateFlow<List<ReclistItem>>)mutableStateFlow);
    }

    @Override
    public long getUsedTime(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.$$delegate_0.getUsedTime(name);
    }

    @Override
    public void loadUsedTimes() {
        this.$$delegate_0.loadUsedTimes();
    }

    @Override
    public void saveUsedTime(@NotNull String name, long time) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.$$delegate_0.saveUsedTime(name, time);
    }

    @Override
    public void updateUsedTime(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.$$delegate_0.updateUsedTime(name);
    }

    @Override
    @Nullable
    public Encoding getItemEncoding(@NotNull String category, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.$$delegate_1.getItemEncoding(category, name);
    }

    @Override
    public void putItemEncoding(@NotNull String category, @NotNull String name, @Nullable Encoding encoding) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.$$delegate_1.putItemEncoding(category, name, encoding);
    }

    @NotNull
    public final StateFlow<List<ReclistItem>> getItems() {
        return this.items;
    }

    /*
     * WARNING - void declaration
     */
    public final void init() {
        void it;
        File file;
        File file2 = file = PathsKt.getReclistsDirectory(Paths.INSTANCE);
        ReclistRepository reclistRepository = this;
        boolean bl = false;
        if (!it.exists()) {
            it.mkdirs();
        }
        reclistRepository.folder = file;
        this.map.clear();
        this._items.setValue((Object)CollectionsKt.emptyList());
        this.loadUsedTimes();
    }

    @NotNull
    public final Object import-BWLJW6A(@NotNull File file, @Nullable Encoding fileEncoding, @Nullable File commentFile, @Nullable Encoding commentFileEncoding) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String name = file.getNameWithoutExtension();
        File file3 = commentFile;
        Log.INSTANCE.i("ReclistRepository.import: " + file.getAbsolutePath() + ", commentFile: " + (file3 != null ? file3.getAbsolutePath() : null) + ", fileEncoding: " + fileEncoding + ", commentFileEncoding: " + commentFileEncoding);
        Object object = ReclistKt.parseReclist(file, fileEncoding, commentFile, commentFileEncoding);
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            Log.INSTANCE.e(it);
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it));
        }
        Reclist reclist = (Reclist)object;
        if (this.map.containsKey(name)) {
            Log.INSTANCE.w("ReclistRepository.import: " + name + " already exists, overwriting...");
        }
        if ((file2 = this.folder) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
            file2 = null;
        }
        file.copyTo(file2.resolve(file.getName()), true);
        File file4 = commentFile;
        if (file4 != null) {
            File file5 = this.folder;
            if (file5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
                file5 = null;
            }
            file4.copyTo(this.getCommentFile(name, file5), true);
        }
        ReclistItem newItem = new ReclistItem(name, DateTime.INSTANCE.getNow());
        List items2 = CollectionsKt.toMutableList((Collection)((Collection)this._items.getValue()));
        CollectionsKt.removeAll((List)items2, (Function1)((Function1)new Function1<ReclistItem, Boolean>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ReclistItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getName(), (Object)this.$name);
            }
        }));
        items2.add(newItem);
        this._items.setValue((Object)items2);
        this.map.put(name, reclist);
        this.saveUsedTime(name, newItem.getLastUsed());
        this.putItemEncoding("reclist", name, fileEncoding);
        if (commentFile != null) {
            this.putItemEncoding("comment", name, commentFileEncoding);
        }
        return Result.constructor-impl((Object)Unit.INSTANCE);
    }

    public final void fetch() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        File file = this.folder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
            file = null;
        }
        Iterable $this$filter$iv = file.listFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((File)it).getExtension(), (Object)"txt")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (StringsKt.endsWith$default((String)((File)it).getName(), (String)"-comment.txt", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((File)it).getNameWithoutExtension());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ReclistItem((String)it, this.getUsedTime((String)it)));
        }
        List items2 = (List)destination$iv$iv;
        this._items.setValue((Object)items2);
    }

    @NotNull
    public final Object get-IoAF18A(@NotNull String name) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Reclist reclist = this.map.get(name);
        if (reclist != null) {
            Reclist it = reclist;
            boolean bl = false;
            object = Result.constructor-impl((Object)it);
        } else {
            Object object2;
            Object it = object2 = ReclistRepository.getCommentFile$default(this, name, null, 2, null);
            Encoding encoding = this.getItemEncoding("reclist", name);
            File file = this.getFile(name);
            boolean bl = false;
            boolean bl2 = ((File)it).exists();
            object2 = ReclistKt.parseReclist(file, encoding, (File)(bl2 ? object2 : null), this.getItemEncoding("comment", name));
            if (Result.isSuccess-impl((Object)object2)) {
                it = (Reclist)object2;
                boolean bl3 = false;
                this.map.put(name, (Reclist)it);
            }
            object = object2;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public final void delete(@NotNull List<String> names) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Object it;
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Iterable $this$forEach$iv = names;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            this.getFile(name).delete();
            File file = ReclistRepository.getCommentFile$default(this, name, null, 2, null);
            it = file;
            boolean bl2 = false;
            File file2 = ((File)it).exists() ? file : null;
            if (file2 == null) continue;
            file2.delete();
        }
        $this$forEach$iv = (Iterable)this._items.getValue();
        MutableStateFlow<List<ReclistItem>> mutableStateFlow = this._items;
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ReclistItem)element$iv$iv;
            boolean bl = false;
            if (names.contains(((ReclistItem)it).getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mutableStateFlow.setValue((Object)((List)destination$iv$iv));
    }

    private final File getFile(String name) {
        File file = this.folder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
            file = null;
        }
        return file.resolve(name + ".txt");
    }

    private final File getCommentFile(String name, File folder) {
        return folder.resolve(name + "-comment.txt");
    }

    static /* synthetic */ File getCommentFile$default(ReclistRepository reclistRepository, String string, File file, int n, Object object) {
        if ((n & 2) != 0) {
            File file2 = reclistRepository.folder;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
                file2 = null;
            }
            file = file2;
        }
        return reclistRepository.getCommentFile(string, file);
    }

    public ReclistRepository() {
        this(null, 1, null);
    }
}

