/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io._UtilKt;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.bytestring.ByteStringKt;
import kotlinx.io.bytestring.unsafe.UnsafeByteStringOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\b\u00a8\u0006\r"}, d2={"indexOf", "", "Lkotlinx/io/Source;", "byteString", "Lkotlinx/io/bytestring/ByteString;", "startIndex", "readByteString", "byteCount", "", "write", "", "Lkotlinx/io/Sink;", "endIndex", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nByteStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteStrings.kt\nkotlinx/io/ByteStringsKt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 Sinks.kt\nkotlinx/io/SinksKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 UnsafeByteStringOperations.kt\nkotlinx/io/bytestring/unsafe/UnsafeByteStringOperations\n*L\n1#1,140:1\n38#2:141\n366#3,3:142\n1#4:145\n35#5,2:146\n*S KotlinDebug\n*F\n+ 1 ByteStrings.kt\nkotlinx/io/ByteStringsKt\n*L\n29#1:141\n34#1:142,3\n111#1:146,2\n*E\n"})
public final class ByteStringsKt {
    public static final void write(@NotNull Sink $this$write, @NotNull ByteString byteString, int startIndex, int endIndex) {
        int bytesToWrite;
        Segment tail;
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        int size$iv = byteString.getSize();
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        if (endIndex == startIndex) {
            return;
        }
        Sink $this$writeToInternalBuffer$iv = $this$write;
        boolean $i$f$writeToInternalBuffer = false;
        Buffer buffer = $this$writeToInternalBuffer$iv.getBuffer();
        boolean bl = false;
        int offset = startIndex;
        Segment segment = buffer.head;
        Segment segment2 = tail = segment != null ? segment.prev : null;
        if (tail != null) {
            bytesToWrite = Math.min(tail.data.length - tail.limit, endIndex - offset);
            byteString.copyInto(tail.data, tail.limit, offset, offset + bytesToWrite);
            offset += bytesToWrite;
            tail.limit += bytesToWrite;
            buffer.setSize$kotlinx_io_core(buffer.getSize() + (long)bytesToWrite);
        }
        while (offset < endIndex) {
            bytesToWrite = Math.min(endIndex - offset, 8192);
            Segment seg = buffer.writableSegment$kotlinx_io_core(bytesToWrite);
            byteString.copyInto(seg.data, seg.limit, offset, offset + bytesToWrite);
            seg.limit += bytesToWrite;
            buffer.setSize$kotlinx_io_core(buffer.getSize() + (long)bytesToWrite);
            offset += bytesToWrite;
        }
        $this$writeToInternalBuffer$iv.hintEmit();
    }

    public static /* synthetic */ void write$default(Sink sink, ByteString byteString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byteString.getSize();
        }
        ByteStringsKt.write(sink, byteString, n, n2);
    }

    @NotNull
    public static final ByteString readByteString(@NotNull Source $this$readByteString) {
        Intrinsics.checkNotNullParameter((Object)$this$readByteString, (String)"<this>");
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(SourcesKt.readByteArray($this$readByteString));
    }

    @NotNull
    public static final ByteString readByteString(@NotNull Source $this$readByteString, int byteCount) {
        Intrinsics.checkNotNullParameter((Object)$this$readByteString, (String)"<this>");
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(SourcesKt.readByteArray($this$readByteString, byteCount));
    }

    public static final long indexOf(@NotNull Source $this$indexOf, @NotNull ByteString byteString, long startIndex) {
        long index;
        Intrinsics.checkNotNullParameter((Object)$this$indexOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        if (!(startIndex >= 0L)) {
            boolean $i$a$-require-ByteStringsKt$indexOf$22 = false;
            String $i$a$-require-ByteStringsKt$indexOf$22 = "startIndex: " + startIndex;
            throw new IllegalArgumentException($i$a$-require-ByteStringsKt$indexOf$22.toString());
        }
        if (ByteStringKt.isEmpty((ByteString)byteString)) {
            return 0L;
        }
        long offset = 0L;
        offset = startIndex;
        Source peek = $this$indexOf.peek();
        if (!$this$indexOf.request(startIndex)) {
            return -1L;
        }
        peek.skip(offset);
        long resultingIndex = 0L;
        resultingIndex = -1L;
        UnsafeByteStringOperations this_$iv = UnsafeByteStringOperations.INSTANCE;
        boolean $i$f$withByteArrayUnsafe = false;
        byte[] data = byteString.getBackingArrayReference();
        boolean bl = false;
        while (!peek.exhausted() && (index = SourcesKt.indexOf$default(peek, data[0], 0L, 0L, 6, null)) != -1L) {
            offset += index;
            peek.skip(index);
            if (!peek.request(byteString.getSize())) break;
            boolean matches = true;
            int n = data.length;
            for (int idx = 0; idx < n; ++idx) {
                if (data[idx] == peek.getBuffer().get(idx)) continue;
                matches = false;
                ++offset;
                peek.skip(1L);
                break;
            }
            if (!matches) continue;
            resultingIndex = offset;
            break;
        }
        return resultingIndex;
    }

    public static /* synthetic */ long indexOf$default(Source source, ByteString byteString, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        return ByteStringsKt.indexOf(source, byteString, l);
    }
}

