/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.ParagraphBuilder;
import androidx.compose.ui.text.platform.ParagraphLayouter_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Density;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.paragraph.Paragraph;
import org.jetbrains.skia.paragraph.ParagraphStyle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u0012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"J\u001b\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b(\u0010)J\u0010\u0010*\u001a\u00020%2\b\u0010+\u001a\u0004\u0018\u00010,J\u0016\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0003JC\u00101\u001a\u00020%2\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\"2\b\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010:H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b;\u0010<J/\u00101\u001a\u00020%2\u0006\u0010=\u001a\u00020>2\b\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010:\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b?\u0010@R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006A"}, d2={"Landroidx/compose/ui/text/platform/ParagraphLayouter;", "", "text", "", "textDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "style", "Landroidx/compose/ui/text/TextStyle;", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "placeholders", "Landroidx/compose/ui/text/Placeholder;", "density", "Landroidx/compose/ui/unit/Density;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "(Ljava/lang/String;Landroidx/compose/ui/text/style/ResolvedTextDirection;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;Ljava/util/List;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/FontFamily$Resolver;)V", "builder", "Landroidx/compose/ui/text/platform/ParagraphBuilder;", "defaultFont", "Lorg/jetbrains/skia/Font;", "getDefaultFont", "()Lorg/jetbrains/skia/Font;", "paragraphCache", "Lorg/jetbrains/skia/paragraph/Paragraph;", "paragraphStyle", "Lorg/jetbrains/skia/paragraph/ParagraphStyle;", "getParagraphStyle", "()Lorg/jetbrains/skia/paragraph/ParagraphStyle;", "getText", "()Ljava/lang/String;", "width", "", "layoutParagraph", "setBlendMode", "", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "setBlendMode-s9anfk8", "(I)V", "setDrawStyle", "drawStyle", "Landroidx/compose/ui/graphics/drawscope/DrawStyle;", "setParagraphStyle", "maxLines", "", "ellipsis", "setTextStyle", "brush", "Landroidx/compose/ui/graphics/Brush;", "brushSize", "Landroidx/compose/ui/geometry/Size;", "alpha", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "setTextStyle-eZhPAX0", "(Landroidx/compose/ui/graphics/Brush;JFLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "color", "Landroidx/compose/ui/graphics/Color;", "setTextStyle-ek8zF_U", "(JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "ui-text"})
@SourceDebugExtension(value={"SMAP\nParagraphLayouter.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphLayouter.skiko.kt\nandroidx/compose/ui/text/platform/ParagraphLayouter\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n*L\n1#1,172:1\n658#2:173\n646#2:174\n159#3:175\n*S KotlinDebug\n*F\n+ 1 ParagraphLayouter.skiko.kt\nandroidx/compose/ui/text/platform/ParagraphLayouter\n*L\n97#1:173\n97#1:174\n121#1:175\n*E\n"})
public final class ParagraphLayouter {
    @NotNull
    private final String text;
    @NotNull
    private final ParagraphBuilder builder;
    @Nullable
    private Paragraph paragraphCache;
    private float width;

    public ParagraphLayouter(@NotNull String text, @NotNull ResolvedTextDirection textDirection, @NotNull TextStyle style, @NotNull List<AnnotatedString.Range<SpanStyle>> spanStyles, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, @NotNull Density density, @NotNull FontFamily.Resolver fontFamilyResolver) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)textDirection), (String)"textDirection");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text;
        this.builder = new ParagraphBuilder(fontFamilyResolver, this.text, style, 0L, null, 0, spanStyles, placeholders, density, textDirection, null, 0, 3128, null);
        this.width = Float.NaN;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final Font getDefaultFont() {
        return this.builder.getDefaultFont$ui_text();
    }

    @NotNull
    public final ParagraphStyle getParagraphStyle() {
        return this.builder.getParagraphStyle$ui_text();
    }

    public final void setParagraphStyle(int maxLines, @NotNull String ellipsis) {
        Intrinsics.checkNotNullParameter((Object)ellipsis, (String)"ellipsis");
        if (this.builder.getMaxLines() != maxLines || !Intrinsics.areEqual((Object)this.builder.getEllipsis(), (Object)ellipsis)) {
            this.builder.setMaxLines(maxLines);
            this.builder.setEllipsis(ellipsis);
            this.paragraphCache = null;
        }
    }

    public final void setTextStyle-ek8zF_U(long color, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration) {
        long l;
        long $this$takeOrElse_u2dDxMtmZc$iv = color;
        boolean bl = false;
        long $this$isSpecified$iv$iv = $this$takeOrElse_u2dDxMtmZc$iv;
        boolean bl2 = false;
        if ($this$isSpecified$iv$iv != Color.Companion.getUnspecified-0d7_KjU()) {
            l = $this$takeOrElse_u2dDxMtmZc$iv;
        } else {
            boolean bl3 = false;
            l = this.builder.getTextStyle().getColor-0d7_KjU();
        }
        long actualColor = l;
        if (!(Color.equals-impl0((long)this.builder.getTextStyle().getColor-0d7_KjU(), (long)actualColor) && Intrinsics.areEqual((Object)this.builder.getTextStyle().getShadow(), (Object)shadow) && Intrinsics.areEqual((Object)this.builder.getTextStyle().getTextDecoration(), (Object)textDecoration))) {
            this.builder.setTextStyle(TextStyle.copy-v2rsoow$default(this.builder.getTextStyle(), actualColor, 0L, null, null, null, null, null, 0L, null, null, null, 0L, textDecoration, shadow, null, null, null, 0L, null, null, null, null, null, null, 0xFFCFFE, null));
            this.paragraphCache = null;
        }
    }

    @ExperimentalTextApi
    public final void setTextStyle-eZhPAX0(@Nullable Brush brush, long brushSize, float alpha, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration) {
        block3: {
            block2: {
                long actualSize = this.builder.getBrushSize-NH-jbRc();
                if (!Intrinsics.areEqual((Object)this.builder.getTextStyle().getBrush(), (Object)brush)) break block2;
                long $this$isUnspecified$iv = actualSize;
                boolean bl = false;
                if (!($this$isUnspecified$iv == Size.Companion.getUnspecified-NH-jbRc()) && ParagraphLayouter_skikoKt.access$sameValueAs(Size.getWidth-impl((long)actualSize), Size.getWidth-impl((long)brushSize)) && ParagraphLayouter_skikoKt.access$sameValueAs(Size.getHeight-impl((long)actualSize), Size.getHeight-impl((long)brushSize)) && ParagraphLayouter_skikoKt.access$sameValueAs(this.builder.getTextStyle().getAlpha(), alpha) && Intrinsics.areEqual((Object)this.builder.getTextStyle().getShadow(), (Object)shadow) && Intrinsics.areEqual((Object)this.builder.getTextStyle().getTextDecoration(), (Object)textDecoration)) break block3;
            }
            this.builder.setTextStyle(TextStyle.copy-aIRg9q4$default(this.builder.getTextStyle(), brush, alpha, 0L, null, null, null, null, null, 0L, null, null, null, 0L, textDecoration, shadow, null, null, null, 0L, null, null, null, null, null, null, 33529852, null));
            this.builder.setBrushSize-uvyYCjk(brushSize);
            this.paragraphCache = null;
        }
    }

    public final void setDrawStyle(@Nullable DrawStyle drawStyle) {
        if (!Intrinsics.areEqual((Object)this.builder.getDrawStyle(), (Object)drawStyle)) {
            this.builder.setDrawStyle(drawStyle);
            this.paragraphCache = null;
        }
    }

    public final void setBlendMode-s9anfk8(int blendMode) {
        if (!BlendMode.equals-impl0((int)this.builder.getBlendMode-0nO6VwU(), (int)blendMode)) {
            this.builder.setBlendMode-s9anfk8(blendMode);
            this.paragraphCache = null;
        }
    }

    @NotNull
    public final Paragraph layoutParagraph(float width) {
        Paragraph paragraph;
        Paragraph paragraph2 = this.paragraphCache;
        if (paragraph2 != null) {
            if (!ParagraphLayouter_skikoKt.access$sameValueAs(this.width, width)) {
                this.width = width;
                paragraph2.layout(width);
            }
            paragraph = paragraph2;
        } else {
            Paragraph paragraph3;
            Paragraph $this$layoutParagraph_u24lambda_u241 = paragraph3 = this.builder.build();
            boolean bl = false;
            this.paragraphCache = $this$layoutParagraph_u24lambda_u241;
            $this$layoutParagraph_u24lambda_u241.layout(width);
            paragraph = paragraph3;
        }
        return paragraph;
    }
}

