/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.core.midi;

import com.moppy.core.midi.MoppyMIDIReceiverSender;
import com.moppy.core.status.StatusBus;
import com.moppy.core.status.StatusUpdate;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class MoppyMIDISequencer
implements MetaEventListener,
Closeable {
    private static final Logger LOG = Logger.getLogger(MoppyMIDISequencer.class.getName());
    private final Sequencer seq;
    private final StatusBus statusBus;
    private boolean autoReset = false;

    public MoppyMIDISequencer(StatusBus statusBus, MoppyMIDIReceiverSender receiverSender) throws MidiUnavailableException {
        this.statusBus = statusBus;
        this.statusBus.registerConsumer(receiverSender);
        this.seq = MidiSystem.getSequencer(false);
        this.seq.open();
        this.seq.getTransmitter().setReceiver(receiverSender);
        this.seq.addMetaEventListener(this);
    }

    @Override
    public void close() throws IOException {
        this.seq.close();
    }

    @Override
    public void meta(MetaMessage meta) {
        if (meta.getType() == 81) {
            int uSecondsPerQN = 0;
            uSecondsPerQN |= meta.getData()[0] & 0xFF;
            uSecondsPerQN <<= 8;
            uSecondsPerQN |= meta.getData()[1] & 0xFF;
            uSecondsPerQN <<= 8;
            int newTempo = 60000000 / (uSecondsPerQN |= meta.getData()[2] & 0xFF);
            this.setTempo(newTempo);
        } else if (meta.getType() == 47) {
            this.seq.setTickPosition(0L);
            this.statusBus.receiveUpdate(StatusUpdate.sequenceEnd(this.autoReset));
        }
    }

    public void play() {
        this.seq.start();
        this.statusBus.receiveUpdate(StatusUpdate.SEQUENCE_START);
    }

    public void pause() {
        this.seq.stop();
        this.statusBus.receiveUpdate(StatusUpdate.SEQUENCE_PAUSE);
    }

    public void stop() {
        this.seq.stop();
        this.seq.setTickPosition(0L);
        this.statusBus.receiveUpdate(StatusUpdate.SEQUENCE_STOPPED);
    }

    public boolean isPlaying() {
        return this.seq.isRunning();
    }

    public void loadSequence(File sequenceFile) throws IOException, InvalidMidiDataException {
        if (!sequenceFile.isFile()) {
            throw new IOException(String.format("File '%s' not found, or isn't a file", sequenceFile.getAbsolutePath()));
        }
        Sequence sequenceToLoad = MidiSystem.getSequence(sequenceFile);
        this.seq.setSequence(sequenceToLoad);
        this.statusBus.receiveUpdate(StatusUpdate.sequenceLoaded(sequenceToLoad));
        this.statusBus.receiveUpdate(StatusUpdate.tempoChange(this.seq.getTempoInBPM()));
        LOG.info(String.format("Loaded sequence with %s tracks at %s BMP", sequenceToLoad.getTracks().length - 1, Float.valueOf(this.seq.getTempoInBPM())));
    }

    public boolean isSequenceLoaded() {
        return this.seq.getSequence() != null;
    }

    public long getSecondsLength() {
        return TimeUnit.SECONDS.convert(this.seq.getMicrosecondLength(), TimeUnit.MICROSECONDS);
    }

    public long getSecondsPosition() {
        return TimeUnit.SECONDS.convert(this.seq.getMicrosecondPosition(), TimeUnit.MICROSECONDS);
    }

    public void setSecondsPosition(long seconds) {
        this.seq.setMicrosecondPosition(TimeUnit.SECONDS.toMicros(seconds));
    }

    public void setTempo(float newTempo) {
        if (this.seq.getTempoInBPM() != newTempo) {
            this.seq.setTempoInBPM(newTempo);
            this.statusBus.receiveUpdate(StatusUpdate.tempoChange(newTempo));
            LOG.info(String.format("Tempo changed to %s", Float.valueOf(newTempo)));
        }
    }

    public void setAutoReset(boolean autoReset) {
        this.autoReset = autoReset;
    }
}

