/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.core.events.mapper;

import com.moppy.core.comms.MoppyMessage;
import com.moppy.core.comms.MoppyMessageFactory;
import com.moppy.core.events.mapper.MIDIEventMapper;
import com.moppy.core.events.mapper.scripts.ConditionScripts;
import com.moppy.core.events.mapper.scripts.DeviceAddressScripts;
import com.moppy.core.events.mapper.scripts.NoteScripts;
import com.moppy.core.events.mapper.scripts.SubAddressScripts;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;

public class MIDIScriptMapper
extends MIDIEventMapper {
    private static final Context SCRIPT_CONTEXT = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.ALL).build();
    private final Value localBindings = SCRIPT_CONTEXT.getBindings("js");
    private final HashMap<Integer, Integer> currentNotes = new HashMap();
    private int nextOpenRoundRobinSubAddress = 0;
    private String conditionScript = ConditionScripts.ALL_EVENTS.toString();
    private String deviceAddressScript = DeviceAddressScripts.DEVICE_ONE.toString();
    private String subAddressScript = SubAddressScripts.SUB_ADDRESS_PER_CHANNEL.toString();
    private String noteScript = NoteScripts.STRAIGHT_THROUGH.toString();

    private void setDefaultBindings() {
        this.localBindings.putMember("c", (Object)0);
        this.localBindings.putMember("n", (Object)60);
        this.localBindings.putMember("v", (Object)127);
        this.localBindings.putMember("midiCommand", (Object)144);
    }

    private void setLowBindings() {
        this.localBindings.putMember("c", (Object)0);
        this.localBindings.putMember("n", (Object)0);
        this.localBindings.putMember("v", (Object)1);
    }

    private void setHighBindings() {
        this.localBindings.putMember("c", (Object)15);
        this.localBindings.putMember("n", (Object)127);
        this.localBindings.putMember("v", (Object)127);
    }

    public MIDIScriptMapper() {
        this.setDefaultBindings();
        this.localBindings.putMember("nextRoundRobinSubAddress", this::nextRoundRobinSubAddress);
    }

    @Override
    public MoppyMessage mapEvent(MidiMessage event) {
        SysexMessage sysexMessage;
        if (event instanceof ShortMessage) {
            ShortMessage midiMessage = (ShortMessage)event;
            this.localBindings.putMember("c", (Object)midiMessage.getChannel());
            this.localBindings.putMember("midiCommand", (Object)midiMessage.getCommand());
            if (midiMessage.getCommand() == 144 || midiMessage.getCommand() == 128) {
                this.localBindings.putMember("n", (Object)midiMessage.getData1());
                this.localBindings.putMember("v", (Object)midiMessage.getData2());
            }
            try {
                if (!this.resolveCondition()) {
                    return null;
                }
                switch (midiMessage.getCommand()) {
                    case 144: {
                        if (midiMessage.getData2() == 0) {
                            return MoppyMessageFactory.deviceStopNote(this.resolveDeviceId(), this.resolveSubAddress(), this.resolveNote());
                        }
                        return MoppyMessageFactory.devicePlayNote(this.resolveDeviceId(), this.resolveSubAddress(), this.resolveNote(), (byte)midiMessage.getData2());
                    }
                    case 128: {
                        return MoppyMessageFactory.deviceStopNote(this.resolveDeviceId(), this.resolveSubAddress(), this.resolveNote());
                    }
                    case 224: {
                        short pitchBend = (short)((midiMessage.getData2() << 7) + midiMessage.getData1() - 8192);
                        return MoppyMessageFactory.devicePitchBend(this.resolveDeviceId(), this.resolveSubAddress(), pitchBend);
                    }
                }
            }
            catch (ClassCastException | PolyglotException ex) {
                Logger.getLogger(MIDIScriptMapper.class.getName()).log(Level.WARNING, null, ex);
            }
        } else if (event instanceof SysexMessage && (sysexMessage = (SysexMessage)event).getData()[0] == 77) {
            return MoppyMessageFactory.fromBytes(Arrays.copyOf(sysexMessage.getData(), sysexMessage.getData().length - 1));
        }
        return null;
    }

    private boolean resolveCondition() throws PolyglotException {
        return SCRIPT_CONTEXT.eval("js", (CharSequence)this.conditionScript).asBoolean();
    }

    private byte resolveDeviceId() throws PolyglotException {
        return SCRIPT_CONTEXT.eval("js", (CharSequence)this.deviceAddressScript).asByte();
    }

    private byte resolveSubAddress() throws PolyglotException {
        return SCRIPT_CONTEXT.eval("js", (CharSequence)this.subAddressScript).asByte();
    }

    private byte resolveNote() throws PolyglotException {
        return SCRIPT_CONTEXT.eval("js", (CharSequence)this.noteScript).asByte();
    }

    public String getConditionScript() {
        return this.conditionScript;
    }

    public String getDeviceAddressScript() {
        return this.deviceAddressScript;
    }

    public String getSubAddressScript() {
        return this.subAddressScript;
    }

    public String getNoteScript() {
        return this.noteScript;
    }

    public void setConditionScript(String conditionScript) throws PolyglotException, NullPointerException {
        this.setDefaultBindings();
        boolean checkOutput = SCRIPT_CONTEXT.eval("js", (CharSequence)conditionScript).asBoolean();
        this.setLowBindings();
        checkOutput = SCRIPT_CONTEXT.eval("js", (CharSequence)conditionScript).asBoolean();
        this.setHighBindings();
        checkOutput = SCRIPT_CONTEXT.eval("js", (CharSequence)conditionScript).asBoolean();
        this.conditionScript = conditionScript;
    }

    public void setDeviceAddressScript(String deviceAddressScript) throws PolyglotException, NullPointerException {
        this.setDefaultBindings();
        byte checkOutput = SCRIPT_CONTEXT.eval("js", (CharSequence)deviceAddressScript).asByte();
        this.setLowBindings();
        checkOutput = SCRIPT_CONTEXT.eval("js", (CharSequence)deviceAddressScript).asByte();
        this.setHighBindings();
        checkOutput = SCRIPT_CONTEXT.eval("js", (CharSequence)deviceAddressScript).asByte();
        this.deviceAddressScript = deviceAddressScript;
    }

    public void setSubAddressScript(String subAddressScript) throws PolyglotException, NullPointerException {
        this.setDefaultBindings();
        byte checkOutput = SCRIPT_CONTEXT.eval("js", (CharSequence)subAddressScript).asByte();
        this.setLowBindings();
        checkOutput = SCRIPT_CONTEXT.eval("js", (CharSequence)subAddressScript).asByte();
        this.setHighBindings();
        checkOutput = SCRIPT_CONTEXT.eval("js", (CharSequence)subAddressScript).asByte();
        this.subAddressScript = subAddressScript;
    }

    public void setNoteScript(String noteScript) throws PolyglotException, NullPointerException {
        this.setDefaultBindings();
        byte checkOutput = SCRIPT_CONTEXT.eval("js", (CharSequence)noteScript).asByte();
        this.setLowBindings();
        checkOutput = SCRIPT_CONTEXT.eval("js", (CharSequence)noteScript).asByte();
        this.setHighBindings();
        checkOutput = SCRIPT_CONTEXT.eval("js", (CharSequence)noteScript).asByte();
        this.noteScript = noteScript;
    }

    private int nextRoundRobinSubAddress(Integer numberOfChannels) {
        int incomingNote = this.localBindings.getMember("n").asInt();
        if (this.localBindings.getMember("midiCommand").asInt() == 144) {
            this.nextOpenRoundRobinSubAddress = this.nextOpenRoundRobinSubAddress % numberOfChannels + 1;
            this.currentNotes.put(this.nextOpenRoundRobinSubAddress, incomingNote);
            return this.nextOpenRoundRobinSubAddress;
        }
        if (this.localBindings.getMember("midiCommand").asInt() == 128 && this.currentNotes.containsValue(incomingNote)) {
            int subAddressToTurnOff = numberOfChannels + 1;
            for (Map.Entry<Integer, Integer> e : this.currentNotes.entrySet()) {
                if (!e.getValue().equals(incomingNote)) continue;
                subAddressToTurnOff = e.getKey();
                break;
            }
            this.currentNotes.remove(subAddressToTurnOff);
            return subAddressToTurnOff;
        }
        return numberOfChannels + 1;
    }
}

