/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.core.device;

import com.moppy.core.comms.MoppyMessage;

public abstract class MoppyDevice {
    public abstract boolean matchesAddress(byte var1, byte var2);

    public void handleMessage(MoppyMessage incommingMessage) {
        if (incommingMessage.isSystemMessage()) {
            switch (incommingMessage.getMessageCommandByte()) {
                case -128: {
                    this.gotSystemPing();
                    break;
                }
                case -126: {
                    this.systemReset();
                }
            }
        } else if (this.matchesAddress(incommingMessage.getDeviceAddress(), incommingMessage.getSubAddress())) {
            switch (incommingMessage.getMessageCommandByte()) {
                case 0: {
                    this.deviceReset(incommingMessage.getDeviceAddress(), incommingMessage.getSubAddress());
                    break;
                }
                case 9: {
                    this.devicePlayNote(incommingMessage.getDeviceAddress(), incommingMessage.getSubAddress(), incommingMessage.getMessageCommandPayload()[0]);
                    break;
                }
                case 8: {
                    this.deviceStopNote(incommingMessage.getDeviceAddress(), incommingMessage.getSubAddress(), incommingMessage.getMessageCommandPayload()[0]);
                    break;
                }
                case 14: {
                    this.deviceBendPitch(incommingMessage.getDeviceAddress(), incommingMessage.getSubAddress(), (short)(incommingMessage.getMessageCommandPayload()[0] << 8 | incommingMessage.getMessageCommandPayload()[1]));
                }
            }
        }
    }

    public void gotSystemPing() {
    }

    public void systemReset() {
    }

    public void deviceReset(byte deviceAddress, byte subAddress) {
    }

    public void devicePlayNote(byte deviceAddress, byte subAddress, byte noteNumber) {
    }

    public void deviceStopNote(byte deviceAddress, byte subAddress, byte noteNumber) {
    }

    public void deviceBendPitch(byte deviceAddress, byte subAddress, short bendAmount) {
    }
}

