/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.core.comms.bridge;

import com.moppy.core.comms.MoppyMessage;
import com.moppy.core.comms.MoppyMessageFactory;
import com.moppy.core.comms.NetworkMessageConsumer;
import com.moppy.core.comms.NetworkReceivedMessage;
import com.moppy.core.comms.bridge.MultiBridge;
import com.moppy.core.comms.bridge.NetworkBridge;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BridgeUDP
extends NetworkBridge<Object> {
    private static final int MOPPY_PORT = 30994;
    private InetAddress groupAddress = InetAddress.getByName("239.2.2.7");
    private MulticastSocket socket;
    private Thread listenerThread = null;

    @Override
    public void connect() throws IOException {
        this.socket = new MulticastSocket(30994);
        this.socket.joinGroup(this.groupAddress);
        UDPListener listener = new UDPListener(this.socket, this);
        this.listenerThread = new Thread(listener);
        this.listenerThread.start();
    }

    @Override
    public void connect(Object connectionOption) throws IOException {
        this.connect();
    }

    @Override
    public void sendMessage(MoppyMessage messageToSend) throws IOException {
        if (this.socket == null) {
            Logger.getLogger(MultiBridge.class.getName()).log(Level.FINE, "UDP Socket null or not connected");
            return;
        }
        DatagramPacket dgp = new DatagramPacket(messageToSend.getMessageBytes(), messageToSend.getMessageBytes().length, this.groupAddress, 30994);
        this.socket.send(dgp);
    }

    @Override
    public void close() throws IOException {
        try {
            this.sendMessage(MoppyMessage.SYS_STOP);
            this.socket.leaveGroup(this.groupAddress);
        }
        finally {
            this.socket.close();
            this.socket = null;
            this.listenerThread.interrupt();
            this.listenerThread = null;
        }
    }

    @Override
    public String getNetworkIdentifier() {
        return String.format("%s:%s", this.groupAddress.getHostAddress(), 30994);
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && !this.socket.isClosed();
    }

    @Override
    public List<Object> getConnectionOptions() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Object currentConnectionOption() {
        return null;
    }

    private class UDPListener
    implements Runnable {
        private final NetworkMessageConsumer messageConsumer;
        private final MulticastSocket socket;

        public UDPListener(MulticastSocket socket, NetworkMessageConsumer messageConsumer) {
            this.socket = socket;
            this.messageConsumer = messageConsumer;
        }

        @Override
        public void run() {
            DatagramPacket bufferPacket = new DatagramPacket(new byte[259], 259);
            while (!this.socket.isClosed() && !Thread.interrupted()) {
                try {
                    this.socket.receive(bufferPacket);
                    byte[] packetData = bufferPacket.getData();
                    if (packetData.length <= 0 || packetData[0] != 77) continue;
                    NetworkReceivedMessage receivedMessage = MoppyMessageFactory.networkReceivedFromBytes(packetData, BridgeUDP.class.getName(), BridgeUDP.this.getNetworkIdentifier(), bufferPacket.getAddress().getHostAddress());
                    this.messageConsumer.acceptNetworkMessage(receivedMessage);
                }
                catch (IOException ex) {
                    Logger.getLogger(BridgeUDP.class.getName()).log(Level.WARNING, null, ex);
                }
            }
        }
    }
}

