/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.core.comms;

import java.util.Arrays;

public class MoppyMessage {
    private final byte[] messageBytes;
    public static final byte START_BYTE = 77;
    public static final byte SYSTEM_ADDRESS = 0;
    public static final MoppyMessage SYS_PING = new MoppyMessage(new byte[]{77, 0, 0, 1, CommandByte.SYS_PING});
    public static final MoppyMessage SYS_RESET = new MoppyMessage(new byte[]{77, 0, 0, 1, CommandByte.SYS_RESET});
    public static final MoppyMessage SYS_START = new MoppyMessage(new byte[]{77, 0, 0, 1, CommandByte.SYS_START});
    public static final MoppyMessage SYS_STOP = new MoppyMessage(new byte[]{77, 0, 0, 1, CommandByte.SYS_STOP});

    protected MoppyMessage(byte[] messageBytes) {
        if (messageBytes.length < 5) {
            throw new IllegalArgumentException("Not enough bytes for a MoppyMessage!");
        }
        this.messageBytes = messageBytes;
    }

    public byte[] getMessageBytes() {
        return this.messageBytes;
    }

    public byte getDeviceAddress() {
        return this.messageBytes[1];
    }

    public boolean isSystemMessage() {
        return this.getDeviceAddress() == 0;
    }

    public byte getSubAddress() {
        if (this.isSystemMessage()) {
            throw new IllegalStateException("This is a system message and has no sub-address");
        }
        return this.messageBytes[2];
    }

    public byte[] getMessageBody() {
        byte bodyLength = this.messageBytes[3];
        return Arrays.copyOfRange(this.messageBytes, 4, 4 + bodyLength);
    }

    public byte getMessageCommandByte() {
        return this.getMessageBody()[0];
    }

    public byte[] getMessageCommandPayload() {
        return Arrays.copyOfRange(this.getMessageBody(), 1, this.getMessageBody().length);
    }

    public static class CommandByte {
        public static byte SYS_PING = (byte)-128;
        public static byte SYS_PONG = (byte)-127;
        public static byte SYS_RESET = (byte)-1;
        public static byte SYS_START = (byte)-6;
        public static byte SYS_STOP = (byte)-4;
        public static byte DEV_RESET = 0;
        public static byte DEV_PLAYNOTE = (byte)9;
        public static byte DEV_STOPNOTE = (byte)8;
        public static byte DEV_BENDPITCH = (byte)14;
    }
}

