/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.control.gui.netpanel;

import com.moppy.control.NetworkManager;
import com.moppy.core.comms.bridge.NetworkBridge;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class BridgePanel
extends JPanel {
    private final NetworkManager netManager;
    private JCheckBox bridgeCheckBox;
    private JComboBox<String> connectionOptionCB;

    public BridgePanel(NetworkManager netManager, String bridgeIdentifier, NetworkBridge netBridge) {
        this.netManager = netManager;
        this.initComponents();
        this.bridgeCheckBox.setText(bridgeIdentifier);
        this.bridgeCheckBox.setSelected(netBridge.isConnected());
        if (!netBridge.getConnectionOptions().isEmpty()) {
            this.connectionOptionCB.setEnabled(!netBridge.isConnected());
            this.connectionOptionCB.setModel(new DefaultComboBoxModel<Object>(netBridge.getConnectionOptions().toArray()));
            this.connectionOptionCB.setSelectedItem(netBridge.currentConnectionOption());
        } else {
            this.connectionOptionCB.setVisible(false);
        }
    }

    private void initComponents() {
        this.bridgeCheckBox = new JCheckBox();
        this.connectionOptionCB = new JComboBox();
        this.bridgeCheckBox.setText("netBridge");
        this.bridgeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BridgePanel.this.bridgeCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.bridgeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectionOptionCB, -2, 80, -2).addContainerGap(25, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bridgeCheckBox).addComponent(this.connectionOptionCB, -2, -1, -2)));
    }

    private void bridgeCheckBoxActionPerformed(ActionEvent evt) {
        try {
            if (this.bridgeCheckBox.isSelected()) {
                this.netManager.connectBridge(this.bridgeCheckBox.getText(), this.connectionOptionCB.getSelectedItem());
            } else {
                this.netManager.closeBridge(this.bridgeCheckBox.getText());
            }
        }
        catch (IOException ex) {
            Logger.getLogger(BridgePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

