/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.control.gui.mapperpanel;

import com.moppy.control.config.MoppyConfig;
import com.moppy.control.gui.mapperpanel.MapperCollectionPanel;
import com.moppy.core.events.mapper.MIDIScriptMapper;
import com.moppy.core.events.mapper.scripts.ConditionScripts;
import com.moppy.core.events.mapper.scripts.DeviceAddressScripts;
import com.moppy.core.events.mapper.scripts.NoteScripts;
import com.moppy.core.events.mapper.scripts.SubAddressScripts;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.graalvm.polyglot.PolyglotException;

public class MapperPanel
extends JPanel {
    private final MIDIScriptMapper mapper;
    private final MapperCollectionPanel mapperPanel;
    private final MoppyConfig.MIDIScriptMapperConfig mapperConfig;
    private static final Map<String, String> CONDITION_MAP = new HashMap<String, String>();
    private static final Map<String, String> DEVICEADDRESS_MAP = new HashMap<String, String>();
    private static final Map<String, String> SUBADDRESS_MAP = new HashMap<String, String>();
    private static final Map<String, String> NOTE_MAP = new HashMap<String, String>();
    private JComboBox<String> conditionComboBox;
    private JTextArea conditionTextArea;
    private JButton deleteMapperButton;
    private JComboBox<String> deviceAddressComboBox;
    private JTextArea deviceAddressTextArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JComboBox<String> noteComboBox;
    private JTextArea noteTextArea;
    private JComboBox<String> subAddressComboBox;
    private JTextArea subAddressTextArea;

    public MapperPanel(MIDIScriptMapper mapper, MoppyConfig.MIDIScriptMapperConfig config, MapperCollectionPanel mapperPanel) {
        this.mapperConfig = config;
        this.mapper = mapper;
        this.mapperPanel = mapperPanel;
        this.initComponents();
        this.setSize(995, 250);
        this.conditionComboBox.setSelectedItem(this.mapperConfig.getConditionChoice());
        this.deviceAddressComboBox.setSelectedItem(this.mapperConfig.getDeviceAddressChoice());
        this.subAddressComboBox.setSelectedItem(this.mapperConfig.getSubAddressChoice());
        this.noteComboBox.setSelectedItem(this.mapperConfig.getNoteChoice());
    }

    public MIDIScriptMapper getMapper() {
        return this.mapper;
    }

    public MoppyConfig.MIDIScriptMapperConfig getMapperConfig() {
        this.mapperConfig.setConditionChoice(this.conditionComboBox.getSelectedItem().toString());
        this.mapperConfig.setDeviceAddressChoice(this.deviceAddressComboBox.getSelectedItem().toString());
        this.mapperConfig.setSubAddressChoice(this.subAddressComboBox.getSelectedItem().toString());
        this.mapperConfig.setNoteChoice(this.noteComboBox.getSelectedItem().toString());
        return this.mapperConfig;
    }

    public void enableEditing(boolean enable) {
        this.conditionTextArea.setEditable(enable);
        this.conditionComboBox.setEnabled(enable);
        this.deviceAddressTextArea.setEditable(enable);
        this.deviceAddressComboBox.setEnabled(enable);
        this.subAddressTextArea.setEditable(enable);
        this.subAddressComboBox.setEnabled(enable);
        this.noteTextArea.setEditable(enable);
        this.noteComboBox.setEnabled(enable);
        this.deleteMapperButton.setEnabled(enable);
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.deleteMapperButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.conditionTextArea = new JTextArea();
        this.conditionComboBox = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.deviceAddressTextArea = new JTextArea();
        this.deviceAddressComboBox = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.subAddressTextArea = new JTextArea();
        this.subAddressComboBox = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.noteTextArea = new JTextArea();
        this.noteComboBox = new JComboBox();
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(102, 102, 102)));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 165));
        this.setPreferredSize(new Dimension(995, 245));
        this.setLayout(new GridBagLayout());
        this.jPanel5.setMinimumSize(new Dimension(0, 31));
        this.jPanel5.setPreferredSize(new Dimension(992, 43));
        this.deleteMapperButton.setFont(this.deleteMapperButton.getFont().deriveFont((float)this.deleteMapperButton.getFont().getSize() + 7.0f));
        this.deleteMapperButton.setText("\ud83d\uddd1");
        this.deleteMapperButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapperPanel.this.deleteMapperButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap(937, Short.MAX_VALUE).addComponent(this.deleteMapperButton).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.deleteMapperButton).addContainerGap(12, Short.MAX_VALUE)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel1.setPreferredSize(new Dimension(100, 100));
        this.jLabel1.setText("Condition");
        this.conditionTextArea.setColumns(20);
        this.conditionTextArea.setRows(5);
        this.conditionTextArea.setText(this.mapper.getConditionScript());
        this.conditionTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MapperPanel.this.conditionTextAreaFocusLost(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.conditionTextArea);
        this.conditionComboBox.setModel(new DefaultComboBoxModel<Object>(CONDITION_MAP.keySet().toArray()));
        this.conditionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapperPanel.this.conditionComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 80, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.conditionComboBox, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.conditionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel2.setText("Device Address");
        this.deviceAddressTextArea.setColumns(20);
        this.deviceAddressTextArea.setRows(5);
        this.deviceAddressTextArea.setText(this.mapper.getDeviceAddressScript());
        this.deviceAddressTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MapperPanel.this.deviceAddressTextAreaFocusLost(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.deviceAddressTextArea);
        this.deviceAddressComboBox.setModel(new DefaultComboBoxModel<Object>(DEVICEADDRESS_MAP.keySet().toArray()));
        this.deviceAddressComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapperPanel.this.deviceAddressComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 405, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deviceAddressComboBox, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.deviceAddressComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel3.setText("Sub Address");
        this.subAddressTextArea.setColumns(20);
        this.subAddressTextArea.setRows(5);
        this.subAddressTextArea.setText(this.mapper.getSubAddressScript());
        this.subAddressTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MapperPanel.this.subAddressTextAreaFocusLost(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.subAddressTextArea);
        this.subAddressComboBox.setModel(new DefaultComboBoxModel<Object>(SUBADDRESS_MAP.keySet().toArray()));
        this.subAddressComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapperPanel.this.subAddressComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -1, 245, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subAddressComboBox, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.subAddressComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jLabel4.setText("Note");
        this.noteTextArea.setColumns(20);
        this.noteTextArea.setRows(5);
        this.noteTextArea.setText(this.mapper.getNoteScript());
        this.noteTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MapperPanel.this.noteTextAreaFocusLost(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.noteTextArea);
        this.noteComboBox.setModel(new DefaultComboBoxModel<Object>(NOTE_MAP.keySet().toArray()));
        this.noteComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapperPanel.this.noteComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 182, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noteComboBox, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.noteComboBox, -2, -1, -2)).addGap(4, 4, 4).addComponent(this.jScrollPane5).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel4, gridBagConstraints);
    }

    private void deleteMapperButtonActionPerformed(ActionEvent evt) {
        this.mapperPanel.removeMapper(this);
    }

    private void conditionTextAreaFocusLost(FocusEvent evt) {
        try {
            this.mapper.setConditionScript(this.conditionTextArea.getText());
            this.mapperConfig.setConditionCustomScript(this.conditionTextArea.getText());
            this.conditionTextArea.setForeground(Color.BLACK);
        }
        catch (NullPointerException | PolyglotException ex) {
            Logger.getLogger(MapperPanel.class.getName()).log(Level.WARNING, null, ex);
            this.conditionTextArea.setForeground(Color.RED);
        }
    }

    private void deviceAddressTextAreaFocusLost(FocusEvent evt) {
        try {
            this.mapper.setDeviceAddressScript(this.deviceAddressTextArea.getText());
            this.mapperConfig.setDeviceAddressCustomScript(this.deviceAddressTextArea.getText());
            this.deviceAddressTextArea.setForeground(Color.BLACK);
        }
        catch (NullPointerException | PolyglotException ex) {
            Logger.getLogger(MapperPanel.class.getName()).log(Level.WARNING, null, ex);
            this.deviceAddressTextArea.setForeground(Color.RED);
        }
    }

    private void subAddressTextAreaFocusLost(FocusEvent evt) {
        try {
            this.mapper.setSubAddressScript(this.subAddressTextArea.getText());
            this.mapperConfig.setSubAddressCustomScript(this.subAddressTextArea.getText());
            this.subAddressTextArea.setForeground(Color.BLACK);
        }
        catch (NullPointerException | PolyglotException ex) {
            Logger.getLogger(MapperPanel.class.getName()).log(Level.WARNING, null, ex);
            this.subAddressTextArea.setForeground(Color.RED);
        }
    }

    private void noteTextAreaFocusLost(FocusEvent evt) {
        try {
            this.mapper.setNoteScript(this.noteTextArea.getText());
            this.mapperConfig.setNoteCustomScript(this.noteTextArea.getText());
            this.noteTextArea.setForeground(Color.BLACK);
        }
        catch (NullPointerException | PolyglotException ex) {
            Logger.getLogger(MapperPanel.class.getName()).log(Level.WARNING, null, ex);
            this.noteTextArea.setForeground(Color.RED);
        }
    }

    private void setTextAreaEditable(JTextArea textArea, boolean enabled) {
        textArea.setEditable(enabled);
        textArea.setBackground(enabled ? Color.WHITE : Color.LIGHT_GRAY);
    }

    private void conditionComboBoxActionPerformed(ActionEvent evt) {
        if (this.conditionComboBox.getSelectedItem().equals("Custom")) {
            this.conditionTextArea.setText(this.mapperConfig.getConditionCustomScript());
            this.setTextAreaEditable(this.conditionTextArea, true);
        } else {
            this.setTextAreaEditable(this.conditionTextArea, false);
            this.conditionTextArea.setText(CONDITION_MAP.get(this.conditionComboBox.getSelectedItem().toString()));
        }
        try {
            this.mapper.setConditionScript(this.conditionTextArea.getText());
        }
        catch (NullPointerException | PolyglotException ex) {
            Logger.getLogger(MapperPanel.class.getName()).log(Level.WARNING, null, ex);
            this.noteTextArea.setForeground(Color.RED);
        }
    }

    private void deviceAddressComboBoxActionPerformed(ActionEvent evt) {
        if (this.deviceAddressComboBox.getSelectedItem().equals("Custom")) {
            this.deviceAddressTextArea.setText(this.mapperConfig.getDeviceAddressCustomScript());
            this.setTextAreaEditable(this.deviceAddressTextArea, true);
        } else {
            this.setTextAreaEditable(this.deviceAddressTextArea, false);
            this.deviceAddressTextArea.setText(DEVICEADDRESS_MAP.get(this.deviceAddressComboBox.getSelectedItem().toString()));
        }
        try {
            this.mapper.setDeviceAddressScript(this.deviceAddressTextArea.getText());
        }
        catch (NullPointerException | PolyglotException ex) {
            Logger.getLogger(MapperPanel.class.getName()).log(Level.WARNING, null, ex);
            this.noteTextArea.setForeground(Color.RED);
        }
    }

    private void subAddressComboBoxActionPerformed(ActionEvent evt) {
        if (this.subAddressComboBox.getSelectedItem().equals("Custom")) {
            this.subAddressTextArea.setText(this.mapperConfig.getSubAddressCustomScript());
            this.setTextAreaEditable(this.subAddressTextArea, true);
        } else {
            this.setTextAreaEditable(this.subAddressTextArea, false);
            this.subAddressTextArea.setText(SUBADDRESS_MAP.get(this.subAddressComboBox.getSelectedItem().toString()));
        }
        try {
            this.mapper.setSubAddressScript(this.subAddressTextArea.getText());
        }
        catch (NullPointerException | PolyglotException ex) {
            Logger.getLogger(MapperPanel.class.getName()).log(Level.WARNING, null, ex);
            this.noteTextArea.setForeground(Color.RED);
        }
    }

    private void noteComboBoxActionPerformed(ActionEvent evt) {
        if (this.noteComboBox.getSelectedItem().equals("Custom")) {
            this.noteTextArea.setText(this.mapperConfig.getNoteCustomScript());
            this.setTextAreaEditable(this.noteTextArea, true);
        } else {
            this.setTextAreaEditable(this.noteTextArea, false);
            this.noteTextArea.setText(NOTE_MAP.get(this.noteComboBox.getSelectedItem().toString()));
        }
        try {
            this.mapper.setNoteScript(this.noteTextArea.getText());
        }
        catch (NullPointerException | PolyglotException ex) {
            Logger.getLogger(MapperPanel.class.getName()).log(Level.WARNING, null, ex);
            this.noteTextArea.setForeground(Color.RED);
        }
    }

    static {
        CONDITION_MAP.put(ConditionScripts.ALL_EVENTS.displayName(), ConditionScripts.ALL_EVENTS.toString());
        CONDITION_MAP.put(ConditionScripts.CHANNELS_ONE_TO_FOUR.displayName(), ConditionScripts.CHANNELS_ONE_TO_FOUR.toString());
        CONDITION_MAP.put(ConditionScripts.ONLY_SUPPORTED_NOTES.displayName(), ConditionScripts.ONLY_SUPPORTED_NOTES.toString());
        CONDITION_MAP.put("Custom", "");
        DEVICEADDRESS_MAP.put(DeviceAddressScripts.DEVICE_ONE.displayName(), DeviceAddressScripts.DEVICE_ONE.toString());
        DEVICEADDRESS_MAP.put(DeviceAddressScripts.ONE_DEVICE_PER_CHANNEL.displayName(), DeviceAddressScripts.ONE_DEVICE_PER_CHANNEL.toString());
        DEVICEADDRESS_MAP.put("Custom", "");
        SUBADDRESS_MAP.put(SubAddressScripts.SUB_ADDRESS_PER_CHANNEL.displayName(), SubAddressScripts.SUB_ADDRESS_PER_CHANNEL.toString());
        SUBADDRESS_MAP.put(SubAddressScripts.ROUND_ROBIN.displayName(), SubAddressScripts.ROUND_ROBIN.toString());
        SUBADDRESS_MAP.put("Custom", "");
        NOTE_MAP.put(NoteScripts.FORCE_INTO_RANGE.displayName(), NoteScripts.FORCE_INTO_RANGE.toString());
        NOTE_MAP.put(NoteScripts.STRAIGHT_THROUGH.displayName(), NoteScripts.STRAIGHT_THROUGH.toString());
        NOTE_MAP.put("Custom", "");
    }
}

