/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.control.gui.mapperpanel;

import com.moppy.control.MoppyPreferences;
import com.moppy.control.config.MoppyConfig;
import com.moppy.control.gui.mapperpanel.MapperPanel;
import com.moppy.core.events.mapper.EventMapper;
import com.moppy.core.events.mapper.MIDIScriptMapper;
import com.moppy.core.events.mapper.MapperCollection;
import com.moppy.core.status.StatusConsumer;
import com.moppy.core.status.StatusUpdate;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sound.midi.MidiMessage;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class MapperCollectionPanel
extends JPanel
implements StatusConsumer {
    private MapperCollection<MidiMessage> mappers;
    private JButton addMapperButton;

    public MapperCollectionPanel() {
        this.initComponents();
    }

    public void initMapperCollectionPanel(MapperCollection<MidiMessage> mappers) {
        this.mappers = mappers;
        this.loadMappersFromConfig(MoppyPreferences.getConfiguration().getMapperConfigs());
    }

    public void loadMappersFromConfig(List<MoppyConfig.MIDIScriptMapperConfig> configList) {
        this.mappers.clearMappers();
        configList.stream().forEach(config -> this.addNewMapper((MoppyConfig.MIDIScriptMapperConfig)config));
    }

    public void saveMappersToConfig() {
        List<MoppyConfig.MIDIScriptMapperConfig> configList = Stream.of(this.getComponents()).filter(c -> c instanceof MapperPanel).map(mp -> {
            MapperPanel panel = (MapperPanel)mp;
            return ((MapperPanel)mp).getMapperConfig();
        }).collect(Collectors.toList());
        MoppyPreferences.getConfiguration().setMapperConfigs(configList);
        MoppyPreferences.saveConfiguration();
    }

    private void addNewMapper(MoppyConfig.MIDIScriptMapperConfig mapperConfig) {
        MIDIScriptMapper newMapper = new MIDIScriptMapper();
        this.mappers.addMapper((EventMapper)newMapper);
        this.add(new MapperPanel(newMapper, mapperConfig, this));
        this.revalidate();
        this.repaint();
    }

    private void addNewMapper() {
        this.addNewMapper(new MoppyConfig.MIDIScriptMapperConfig());
    }

    protected void removeMapper(MapperPanel panelBeingRemoved) {
        this.mappers.removeMapper((EventMapper)panelBeingRemoved.getMapper());
        this.remove(panelBeingRemoved);
        this.repaint();
    }

    private void enableMapperEditing(boolean enable) {
        this.addMapperButton.setEnabled(enable);
        Arrays.stream(this.getComponents()).filter(c -> c instanceof MapperPanel).forEach(c -> ((MapperPanel)c).enableEditing(enable));
    }

    private void initComponents() {
        this.addMapperButton = new JButton();
        this.setLayout(new BoxLayout(this, 1));
        this.addMapperButton.setText("Add Mapper");
        this.addMapperButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapperCollectionPanel.this.addMapperButtonActionPerformed(evt);
            }
        });
        this.add(this.addMapperButton);
    }

    private void addMapperButtonActionPerformed(ActionEvent evt) {
        this.addNewMapper();
    }

    public void receiveUpdate(StatusUpdate update) {
        switch (update.getType()) {
            case SEQUENCE_START: {
                this.enableMapperEditing(false);
                this.saveMappersToConfig();
                break;
            }
            case SEQUENCE_STOPPED: 
            case SEQUENCE_END: 
            case SEQUENCE_PAUSE: {
                this.enableMapperEditing(true);
            }
        }
    }
}

