//------------------------------------------------------------------------------
// SIGMOID
//------------------------------------------------------------------------------
#include <math.h>
#include <stdint.h>

float fast_exp(float x)
{
	union {
		uint32_t i;
		float f;
	} v;
	v.i = (1 << 23) * (1.4426950409 * x + 126.93490512f);
	return v.f;
}

float sigmoid_alt1(float x)
{
	return 1 / (1 + fast_exp(-x));
}

float sigmoid_alt2(float x)
{
	return (x / (1 + fabs(x))) * 0.5 + 0.5;
}

// -5~5, 256+1 level
static float sigmoid_tab[] = {
	0.0067, 0.0070, 0.0072, 0.0075, 0.0078, 0.0081, 0.0084, 0.0088, 0.0091, 0.0095, 0.0099, 0.0102, 0.0107, 0.0111, 0.0115, 0.0120, 0.0124, 0.0129, 0.0134, 0.0140, 0.0145, 0.0151, 0.0157, 0.0163, 0.0169, 0.0176, 0.0183, 0.0190, 0.0197, 0.0205, 0.0213, 0.0221, 0.0230, 0.0239, 0.0248, 0.0258, 0.0268, 0.0278, 0.0289, 0.0300, 0.0311, 0.0323, 0.0336, 0.0349, 0.0362, 0.0376, 0.0390, 0.0405, 0.0421, 0.0437, 0.0454, 0.0471, 0.0489, 0.0507, 0.0526, 0.0546, 0.0567, 0.0588, 0.0610, 0.0633, 0.0656, 0.0680, 0.0706, 0.0732, 0.0759, 0.0786, 0.0815, 0.0845, 0.0876, 0.0907, 0.0940, 0.0974, 0.1009, 0.1045, 0.1082, 0.1120, 0.1160, 0.1200, 0.1242, 0.1285, 0.1330, 0.1375, 0.1422, 0.1471, 0.1520, 0.1571, 0.1624, 0.1678, 0.1733, 0.1790, 0.1848, 0.1907, 0.1968, 0.2031, 0.2095, 0.2160, 0.2227, 0.2295, 0.2365, 0.2436, 0.2509, 0.2583, 0.2659, 0.2736, 0.2814, 0.2894, 0.2975, 0.3057, 0.3141, 0.3225, 0.3311, 0.3398, 0.3486, 0.3576, 0.3666, 0.3757, 0.3849, 0.3942, 0.4036, 0.4130, 0.4225, 0.4321, 0.4417, 0.4513, 0.4610, 0.4707, 0.4805, 0.4902, 0.5000, 0.5098, 0.5195, 0.5293, 0.5390, 0.5487, 0.5583, 0.5679, 0.5775, 0.5870, 0.5964, 0.6058, 0.6151, 0.6243, 0.6334, 0.6424, 0.6514, 0.6602, 0.6689, 0.6775, 0.6859, 0.6943, 0.7025, 0.7106, 0.7186, 0.7264, 0.7341, 0.7417, 0.7491, 0.7564, 0.7635, 0.7705, 0.7773, 0.7840, 0.7905, 0.7969, 0.8032, 0.8093, 0.8152, 0.8210, 0.8267, 0.8322, 0.8376, 0.8429, 0.8480, 0.8529, 0.8578, 0.8625, 0.8670, 0.8715, 0.8758, 0.8800, 0.8840, 0.8880, 0.8918, 0.8955, 0.8991, 0.9026, 0.9060, 0.9093, 0.9124, 0.9155, 0.9185, 0.9214, 0.9241, 0.9268, 0.9294, 0.9320, 0.9344, 0.9367, 0.9390, 0.9412, 0.9433, 0.9454, 0.9474, 0.9493, 0.9511, 0.9529, 0.9546, 0.9563, 0.9579, 0.9595, 0.9610, 0.9624, 0.9638, 0.9651, 0.9664, 0.9677, 0.9689, 0.9700, 0.9711, 0.9722, 0.9732, 0.9742, 0.9752, 0.9761, 0.9770, 0.9779, 0.9787, 0.9795, 0.9803, 0.9810, 0.9817, 0.9824, 0.9831, 0.9837, 0.9843, 0.9849, 0.9855, 0.9860, 0.9866, 0.9871, 0.9876, 0.9880, 0.9885, 0.9889, 0.9893, 0.9898, 0.9901, 0.9905, 0.9909, 0.9912, 0.9916, 0.9919, 0.9922, 0.9925, 0.9928, 0.9930, 0.9933
};

float sigmoid_alt3(float x)
{
	if (x > 5) {
		return 1;
	}
	if (x < -5) {
		return 0;
	}

	int index = (int)(x * 25.6) + 128;

	return sigmoid_tab[index];
}

float inv_sigmoid(float x)
{
	return -log((1 - x) / x);
}
