/*
 * Realtek Semiconductor Corp.
 *
 * librtscamkit/rts_errno.h
 *
 * Copyright (C) 2014      Ming Qian<ming_qian@realsil.com.cn>
 */
#ifndef _RTS_ERRNO_H
#define _RTS_ERRNO_H

#ifndef RTS_RETURN
#define RTS_RETURN(e)		(-(e))
#endif

#ifndef RTS_ERRNO
#define RTS_ERRNO(r)	((r) < 0 ? (-(r)) : (r))
#endif

enum RTS_ERRNO {
	RTS_OK = 0,
	RTS_FAIL,
	RTS_E_NULL_POINT = 10,
	RTS_E_NO_MEMORY,
	RTS_E_NOT_REALIZED,
	RTS_E_EXIST,
	RTS_E_NOT_EXIST,
	RTS_E_NOT_FOUND,
	RTS_E_NOT_REGISTERED,
	RTS_E_NOT_READY,
	RTS_E_EMPTY,
	RTS_E_NOT_EMPTY,
	RTS_E_FULL,
	RTS_E_INVALID_ARG,
	RTS_E_INVALID_TYPE,
	RTS_E_NOT_MATCH,
	RTS_E_OPEN_FAIL,
	RTS_E_CLOSE_FAIL,
	RTS_E_NOT_OPEN,
	RTS_E_GET_FAIL,
	RTS_E_SET_FAIL,
	RTS_E_NOT_SUPPORT,
	RTS_E_INITIALIZED,
	RTS_E_NOT_INITIALIZED,
	RTS_E_INUSE,
	RTS_E_WRITE_FAIL,
	RTS_E_READ_FAIL,
	RTS_E_LOCK_FAIL,
	RTS_E_INVALID_LENGTH,
	RTS_E_TIMEOUT,
	RTS_E_THREAD_FAIL,
	RTS_E_OVERFLOW,
	RTS_E_BIG,
	RTS_E_PERM,
	RTS_E_NO_ENT,
	RTS_E_IO,
	RTS_E_AGAIN,
	RTS_E_NO_DEV,
	RTS_E_NO_SYS,
	RTS_E_IOCTL,
	RTS_E_LESS_DATA,
	RTS_E_OUT_OF_RANGE,
	RTS_E_MMAP_FAIL,
	RTS_E_MUNMAP_FAIL,
	RTS_E_INVALID_DATA,
	RTS_E_NO_REALIZED,
	RTS_E_INVALID_VERSION,
	RTS_E_UNKNOWN,
	RTS_E_RECEIVE_FAIL,
	RTS_E_SEND_FAIL,
	RTS_E_DISCONNECT,
	RTS_E_SAVE_FAIL,
	RTS_E_CMP_FAIL,
	RTS_E_ERASE_FAIL,
	RTS_E_RESET_FAIL,
	RTS_E_DISABLE,
};

char *rts_strerrno(int errnum);

#endif

