/*
** Copyright 2001, Travis Geiselbrecht. All rights reserved.
** Distributed under the terms of the NewOS License.
*/
/*
 * Copyright (c) 2008 Travis Geiselbrecht
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdlib.h>
#include "rtl_ctype.h"
#include "atoi.h"

#define LONG_IS_INT 1

static int hexval(char c)
{
	if (c >= '0' && c <= '9') {
		return c - '0';
	} else if (c >= 'a' && c <= 'f') {
		return c - 'a' + 10;
	} else if (c >= 'A' && c <= 'F') {
		return c - 'A' + 10;
	}

	return 0;
}

int _atoi(const char *num)
{
#if !LONG_IS_INT
	// XXX fail
#else
	return _atol(num);
#endif
}

unsigned int _atoui(const char *num)
{
#if !LONG_IS_INT
	// XXX fail
#else
	return _atoul(num);
#endif
}

long _atol(const char *num)
{
	long value = 0;
	int neg = 0;

	if (num[0] == '0' && num[1] == 'x') {
		// hex
		num += 2;
		while (*num && isxdigit(*num)) {
			value = value * 16 + hexval(*num++);
		}
	} else {
		// decimal
		if (num[0] == '-') {
			neg = 1;
			num++;
		}
		while (*num && isdigit(*num)) {
			value = value * 10 + *num++  - '0';
		}
	}

	if (neg) {
		value = -value;
	}

	return value;
}

unsigned long _atoul(const char *num)
{
	unsigned long value = 0;
	if (num[0] == '0' && num[1] == 'x') {
		// hex
		num += 2;
		while (*num && isxdigit(*num)) {
			value = value * 16 + hexval(*num++);
		}
	} else {
		// decimal
		while (*num && isdigit(*num)) {
			value = value * 10 + *num++  - '0';
		}
	}

	return value;
}

unsigned long long _atoull(const char *num)
{
	unsigned long long value = 0;
	if (num[0] == '0' && num[1] == 'x') {
		// hex
		num += 2;
		while (*num && isxdigit(*num)) {
			value = value * 16 + hexval(*num++);
		}
	} else {
		// decimal
		while (*num && isdigit(*num)) {
			value = value * 10 + *num++  - '0';
		}
	}

	return value;
}

