/**************************************************************************//**
 * @file     rtl8735b_ecdsa.h
 * @brief    This file defines crypto type ,device address and declare device module macro variables.
 * @version  1.0
 * @date     9. July 2018
 * @note     Generated by SVDConv V3.3.9 on Thursday, 21.09.2017 17:03:48
 *           from File 'rtl8710c_crypto.svd',
 *           last modified on Thursday, 21.09.2017 09:03:15
 *
 *******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ******************************************************************************/

#ifndef RTL8735B_ECDSA_H
#define RTL8735B_ECDSA_H

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @addtogroup hal_rtl_ecdsa ECDSA
 * @{
 */

#include "basic_types.h"
#include "rtl8735b_ecdsa_type.h"
#include "rtl8735b_syson_s_type.h"
#include "rtl8735b.h"
#include "hal_irq.h"

/**
  \brief  Define the ECDSA port ID.
*/
enum  ecdsa_id_e {
	ECDSA_id   =   0x0,
	ECDSA_Max_Id  =   0x1
};
typedef uint8_t ecdsa_id_t;

/**
  \brief  Define the ECDSA Curve.
*/
enum  ecdsa_curve_e {
	ECDSA_SPEC256K1     =   0x0,
	ECDSA_P256          =   0x1,
	ECDSA_CURVE25519_W  =   0x2,
	ECDSA_OTHERS        =   0x3
};
typedef uint8_t ecdsa_curve_t;

/**
  \brief  Define the ECDSA Mode.
*/
enum  ecdsa_mode_e {
	ECDSA_VERI          =   0x0,
	ECDSA_SIGN          =   0x1,
	ECDSA_SCALAR_MUL    =   0x2,
	ECDSA_BASIC_FUNC    =   0x3
};
typedef uint8_t ecdsa_mode_t;

/**
  \brief  Define the ECDSA basic function.
*/
enum  ecdsa_basic_func_e {
	ECDSA_FIELD_SUB     =   0x0,
	ECDSA_FIELD_DIV     =   0x1,
	ECDSA_FIELD_ADD     =   0x2,
	ECDSA_FIELD_MUL     =   0x3,
	ECDSA_POINT_ADD     =   0x4,
	ECDSA_NONE          =   0x5
};
typedef uint8_t ecdsa_basic_func_t;

/**
  \brief  Define the ECDSA bit length.
*/
enum  ecdsa_bit_num_e {
	ECDSA_256_BIT       =   0x0,
	ECDSA_224_BIT       =   0x1,
	ECDSA_192_BIT       =   0x2,
	ECDSA_160_BIT       =   0x3,
	ECDSA_128_BIT       =   0x4,
	ECDSA_112_BIT       =   0x5,
	ECDSA_232_BIT       =   0x9,
	ECDSA_200_BIT       =   0xA,
	ECDSA_168_BIT       =   0xB,
	ECDSA_136_BIT       =   0xC,
	ECDSA_120_BIT       =   0xD,
};
typedef uint8_t ecdsa_bit_num_t;

/**
  \brief  Define the private key of ECDSA.
*/
enum  ecdsa_sel_prk_e {
	ECDSA_INPUT_PRK     =   0x0,
	ECDSA_OTP_PRK_1     =   0x1,
	ECDSA_OTP_PRK_2     =   0x2
};
typedef uint8_t ecdsa_sel_prk_t;

/**
  \brief Describe ECDSA input table
*/
typedef struct hal_ecdsa_table_s {
	u32 *ppriv_key;     /*!< Private key x address  */
	u32 *prdk;       /*!< Random K address  */
	u32 *ppub_key_x;    /*!< Public key x address  */
	u32 *ppub_key_y;    /*!< Public key y address  */
	u32 *phash;         /*!< Hash address  */
	u32 *pr_adr;        /*!< R address  */
	u32 *ps_adr;        /*!< S address  */
	u32 *ppoint_x;      /*!< Base point x address  */
	u32 *ppoint_y;      /*!< Base point y addres  */
	u32 *pa_adr;        /*!< Curve cor_a addres */
	u32 *pprime;        /*!< Prime addres */
	u32 *porder_n;      /*!< Order_n addres */
} hal_ecdsa_table_t, *phal_ecdsa_table_t;

/**
  \brief Describe ECDSA curve table
*/
typedef struct hal_ecdsa_curve_table_s {
	u32 *ppoint_x;      /*!< Base point x address  */
	u32 *ppoint_y;      /*!< Base point y addres  */
	u32 *pa_adr;        /*!< Curve cor_a addres */
	u32 *pprime;        /*!< Prime addres */
	u32 *porder_n;      /*!< Order_n addres */
} hal_ecdsa_curve_table_t, *phal_ecdsa_curve_table_t;

/**
  \brief Describe ECDSA verification input
*/
typedef struct hal_ecdsa_veri_input_s {
	u32 *ppub_key_x;    /*!< Public key x address  */
	u32 *ppub_key_y;    /*!< Public key y address  */
	u32 *pr_adr;        /*!< R address  */
	u32 *ps_adr;        /*!< S address  */
} hal_ecdsa_veri_input_t, *phal_ecdsa_veri_input_t;


/**
  \brief  ECDSA call back function for the interrupt event.
*/
typedef void (*ecdsa_irq_user_cb_t)(void *);

/**
  \brief  The data structure for an ECDSA HAL operations.
*/
typedef struct hal_ecdsa_adapter_s {
	ECDSA_TypeDef *base_addr;          /*! The ECDSA register base address */
	ecdsa_irq_user_cb_t ecdsa_irq_user_cb;
	u32 *ecdsa_user_arg;
	//hal_ecdsa_table_t ecdsa_table;
} hal_ecdsa_adapter_t, *phal_ecdsa_adapter_t;

/**
  \brief  The data structure to handle multiple ECDSA adapters.
*/
typedef struct hal_ecdsa_group_adapter_s {
	volatile uint32_t critical_lv;                  /*!< to record ECDSA HAL enter critical section level */
	hal_ecdsa_adapter_t *pecdsa_adapter[ECDSA_Max_Id];    /*!< All the ECDSA adapters of this platform */
	irq_handler_t   irq_fun[ECDSA_Max_Id];            /*!< the IRQ handler for different ECDSA adapters */
} hal_ecdsa_group_adapter_t, *phal_ecdsa_group_adapter_t;

/// @cond DOXYGEN_ROM_HAL_API

/**
 * @addtogroup hal_rtl_ecdsa_func ECDSA HAL ROM APIs.
 * @{
 */

void hal_rtl_ecdsa_irq_reg(void);
void hal_rtl_ecdsa_irq_unreg(void);
void hal_rtl_ecdsa_init_clk_ctrl(hal_ecdsa_adapter_t *pecdsa_adapter);
void hal_rtl_ecdsa_deinit_clk_ctrl(hal_ecdsa_adapter_t *pecdsa_adapter);
HAL_Status hal_rtl_ecdsa_init(hal_ecdsa_adapter_t *pecdsa_adapter);
HAL_Status hal_rtl_ecdsa_deinit(hal_ecdsa_adapter_t *pecdsa_adapter);
void hal_rtl_ecdsa_reset(hal_ecdsa_adapter_t *pecdsa_adapter);
void hal_rtl_ecdsa_clr_finish_int(hal_ecdsa_adapter_t *pecdsa_adapter);
void hal_rtl_ecdsa_mask_finish_int(hal_ecdsa_adapter_t *pecdsa_adapter, uint8_t enable);
void hal_rtl_ecdsa_set_curve(hal_ecdsa_adapter_t *pecdsa_adapter, ecdsa_curve_t curve, hal_ecdsa_curve_table_t *pcurve_table, ecdsa_bit_num_t bit_num);
void hal_rtl_ecdsa_set_mode(hal_ecdsa_adapter_t *pecdsa_adapter, ecdsa_mode_t mode, ecdsa_basic_func_t func);
void hal_rtl_ecdsa_set_bit_num(hal_ecdsa_adapter_t *pecdsa_adapter, ecdsa_bit_num_t bit_num);
void hal_rtl_ecdsa_start_en(hal_ecdsa_adapter_t *pecdsa_adapter, uint8_t enable);
void hal_rtl_ecdsa_hash_en(hal_ecdsa_adapter_t *pecdsa_adapter, uint8_t enable);
void hal_rtl_ecdsa_hash_256_en(hal_ecdsa_adapter_t *pecdsa_adapter, uint8_t enable);
void hal_rtl_ecdsa_select_prk(hal_ecdsa_adapter_t *pecdsa_adapter, ecdsa_sel_prk_t sel_prk);
void hal_rtl_ecdsa_set_prk(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppriv_key);
void hal_rtl_ecdsa_set_random_k(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *prdk);
void hal_rtl_ecdsa_set_pbk(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppub_key_x, uint32_t *ppub_key_y);
void hal_rtl_ecdsa_set_hash(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *phash);
void hal_rtl_ecdsa_set_rs(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *pr_adr, uint32_t *ps_adr);
void hal_rtl_ecdsa_set_base_point(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppoint_x, uint32_t *ppoint_y);
void hal_rtl_ecdsa_set_base_point_2(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppoint_x, uint32_t *ppoint_y);
void hal_rtl_ecdsa_set_cor_a(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *pa_adr);
void hal_rtl_ecdsa_set_prime(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *pprime);
void hal_rtl_ecdsa_set_order_n(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *porder_n);
void hal_rtl_ecdsa_get_result_x_y(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *prx_adr, uint32_t *pry_adr);
uint32_t hal_rtl_ecdsa_get_veri_result(hal_ecdsa_adapter_t *pecdsa_adapter);
uint32_t hal_rtl_ecdsa_get_veri_err_sta(hal_ecdsa_adapter_t *pecdsa_adapter);
uint32_t hal_rtl_ecdsa_get_inf_err_sta(hal_ecdsa_adapter_t *pecdsa_adapter);
uint32_t hal_rtl_ecdsa_get_finish_sta(hal_ecdsa_adapter_t *pecdsa_adapter);
void hal_rtl_ecdsa_get_pbk(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppub_key_x, uint32_t *ppub_key_y);
void hal_rtl_ecdsa_get_rs(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *pr_adr, uint32_t *ps_adr);
uint32_t hal_rtl_ecdsa_get_sign_err_sta(hal_ecdsa_adapter_t *pecdsa_adapter);
uint32_t hal_rtl_ecdsa_get_scal_mul_err_sta(hal_ecdsa_adapter_t *pecdsa_adapter);
uint32_t hal_rtl_ecdsa_get_err_sta(hal_ecdsa_adapter_t *pecdsa_adapter);
uint32_t hal_rtl_ecdsa_get_idle_sta(hal_ecdsa_adapter_t *pecdsa_adapter);
void hal_rtl_ecdsa_verify(hal_ecdsa_adapter_t *pecdsa_adapter, hal_ecdsa_veri_input_t *pveri_input);
void hal_rtl_ecdsa_signature(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppriv_key, uint32_t *prdk);
void hal_rtl_ecdsa_hash(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *phash);
void hal_rtl_ecdsa_gen_public_key(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppriv_key, uint32_t *ppoint_x, uint32_t *ppoint_y);
void hal_rtl_ecdsa_cb_handler(hal_ecdsa_adapter_t *pecdsa_adapter, ecdsa_irq_user_cb_t callback, void *arg);


/** @} */ /* End of group hal_rtl_ecdsa_func */
/// @endcond /* End of condition DOXYGEN_ROM_HAL_API */

/**
  \brief  The data structure of the stubs function for the ECDSA HAL functions in ROM
*/
typedef struct hal_ecdsa_func_stubs_s {
	hal_ecdsa_group_adapter_t *pecdsa_group_adapter;
	void (*hal_ecdsa_irq_reg)(void);
	void (*hal_ecdsa_irq_unreg)(void);
	void (*hal_ecdsa_init_clk_ctrl)(hal_ecdsa_adapter_t *pecdsa_adapter);
	void (*hal_ecdsa_deinit_clk_ctrl)(hal_ecdsa_adapter_t *pecdsa_adapter);
	HAL_Status(*hal_ecdsa_init)(hal_ecdsa_adapter_t *pecdsa_adapter);
	HAL_Status(*hal_ecdsa_deinit)(hal_ecdsa_adapter_t *pecdsa_adapter);
	void (*hal_ecdsa_reset)(hal_ecdsa_adapter_t *pecdsa_adapter);
	void (*hal_ecdsa_clr_finish_int)(hal_ecdsa_adapter_t *pecdsa_adapter);
	void (*hal_ecdsa_mask_finish_int)(hal_ecdsa_adapter_t *pecdsa_adapter, uint8_t enable);
	void (*hal_ecdsa_set_curve)(hal_ecdsa_adapter_t *pecdsa_adapter, ecdsa_curve_t curve, hal_ecdsa_curve_table_t *pcurve_table, ecdsa_bit_num_t bit_num);
	void (*hal_ecdsa_set_mode)(hal_ecdsa_adapter_t *pecdsa_adapter, ecdsa_mode_t mode, ecdsa_basic_func_t func);
	void (*hal_ecdsa_set_bit_num)(hal_ecdsa_adapter_t *pecdsa_adapter, ecdsa_bit_num_t bit_num);
	void (*hal_ecdsa_start_en)(hal_ecdsa_adapter_t *pecdsa_adapter, uint8_t enable);
	void (*hal_ecdsa_hash_en)(hal_ecdsa_adapter_t *pecdsa_adapter, uint8_t enable);
	void (*hal_ecdsa_hash_256_en)(hal_ecdsa_adapter_t *pecdsa_adapter, uint8_t enable);
	void (*hal_ecdsa_select_prk)(hal_ecdsa_adapter_t *pecdsa_adapter, ecdsa_sel_prk_t sel_prk);
	void (*hal_ecdsa_set_prk)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppriv_key);
	void (*hal_ecdsa_set_random_k)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *prdk);
	void (*hal_ecdsa_set_pbk)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppub_key_x, uint32_t *ppub_key_y);
	void (*hal_ecdsa_set_hash)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *phash);
	void (*hal_ecdsa_set_rs)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *pr_adr, uint32_t *ps_adr);
	void (*hal_ecdsa_set_base_point)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppoint_x, uint32_t *ppoint_y);
	void (*hal_ecdsa_set_base_point_2)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppoint_x, uint32_t *ppoint_y);
	void (*hal_ecdsa_set_cor_a)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *pa_adr);
	void (*hal_ecdsa_set_prime)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *pprime);
	void (*hal_ecdsa_set_order_n)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *porder_n);
	void (*hal_ecdsa_get_result_x_y)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *prx_adr, uint32_t *pry_adr);
	uint32_t (*hal_ecdsa_get_veri_result)(hal_ecdsa_adapter_t *pecdsa_adapter);
	uint32_t (*hal_ecdsa_get_veri_err_sta)(hal_ecdsa_adapter_t *pecdsa_adapter);
	uint32_t (*hal_ecdsa_get_inf_err_sta)(hal_ecdsa_adapter_t *pecdsa_adapter);
	uint32_t (*hal_ecdsa_get_finish_sta)(hal_ecdsa_adapter_t *pecdsa_adapter);
	void (*hal_ecdsa_get_pbk)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppub_key_x, uint32_t *ppub_key_y);
	void (*hal_ecdsa_get_rs)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *pr_adr, uint32_t *ps_adr);
	uint32_t (*hal_ecdsa_get_sign_err_sta)(hal_ecdsa_adapter_t *pecdsa_adapter);
	uint32_t (*hal_ecdsa_get_scal_mul_err_sta)(hal_ecdsa_adapter_t *pecdsa_adapter);
	uint32_t (*hal_ecdsa_get_err_sta)(hal_ecdsa_adapter_t *pecdsa_adapter);
	uint32_t (*hal_ecdsa_get_idel_sta)(hal_ecdsa_adapter_t *pecdsa_adapter);
	void (*hal_ecdsa_verify)(hal_ecdsa_adapter_t *pecdsa_adapter, hal_ecdsa_veri_input_t *pveri_input);
	void (*hal_ecdsa_signature)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppriv_key, uint32_t *prdk);
	void (*hal_ecdsa_hash)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *phash);
	void (*hal_ecdsa_gen_public_key)(hal_ecdsa_adapter_t *pecdsa_adapter, uint32_t *ppriv_key, uint32_t *ppoint_x, uint32_t *ppoint_y);
	void (*hal_ecdsa_cb_handler)(hal_ecdsa_adapter_t *pecdsa_adapter, ecdsa_irq_user_cb_t callback, void *arg);
	uint32_t reserved[5];  // reserved space for next ROM code version function table extending.
} hal_ecdsa_func_stubs_t;

/** @} */ /* End of group hal_rtl_ecdsa */

#ifdef __cplusplus
}
#endif

#endif  // #ifndef _RTL8735B_ECDSA_H_


