/*
 * Decompiled with CFR 0.152.
 */
package fiji.packaging;

import fiji.packaging.TarBz2Packager;
import fiji.packaging.TarGzPackager;
import fiji.packaging.TarPackager;
import fiji.packaging.ZipPackager;
import ij.IJ;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.imagej.updater.Checksummer;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.util.Progress;

public abstract class Packager {
    protected File ijDir;
    protected Collection<String> files;
    protected String prefix = "Fiji.app/";
    protected byte[] buffer = new byte[16384];
    private static Adapter adapter;

    public abstract String getExtension();

    public abstract void open(OutputStream var1) throws IOException;

    public abstract void putNextEntry(String var1, boolean var2, int var3) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void closeEntry() throws IOException;

    public abstract void close() throws IOException;

    public void write(InputStream in) throws IOException {
        int count;
        while ((count = in.read(this.buffer)) >= 0) {
            this.write(this.buffer, 0, count);
        }
        in.close();
    }

    public void setRootDirectory(File rootDirectory) {
        this.ijDir = rootDirectory;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void initialize(boolean includeJRE, String ... platforms) throws Exception {
        if (System.getProperty("ij.dir") == null) {
            throw new UnsupportedOperationException("Need an ij.dir property pointing to the ImageJ root!");
        }
        String ijDirProperty = System.getProperty("imagej.dir");
        if (ijDirProperty == null) {
            ijDirProperty = System.getProperty("ij.dir");
        }
        this.ijDir = new File(ijDirProperty);
        this.files = new LinkedHashSet<String>();
        this.files.add("db.xml.gz");
        for (String fileName : new String[]{"ImageJ", "ImageJ.exe", "ImageJ.sh"}) {
            if (!new File(this.ijDir, fileName).exists()) continue;
            this.files.add("ImageJ");
        }
        this.files.add("Contents/Info.plist");
        adapter.getFileList(this.files, this.ijDir, platforms);
        if (includeJRE) {
            this.getJREFiles(platforms);
        }
    }

    public void addDefaultFiles() throws IOException {
        boolean logToStdout;
        boolean bl = logToStdout = IJ.getInstance() == null;
        if (logToStdout) {
            System.out.println("Writing files");
        } else {
            IJ.showStatus((String)"Writing files");
        }
        int count = 0;
        for (String fileName : this.files) {
            this.addFile(fileName, false);
            if (logToStdout) {
                System.out.print(".");
                continue;
            }
            IJ.showProgress((int)count++, (int)this.files.size());
        }
        if (logToStdout) {
            System.out.println();
        }
    }

    private void getJREFiles(String ... platforms) throws IOException {
        File javaDir = new File(this.ijDir, "java");
        ArrayList<String> directories = new ArrayList<String>();
        if (platforms.length == 0) {
            String[] candidates = javaDir.list(new NoHiddenFiles());
            if (candidates == null) {
                throw new IOException("No JREs found in " + javaDir);
            }
            for (String candidate : candidates) {
                String dir = this.getNewestJRE("java/" + candidate);
                if (dir == null) continue;
                directories.add(dir);
            }
        } else {
            for (int i = 0; i < platforms.length; ++i) {
                String platform = platforms[i];
                String dir = this.getNewestJRE("java/" + platform);
                if (dir == null) {
                    if ("linux32".equals(platform)) {
                        dir = "linux";
                    } else if ("linux64".equals(platform)) {
                        dir = "linux-amd64";
                    } else if ("macosx".equals(platform) || "tiger".equals(platform)) {
                        dir = "macosx-java3d";
                    }
                    if ("macosx-java3d".equals(dir)) {
                        dir = "java/" + dir + "/Home";
                        if (!new File(this.ijDir, dir).isDirectory()) continue;
                        directories.add(dir);
                        continue;
                    }
                    dir = this.getNewestJRE("java/" + dir);
                    if (dir == null) {
                        System.err.println("No JRE found for platform '" + platform + "'");
                        System.exit(1);
                    }
                }
                directories.add(dir);
            }
        }
        for (String dir : directories) {
            this.getFilesInDirectory(dir);
        }
    }

    private String getNewestJRE(String dirName) {
        File[] list = new File(this.ijDir, dirName).listFiles();
        if (list == null) {
            return null;
        }
        File result = null;
        for (File file : list) {
            File jre;
            if (!file.isDirectory() || !(jre = new File(file, "jre")).isDirectory() || result != null && result.lastModified() >= jre.lastModified()) continue;
            result = file;
        }
        if (result == null) {
            return null;
        }
        return dirName + "/" + result.getName() + "/jre";
    }

    private boolean getFilesInDirectory(String dirName) throws IOException {
        File[] list = new File(this.ijDir, dirName).listFiles(new NoHiddenFiles());
        if (list == null) {
            return false;
        }
        boolean result = true;
        for (File file : list) {
            if (file.isDirectory()) {
                result = this.getFilesInDirectory(dirName + "/" + file.getName()) && result;
                continue;
            }
            if (!file.isFile()) continue;
            result = this.files.add(dirName + "/" + file.getName()) && result;
        }
        return result;
    }

    public boolean addFile(String fileName, boolean executable) throws IOException {
        File file;
        if (fileName.equals("ImageJ-macosx") || fileName.equals("ImageJ-tiger")) {
            fileName = "Contents/MacOS/" + fileName;
        }
        if (!(file = new File(this.ijDir, fileName)).exists()) {
            return false;
        }
        try {
            this.putNextEntry(this.prefix + fileName, executable || file.canExecute(), (int)file.length());
            this.write(new FileInputStream(file));
            this.closeEntry();
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("File name too long")) {
                System.err.println("Skipping: " + e.getMessage());
            }
            throw e;
        }
        return true;
    }

    protected static String getPlatform() {
        boolean is64bit = System.getProperty("os.arch", "").indexOf("64") >= 0;
        String osName = System.getProperty("os.name", "<unknown>");
        if (osName.equals("Linux")) {
            return "linux" + (is64bit ? "64" : "32");
        }
        if (osName.equals("Mac OS X")) {
            return "macosx";
        }
        if (osName.startsWith("Windows")) {
            return "win" + (is64bit ? "64" : "32");
        }
        return osName.toLowerCase();
    }

    public static void main(String[] args) {
        int i;
        boolean includeJRE = false;
        String[] platforms = new String[]{};
        String prefix = null;
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if (args[i].equals("--jre")) {
                includeJRE = true;
                continue;
            }
            if (args[i].startsWith("--platforms=")) {
                platforms = args[i].substring("--platforms=".length()).split(",");
                if (platforms.length != 1 || !"".equals(platforms[0])) continue;
                platforms = new String[]{};
                continue;
            }
            if (args[i].startsWith("-Dij.dir=")) {
                System.setProperty("ij.dir", args[i].substring("-Dij.dir=".length()));
                continue;
            }
            if (args[i].startsWith("--prefix=")) {
                prefix = args[i].substring("--prefix=".length());
                if (prefix.endsWith("/")) continue;
                prefix = prefix + "/";
                continue;
            }
            System.err.println("Unknown option: " + args[i]);
            System.exit(1);
        }
        Packager packager = null;
        if (i + 1 == args.length) {
            if (args[i].endsWith(".zip")) {
                packager = new ZipPackager();
            } else if (args[i].endsWith(".tar")) {
                packager = new TarPackager();
            } else if (args[i].endsWith(".tar.gz") || args[0].endsWith(".tgz")) {
                packager = new TarGzPackager();
            } else if (args[i].endsWith(".tar.bz2") || args[0].endsWith(".tbz")) {
                try {
                    packager = new TarBz2Packager();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                System.err.println("Unsupported archive format: " + args[i]);
                System.exit(1);
            }
        } else {
            System.err.println("Usage: Package_Maker [--platform=<platform>[,<platform>]] [--jre] [--prefix=<directory>] <filename>");
            System.exit(1);
        }
        String path = args[i];
        if (prefix != null) {
            packager.setPrefix(prefix);
        }
        try {
            packager.initialize(includeJRE, platforms);
            packager.open(new FileOutputStream(path));
            packager.addDefaultFiles();
            packager.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error writing " + path);
            System.exit(1);
        }
    }

    static {
        try {
            adapter = new ModernUpdater();
        }
        catch (Throwable t) {
            t.printStackTrace();
            adapter = new LegacyUpdater();
        }
    }

    private static class NoHiddenFiles
    implements FilenameFilter {
        private NoHiddenFiles() {
        }

        @Override
        public boolean accept(File file, String name) {
            return !name.startsWith(".");
        }
    }

    private static class LegacyUpdater
    implements Adapter {
        final Class<?> filesCollectionClass;
        final Class<?> fileObjectClass;
        final Class<?> checksummerClass;
        final Class<?> progressClass;
        final Class<?> stderrProgressClass;
        final Constructor<?> filesCollectionConstructor;
        final Constructor<?> stderrProgressConstructor;
        final Constructor<?> checksummerConstructor;
        final Method updateFromLocal;
        final Method sort;
        final Method getLocalFilename;
        final Method getPlatforms;
        final Method isForPlatform;

        private LegacyUpdater() {
            ClassLoader loader = this.getClass().getClassLoader();
            try {
                this.filesCollectionClass = loader.loadClass("imagej.updater.core.FilesCollection");
                this.filesCollectionConstructor = this.filesCollectionClass.getConstructor(File.class);
                this.sort = this.filesCollectionClass.getMethod("sort", new Class[0]);
                this.fileObjectClass = loader.loadClass("imagej.updater.core.FileObject");
                this.getLocalFilename = this.fileObjectClass.getMethod("getLocalFilename", Boolean.TYPE);
                this.getPlatforms = this.fileObjectClass.getMethod("getPlatforms", new Class[0]);
                this.isForPlatform = this.fileObjectClass.getMethod("isForPlatform", String.class);
                this.progressClass = loader.loadClass("imagej.updater.util.Progress");
                this.stderrProgressClass = loader.loadClass("imagej.updater.util.StderrProgress");
                this.stderrProgressConstructor = this.stderrProgressClass.getConstructor(new Class[0]);
                this.checksummerClass = loader.loadClass("imagej.updater.core.Checksummer");
                this.checksummerConstructor = this.checksummerClass.getConstructor(this.filesCollectionClass, this.progressClass);
                this.updateFromLocal = this.checksummerClass.getMethod("updateFromLocal", new Class[0]);
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        }

        @Override
        public void getFileList(Collection<String> list, File ijDir, String ... platforms) {
            try {
                Object files = this.filesCollectionConstructor.newInstance(ijDir);
                Object progress = this.stderrProgressConstructor.newInstance(new Object[0]);
                Object checksummer = this.checksummerConstructor.newInstance(files, progress);
                this.updateFromLocal.invoke(checksummer, new Object[0]);
                this.sort.invoke(files, new Object[0]);
                Iterable iterable = (Iterable)files;
                for (Object file : iterable) {
                    if (!this.isForPlatforms(file, platforms)) continue;
                    String path = (String)this.getLocalFilename.invoke(file, false);
                    list.add(path);
                }
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        }

        private boolean isForPlatforms(Object file, String ... platforms) {
            try {
                Iterable filePlatforms = (Iterable)this.getPlatforms.invoke(file, new Object[0]);
                if (platforms.length == 0 || !filePlatforms.iterator().hasNext()) {
                    return true;
                }
                for (String platform : platforms) {
                    Boolean matches = (Boolean)this.isForPlatform.invoke(file, platform);
                    if (!matches.booleanValue()) continue;
                    return true;
                }
                return false;
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        }
    }

    private static class ProgressAdapter
    implements Progress {
        private ProgressAdapter() {
        }

        public void setTitle(String title) {
            IJ.showStatus((String)title);
        }

        public void setCount(int count, int total) {
            IJ.showProgress((int)count, (int)total);
        }

        public void addItem(Object item) {
            IJ.showStatus((String)("" + item));
        }

        public void setItemCount(int count, int total) {
        }

        public void itemDone(Object item) {
        }

        public void done() {
            IJ.showStatus((String)"Finished checksumming");
        }
    }

    private static class ModernUpdater
    implements Adapter {
        private final Progress progress = IJ.getInstance() == null ? null : new ProgressAdapter();

        private ModernUpdater() {
        }

        @Override
        public void getFileList(Collection<String> list, File ijDir, String ... platforms) {
            FilesCollection files = new FilesCollection(ijDir);
            Checksummer checksummer = new Checksummer(files, this.progress);
            checksummer.updateFromLocal();
            files.sort();
            for (FileObject file : files) {
                if (!this.isForPlatforms(file, platforms)) continue;
                list.add(file.getLocalFilename(false));
            }
        }

        private boolean isForPlatforms(FileObject file, String ... platforms) {
            if (platforms.length == 0 || !file.getPlatforms().iterator().hasNext()) {
                return true;
            }
            for (String platform : platforms) {
                if (!file.isForPlatform(platform)) continue;
                return true;
            }
            return false;
        }
    }

    private static interface Adapter {
        public void getFileList(Collection<String> var1, File var2, String ... var3);
    }
}

